/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.blockmeta.chunkmeta;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.blockmeta.ChunkletStore;
import com.gmail.nossr50.util.blockmeta.chunkmeta.ChunkStore;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import org.bukkit.World;

public class PrimitiveChunkStore
implements ChunkStore {
    private static final long serialVersionUID = -1L;
    private transient boolean dirty = false;
    public boolean[][][] store;
    private static final int CURRENT_VERSION = 7;
    private static final int MAGIC_NUMBER = -362881349;
    private int cx;
    private int cz;
    private UUID worldUid;
    private transient int worldHeight;

    public PrimitiveChunkStore(World world, int cx, int cz) {
        this.cx = cx;
        this.cz = cz;
        this.worldUid = world.getUID();
        this.worldHeight = world.getMaxHeight();
        this.store = new boolean[16][16][this.worldHeight];
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public int getChunkX() {
        return this.cx;
    }

    @Override
    public int getChunkZ() {
        return this.cz;
    }

    @Override
    public boolean isTrue(int x, int y, int z) {
        return this.store[x][z][y];
    }

    @Override
    public void setTrue(int x, int y, int z) {
        this.store[x][z][y] = true;
        this.dirty = true;
    }

    @Override
    public void setFalse(int x, int y, int z) {
        this.store[x][z][y] = false;
        this.dirty = true;
    }

    @Override
    public boolean isEmpty() {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < this.worldHeight; ++y) {
                    if (!this.store[x][z][y]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void copyFrom(ChunkletStore otherStore) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < this.worldHeight; ++y) {
                    this.store[x][z][y] = otherStore.isTrue(x, y, z);
                }
            }
        }
        this.dirty = true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(-362881349);
        out.writeInt(7);
        out.writeLong(this.worldUid.getLeastSignificantBits());
        out.writeLong(this.worldUid.getMostSignificantBits());
        out.writeInt(this.cx);
        out.writeInt(this.cz);
        out.writeObject(this.store);
        this.dirty = false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int magic = in.readInt();
        int fileVersionNumber = in.readInt();
        if (magic != -362881349) {
            fileVersionNumber = 0;
        }
        long lsb = in.readLong();
        long msb = in.readLong();
        this.worldUid = new UUID(msb, lsb);
        this.cx = in.readInt();
        this.cz = in.readInt();
        World world = mcMMO.p.getServer().getWorld(this.worldUid);
        this.worldHeight = world.getMaxHeight();
        this.store = (boolean[][][])in.readObject();
        if (fileVersionNumber < 5) {
            this.fixArray();
            this.dirty = true;
        }
    }

    private void fixArray() {
        boolean[][][] temp = this.store;
        this.store = new boolean[16][16][this.worldHeight];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < this.worldHeight; ++y) {
                    try {
                        this.store[x][z][y] = temp[x][y][z];
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

