/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.blockmeta.chunkmeta;

import com.gmail.nossr50.util.blockmeta.chunkmeta.McMMOSimpleChunkBuffer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class McMMOSimpleRegionFile {
    private RandomAccessFile file;
    private final int[] dataStart = new int[1024];
    private final int[] dataActualLength = new int[1024];
    private final int[] dataLength = new int[1024];
    private final ArrayList<Boolean> inuse = new ArrayList();
    private int segmentSize;
    private int segmentMask;
    private final int rx;
    private final int rz;
    private final int defaultSegmentSize;
    private final File parent;
    private long lastAccessTime = System.currentTimeMillis();
    private static long TIMEOUT_TIME = 300000L;

    public McMMOSimpleRegionFile(File f, int rx, int rz) {
        this(f, rx, rz, 10);
    }

    public McMMOSimpleRegionFile(File f, int rx, int rz, int defaultSegmentSize) {
        this.rx = rx;
        this.rz = rz;
        this.defaultSegmentSize = defaultSegmentSize;
        this.parent = f;
        this.lastAccessTime = System.currentTimeMillis();
        if (this.file == null) {
            try {
                int i;
                this.file = new RandomAccessFile(this.parent, "rw");
                if (this.file.length() < 12288L) {
                    for (int i2 = 0; i2 < 3072; ++i2) {
                        this.file.writeInt(0);
                    }
                    this.file.seek(8192L);
                    this.file.writeInt(defaultSegmentSize);
                }
                this.file.seek(8192L);
                this.segmentSize = this.file.readInt();
                this.segmentMask = (1 << this.segmentSize) - 1;
                int reservedSegments = this.sizeToSegments(12288);
                for (i = 0; i < reservedSegments; ++i) {
                    while (this.inuse.size() <= i) {
                        this.inuse.add(false);
                    }
                    this.inuse.set(i, true);
                }
                this.file.seek(0L);
                for (i = 0; i < 1024; ++i) {
                    this.dataStart[i] = this.file.readInt();
                }
                for (i = 0; i < 1024; ++i) {
                    this.dataActualLength[i] = this.file.readInt();
                    this.dataLength[i] = this.sizeToSegments(this.dataActualLength[i]);
                    this.setInUse(i, true);
                }
                this.extendFile();
            }
            catch (IOException fnfe) {
                throw new RuntimeException(fnfe);
            }
        }
    }

    public final synchronized RandomAccessFile getFile() {
        this.lastAccessTime = System.currentTimeMillis();
        if (this.file == null) {
            try {
                int i;
                this.file = new RandomAccessFile(this.parent, "rw");
                if (this.file.length() < 12288L) {
                    for (int i2 = 0; i2 < 3072; ++i2) {
                        this.file.writeInt(0);
                    }
                    this.file.seek(8192L);
                    this.file.writeInt(this.defaultSegmentSize);
                }
                this.file.seek(8192L);
                this.segmentSize = this.file.readInt();
                this.segmentMask = (1 << this.segmentSize) - 1;
                int reservedSegments = this.sizeToSegments(12288);
                for (i = 0; i < reservedSegments; ++i) {
                    while (this.inuse.size() <= i) {
                        this.inuse.add(false);
                    }
                    this.inuse.set(i, true);
                }
                this.file.seek(0L);
                for (i = 0; i < 1024; ++i) {
                    this.dataStart[i] = this.file.readInt();
                }
                for (i = 0; i < 1024; ++i) {
                    this.dataActualLength[i] = this.file.readInt();
                    this.dataLength[i] = this.sizeToSegments(this.dataActualLength[i]);
                    this.setInUse(i, true);
                }
                this.extendFile();
            }
            catch (IOException fnfe) {
                throw new RuntimeException(fnfe);
            }
        }
        return this.file;
    }

    public synchronized boolean testCloseTimeout() {
        return false;
    }

    public synchronized DataOutputStream getOutputStream(int x, int z) {
        int index = this.getChunkIndex(x, z);
        return new DataOutputStream(new DeflaterOutputStream(new McMMOSimpleChunkBuffer(this, index)));
    }

    public synchronized DataInputStream getInputStream(int x, int z) throws IOException {
        int index = this.getChunkIndex(x, z);
        int actualLength = this.dataActualLength[index];
        if (actualLength == 0) {
            return null;
        }
        byte[] data = new byte[actualLength];
        this.getFile().seek(this.dataStart[index] << this.segmentSize);
        this.getFile().readFully(data);
        return new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(data)));
    }

    synchronized void write(int index, byte[] buffer, int size) throws IOException {
        int oldStart = this.setInUse(index, false);
        int start = this.findSpace(oldStart, size);
        this.getFile().seek(start << this.segmentSize);
        this.getFile().write(buffer, 0, size);
        this.dataStart[index] = start;
        this.dataActualLength[index] = size;
        this.dataLength[index] = this.sizeToSegments(size);
        this.setInUse(index, true);
        this.saveFAT();
    }

    public synchronized void close() {
        try {
            if (this.file != null) {
                this.file.seek(8192L);
                this.file.close();
            }
            this.file = null;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to close file", ioe);
        }
    }

    private synchronized int setInUse(int index, boolean used) {
        if (this.dataActualLength[index] == 0) {
            return this.dataStart[index];
        }
        int start = this.dataStart[index];
        int end = start + this.dataLength[index];
        for (int i = start; i < end; ++i) {
            while (i > this.inuse.size() - 1) {
                this.inuse.add(false);
            }
            Boolean old = this.inuse.set(i, used);
            if (old == null || old != used) continue;
            if (old.booleanValue()) {
                throw new IllegalStateException("Attempting to overwrite an in-use segment");
            }
            throw new IllegalStateException("Attempting to delete empty segment");
        }
        return this.dataStart[index];
    }

    private synchronized void extendFile() throws IOException {
        long extend = -this.getFile().length() & (long)this.segmentMask;
        this.getFile().seek(this.getFile().length());
        while (extend-- > 0L) {
            this.getFile().write(0);
        }
    }

    private synchronized int findSpace(int oldStart, int size) {
        int segments = this.sizeToSegments(size);
        boolean oldFree = true;
        for (int i = oldStart; i < this.inuse.size() && i < oldStart + segments; ++i) {
            if (!this.inuse.get(i).booleanValue()) continue;
            oldFree = false;
            break;
        }
        if (oldFree) {
            return oldStart;
        }
        int start = 0;
        int end = 0;
        while (end < this.inuse.size()) {
            if (this.inuse.get(end).booleanValue()) {
                start = ++end;
            } else {
                ++end;
            }
            if (end - start < segments) continue;
            return start;
        }
        return start;
    }

    private synchronized int sizeToSegments(int size) {
        if (size <= 0) {
            return 1;
        }
        return (size - 1 >> this.segmentSize) + 1;
    }

    private synchronized Integer getChunkIndex(int x, int z) {
        if (this.rx != x >> 5 || this.rz != z >> 5) {
            throw new RuntimeException(x + ", " + z + " not in region " + this.rx + ", " + this.rz);
        }
        return ((x &= 0x1F) << 5) + (z &= 0x1F);
    }

    private synchronized void saveFAT() throws IOException {
        int i;
        this.getFile().seek(0L);
        for (i = 0; i < 1024; ++i) {
            this.getFile().writeInt(this.dataStart[i]);
        }
        for (i = 0; i < 1024; ++i) {
            this.getFile().writeInt(this.dataActualLength[i]);
        }
    }
}

