/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.repair;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.skills.XPGainReason;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.repair.ArcaneForging;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.material.MaterialData;
import org.bukkit.permissions.Permissible;

public class RepairManager
extends SkillManager {
    private boolean placedAnvil;
    private int lastClick;

    public RepairManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.REPAIR);
    }

    public void placedAnvilCheck() {
        Player player = this.getPlayer();
        if (this.getPlacedAnvil()) {
            return;
        }
        if (Config.getInstance().getRepairAnvilMessagesEnabled()) {
            player.sendMessage(LocaleLoader.getString("Repair.Listener.Anvil"));
        }
        if (Config.getInstance().getRepairAnvilPlaceSoundsEnabled()) {
            player.playSound(player.getLocation(), Sound.ANVIL_LAND, 1.0f, 0.3f);
        }
        this.togglePlacedAnvil();
    }

    public void handleRepair(ItemStack item) {
        int minimumRepairableLevel;
        Repairable repairable;
        Player player = this.getPlayer();
        if (!Permissions.repairMaterialType((Permissible)player, (repairable = mcMMO.getRepairableManager().getRepairable(item.getType())).getRepairMaterialType())) {
            player.sendMessage(LocaleLoader.getString("mcMMO.NoPermission"));
            return;
        }
        if (!Permissions.repairItemType((Permissible)player, repairable.getRepairItemType())) {
            player.sendMessage(LocaleLoader.getString("mcMMO.NoPermission"));
            return;
        }
        int skillLevel = this.getSkillLevel();
        if (skillLevel < (minimumRepairableLevel = repairable.getMinimumLevel())) {
            player.sendMessage(LocaleLoader.getString("Repair.Skills.Adept", minimumRepairableLevel, StringUtils.getPrettyItemString(item.getType())));
            return;
        }
        PlayerInventory inventory = player.getInventory();
        Material repairMaterial = repairable.getRepairMaterial();
        byte repairMaterialMetadata = repairable.getRepairMaterialMetadata();
        ItemStack toRemove = new MaterialData(repairMaterial, repairMaterialMetadata).toItemStack(1);
        short startDurability = item.getDurability();
        if (startDurability <= 0) {
            player.sendMessage(LocaleLoader.getString("Repair.Skills.FullDurability"));
            return;
        }
        if (!inventory.contains(repairMaterial)) {
            String prettyName = repairable.getRepairMaterialPrettyName() == null ? StringUtils.getPrettyItemString(repairMaterial) : repairable.getRepairMaterialPrettyName();
            String message = LocaleLoader.getString("Skills.NeedMore", prettyName);
            if (repairMaterialMetadata != -1 && !inventory.containsAtLeast(toRemove, 1)) {
                message = message + ":" + repairMaterialMetadata;
            }
            player.sendMessage(message);
            return;
        }
        if (item.getAmount() != 1) {
            player.sendMessage(LocaleLoader.getString("Repair.Skills.StackedItems"));
            return;
        }
        SkillUtils.removeAbilityBuff(item);
        short baseRepairAmount = repairable.getBaseRepairDurability();
        short newDurability = this.repairCalculate(startDurability, baseRepairAmount);
        if (EventUtils.callRepairCheckEvent(player, (short)(startDurability - newDurability), toRemove, item).isCancelled()) {
            return;
        }
        if (ArcaneForging.arcaneForgingEnchantLoss) {
            this.addEnchants(item);
        }
        if (repairMaterialMetadata == -1) {
            toRemove = inventory.getItem(inventory.first(repairMaterial)).clone();
            toRemove.setAmount(1);
        }
        inventory.removeItem(new ItemStack[]{toRemove});
        this.applyXpGain((float)((double)this.getPercentageRepaired(startDurability, newDurability, repairable.getMaximumDurability()) * repairable.getXpMultiplier() * ExperienceConfig.getInstance().getRepairXPBase() * ExperienceConfig.getInstance().getRepairXP(repairable.getRepairMaterialType())), XPGainReason.PVE);
        if (Config.getInstance().getRepairAnvilUseSoundsEnabled()) {
            player.playSound(player.getLocation(), Sound.ANVIL_USE, 1.0f, 0.3f);
        }
        item.setDurability(newDurability);
    }

    private float getPercentageRepaired(short startDurability, short newDurability, short totalDurability) {
        return (float)(startDurability - newDurability) / (float)totalDurability;
    }

    public boolean checkConfirmation(boolean actualize) {
        Player player = this.getPlayer();
        long lastUse = this.getLastAnvilUse();
        if (!SkillUtils.cooldownExpired(lastUse, 3) || !Config.getInstance().getRepairConfirmRequired()) {
            return true;
        }
        if (!actualize) {
            return false;
        }
        this.actualizeLastAnvilUse();
        player.sendMessage(LocaleLoader.getString("Skills.ConfirmOrCancel", LocaleLoader.getString("Repair.Pretty.Name")));
        return false;
    }

    public int getArcaneForgingRank() {
        int skillLevel = this.getSkillLevel();
        for (ArcaneForging.Tier tier : ArcaneForging.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.toNumerical();
        }
        return 0;
    }

    public double getKeepEnchantChance() {
        int skillLevel = this.getSkillLevel();
        for (ArcaneForging.Tier tier : ArcaneForging.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getKeepEnchantChance();
        }
        return 0.0;
    }

    public double getDowngradeEnchantChance() {
        int skillLevel = this.getSkillLevel();
        for (ArcaneForging.Tier tier : ArcaneForging.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getDowngradeEnchantChance();
        }
        return 100.0;
    }

    private short repairCalculate(short durability, int repairAmount) {
        Player player = this.getPlayer();
        if (Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.REPAIR_MASTERY)) {
            double bonus = (double)repairAmount * Math.min(Repair.repairMasteryMaxBonus / (double)Repair.repairMasteryMaxBonusLevel * (double)this.getSkillLevel() / 100.0, Repair.repairMasteryMaxBonus / 100.0);
            repairAmount = (int)((double)repairAmount + bonus);
        }
        if (Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.SUPER_REPAIR) && this.checkPlayerProcRepair()) {
            repairAmount = (int)((double)repairAmount * 2.0);
        }
        if (repairAmount <= 0 || repairAmount > Short.MAX_VALUE) {
            repairAmount = Short.MAX_VALUE;
        }
        return (short)Math.max(durability - repairAmount, 0);
    }

    private boolean checkPlayerProcRepair() {
        if (SkillUtils.activationSuccessful(SecondaryAbility.SUPER_REPAIR, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
            this.getPlayer().sendMessage(LocaleLoader.getString("Repair.Skills.FeltEasy"));
            return true;
        }
        return false;
    }

    private void addEnchants(ItemStack item) {
        Player player = this.getPlayer();
        Map enchants = item.getEnchantments();
        if (enchants.isEmpty()) {
            return;
        }
        if (Permissions.arcaneBypass((Permissible)player)) {
            player.sendMessage(LocaleLoader.getString("Repair.Arcane.Perfect"));
            return;
        }
        if (this.getArcaneForgingRank() == 0 || !Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.ARCANE_FORGING)) {
            for (Enchantment enchant : enchants.keySet()) {
                item.removeEnchantment(enchant);
            }
            player.sendMessage(LocaleLoader.getString("Repair.Arcane.Lost"));
            return;
        }
        boolean downgraded = false;
        for (Map.Entry enchant : enchants.entrySet()) {
            Enchantment enchantment = (Enchantment)enchant.getKey();
            if (this.getKeepEnchantChance() > (double)Misc.getRandom().nextInt(this.activationChance)) {
                int enchantLevel = (Integer)enchant.getValue();
                if (!ArcaneForging.arcaneForgingDowngrades || enchantLevel <= 1 || !(100.0 - this.getDowngradeEnchantChance() <= (double)Misc.getRandom().nextInt(this.activationChance))) continue;
                item.addUnsafeEnchantment(enchantment, enchantLevel - 1);
                downgraded = true;
                continue;
            }
            item.removeEnchantment(enchantment);
        }
        Map newEnchants = item.getEnchantments();
        if (newEnchants.isEmpty()) {
            player.sendMessage(LocaleLoader.getString("Repair.Arcane.Fail"));
        } else if (downgraded || newEnchants.size() < enchants.size()) {
            player.sendMessage(LocaleLoader.getString("Repair.Arcane.Downgrade"));
        } else {
            player.sendMessage(LocaleLoader.getString("Repair.Arcane.Perfect"));
        }
    }

    public boolean getPlacedAnvil() {
        return this.placedAnvil;
    }

    public void togglePlacedAnvil() {
        this.placedAnvil = !this.placedAnvil;
    }

    public int getLastAnvilUse() {
        return this.lastClick;
    }

    public void setLastAnvilUse(int value) {
        this.lastClick = value;
    }

    public void actualizeLastAnvilUse() {
        this.lastClick = (int)(System.currentTimeMillis() / 1000L);
    }
}

