/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.mining;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;

public class Mining {
    public static int getBlockXp(BlockState blockState) {
        Material blockType = blockState.getType();
        int xp = ExperienceConfig.getInstance().getXp(SkillType.MINING, blockType != Material.GLOWING_REDSTONE_ORE ? blockType : Material.REDSTONE_ORE);
        if (xp == 0 && mcMMO.getModManager().isCustomMiningBlock(blockState)) {
            xp = mcMMO.getModManager().getBlock(blockState).getXpGain();
        }
        return xp;
    }

    protected static void handleSilkTouchDrops(BlockState blockState) {
        Material blockType = blockState.getType();
        switch (blockType) {
            case ENDER_STONE: 
            case GOLD_ORE: 
            case HARD_CLAY: 
            case IRON_ORE: 
            case MOSSY_COBBLESTONE: 
            case NETHERRACK: 
            case OBSIDIAN: 
            case SANDSTONE: 
            case STAINED_CLAY: {
                Mining.handleMiningDrops(blockState);
                return;
            }
            case GLOWING_REDSTONE_ORE: {
                if (Config.getInstance().getDoubleDropsEnabled(SkillType.MINING, Material.REDSTONE_ORE)) {
                    Misc.dropItem(blockState.getLocation(), new ItemStack(Material.REDSTONE_ORE));
                }
                return;
            }
            case COAL_ORE: 
            case DIAMOND_ORE: 
            case EMERALD_ORE: 
            case GLOWSTONE: 
            case LAPIS_ORE: 
            case PACKED_ICE: 
            case QUARTZ_ORE: 
            case REDSTONE_ORE: 
            case STONE: 
            case PRISMARINE: {
                Misc.dropItem(blockState.getLocation(), blockState.getData().toItemStack(1));
                return;
            }
        }
        if (mcMMO.getModManager().isCustomMiningBlock(blockState)) {
            Misc.dropItem(blockState.getLocation(), blockState.getData().toItemStack(1));
        }
    }

    protected static void handleMiningDrops(BlockState blockState) {
        switch (blockState.getType()) {
            case ENDER_STONE: 
            case GOLD_ORE: 
            case HARD_CLAY: 
            case IRON_ORE: 
            case MOSSY_COBBLESTONE: 
            case NETHERRACK: 
            case OBSIDIAN: 
            case SANDSTONE: 
            case STAINED_CLAY: 
            case COAL_ORE: 
            case DIAMOND_ORE: 
            case EMERALD_ORE: 
            case GLOWSTONE: 
            case LAPIS_ORE: 
            case PACKED_ICE: 
            case QUARTZ_ORE: 
            case REDSTONE_ORE: 
            case STONE: {
                Misc.dropItems(blockState.getLocation(), blockState.getBlock().getDrops());
                return;
            }
            case GLOWING_REDSTONE_ORE: {
                if (Config.getInstance().getDoubleDropsEnabled(SkillType.MINING, Material.REDSTONE_ORE)) {
                    Misc.dropItems(blockState.getLocation(), blockState.getBlock().getDrops());
                }
                return;
            }
        }
        if (mcMMO.getModManager().isCustomMiningBlock(blockState)) {
            Misc.dropItems(blockState.getLocation(), blockState.getBlock().getDrops());
        }
    }
}

