/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.herbalism;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.material.SmoothBrick;
import org.bukkit.metadata.MetadataValue;

public class Herbalism {
    public static int farmersDietRankLevel1 = AdvancedConfig.getInstance().getFarmerDietRankChange();
    public static int farmersDietRankLevel2 = farmersDietRankLevel1 * 2;
    public static int farmersDietMaxLevel = farmersDietRankLevel1 * 5;
    public static int greenThumbStageChangeLevel = AdvancedConfig.getInstance().getGreenThumbStageChange();
    public static int greenThumbStageMaxLevel = greenThumbStageChangeLevel * 4;

    protected static boolean convertGreenTerraBlocks(BlockState blockState) {
        switch (blockState.getType()) {
            case COBBLE_WALL: {
                blockState.setRawData((byte)1);
                return true;
            }
            case SMOOTH_BRICK: {
                ((SmoothBrick)blockState.getData()).setMaterial(Material.MOSSY_COBBLESTONE);
                return true;
            }
            case DIRT: {
                blockState.setType(Material.GRASS);
                return true;
            }
            case COBBLESTONE: {
                blockState.setType(Material.MOSSY_COBBLESTONE);
                return true;
            }
        }
        return false;
    }

    protected static int calculateCatciAndSugarDrops(BlockState blockState) {
        Block relativeBlock;
        Block block = blockState.getBlock();
        Material blockType = blockState.getType();
        int dropAmount = mcMMO.getPlaceStore().isTrue(block) ? 0 : 1;
        for (int y = 1; y < 3 && (relativeBlock = block.getRelative(BlockFace.UP, y)).getType() == blockType; ++y) {
            if (mcMMO.getPlaceStore().isTrue(relativeBlock)) {
                mcMMO.getPlaceStore().setFalse(relativeBlock);
                continue;
            }
            ++dropAmount;
        }
        return dropAmount;
    }

    protected static boolean convertShroomThumb(BlockState blockState) {
        switch (blockState.getType()) {
            case DIRT: 
            case GRASS: {
                blockState.setType(Material.MYCEL);
                return true;
            }
        }
        return false;
    }

    public static boolean isRecentlyRegrown(BlockState blockState) {
        return blockState.hasMetadata("mcMMO: Green Thumb") && !SkillUtils.cooldownExpired(((MetadataValue)blockState.getMetadata("mcMMO: Green Thumb").get(0)).asInt(), 1);
    }
}

