/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.axes;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.axes.Axes;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class AxesManager
extends SkillManager {
    public AxesManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.AXES);
    }

    public boolean canUseAxeMastery() {
        return Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.AXE_MASTERY);
    }

    public boolean canCriticalHit(LivingEntity target) {
        return target.isValid() && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.CRITICAL_HIT);
    }

    public boolean canImpact(LivingEntity target) {
        return target.isValid() && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.ARMOR_IMPACT) && Axes.hasArmor(target);
    }

    public boolean canGreaterImpact(LivingEntity target) {
        return target.isValid() && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.GREATER_IMPACT) && !Axes.hasArmor(target);
    }

    public boolean canUseSkullSplitter(LivingEntity target) {
        return target.isValid() && this.mcMMOPlayer.getAbilityMode(AbilityType.SKULL_SPLITTER) && Permissions.skullSplitter((Permissible)this.getPlayer());
    }

    public boolean canActivateAbility() {
        return this.mcMMOPlayer.getToolPreparationMode(ToolType.AXE) && Permissions.skullSplitter((Permissible)this.getPlayer());
    }

    public double axeMastery() {
        if (!SkillUtils.activationSuccessful(SecondaryAbility.AXE_MASTERY, this.getPlayer())) {
            return 0.0;
        }
        return Math.min((double)this.getSkillLevel() / ((double)Axes.axeMasteryMaxBonusLevel / Axes.axeMasteryMaxBonus), Axes.axeMasteryMaxBonus);
    }

    public double criticalHit(LivingEntity target, double damage) {
        if (!SkillUtils.activationSuccessful(SecondaryAbility.CRITICAL_HIT, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
            return 0.0;
        }
        Player player = this.getPlayer();
        if (this.mcMMOPlayer.useChatNotifications()) {
            player.sendMessage(LocaleLoader.getString("Axes.Combat.CriticalHit"));
        }
        if (target instanceof Player) {
            Player defender = (Player)target;
            if (UserManager.getPlayer(defender).useChatNotifications()) {
                defender.sendMessage(LocaleLoader.getString("Axes.Combat.CritStruck"));
            }
            damage = damage * Axes.criticalHitPVPModifier - damage;
        } else {
            damage = damage * Axes.criticalHitPVEModifier - damage;
        }
        return damage;
    }

    public void impactCheck(LivingEntity target) {
        int durabilityDamage = 1 + this.getSkillLevel() / Axes.impactIncreaseLevel;
        for (ItemStack armor : target.getEquipment().getArmorContents()) {
            if (!ItemUtils.isArmor(armor) || !SkillUtils.activationSuccessful(SecondaryAbility.ARMOR_IMPACT, this.getPlayer(), Axes.impactChance, this.activationChance)) continue;
            SkillUtils.handleDurabilityChange(armor, durabilityDamage, Axes.impactMaxDurabilityModifier);
        }
    }

    public double greaterImpact(LivingEntity target) {
        Player defender;
        if (!SkillUtils.activationSuccessful(SecondaryAbility.GREATER_IMPACT, this.getPlayer(), Axes.greaterImpactChance, this.activationChance)) {
            return 0.0;
        }
        Player player = this.getPlayer();
        ParticleEffectUtils.playGreaterImpactEffect(target);
        target.setVelocity(player.getLocation().getDirection().normalize().multiply(Axes.greaterImpactKnockbackMultiplier));
        if (this.mcMMOPlayer.useChatNotifications()) {
            player.sendMessage(LocaleLoader.getString("Axes.Combat.GI.Proc"));
        }
        if (target instanceof Player && UserManager.getPlayer(defender = (Player)target).useChatNotifications()) {
            defender.sendMessage(LocaleLoader.getString("Axes.Combat.GI.Struck"));
        }
        return Axes.greaterImpactBonusDamage;
    }

    public void skullSplitterCheck(LivingEntity target, double damage, Map<EntityDamageEvent.DamageModifier, Double> modifiers) {
        CombatUtils.applyAbilityAoE(this.getPlayer(), target, damage / Axes.skullSplitterModifier, modifiers, this.skill);
    }
}

