/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.player;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.McScoreboardKeepTask;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerProfileLoadingTask
extends BukkitRunnable {
    private static final int MAX_TRIES = 5;
    private final Player player;
    private int attempt = 0;

    public PlayerProfileLoadingTask(Player player) {
        this.player = player;
    }

    private PlayerProfileLoadingTask(Player player, int attempt) {
        this.player = player;
        this.attempt = attempt;
    }

    public void run() {
        if (!this.player.isOnline()) {
            mcMMO.p.getLogger().info("Aborting profile loading recovery for " + this.player.getName() + " - player logged out");
            return;
        }
        ++this.attempt;
        PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile(this.player.getName(), this.player.getUniqueId(), true);
        if (profile.isLoaded()) {
            new ApplySuccessfulProfile(new McMMOPlayer(this.player, profile)).runTask((Plugin)mcMMO.p);
            return;
        }
        if (this.attempt >= 5) {
            mcMMO.p.getLogger().severe("Giving up on attempting to load the PlayerProfile for " + this.player.getName());
            mcMMO.p.getServer().broadcast(LocaleLoader.getString("Profile.Loading.AdminFailureNotice", this.player.getName()), "bukkit.broadcast.admin");
            this.player.sendMessage(LocaleLoader.getString("Profile.Loading.Failure").split("\n"));
            return;
        }
        new PlayerProfileLoadingTask(this.player, this.attempt).runTaskLaterAsynchronously((Plugin)mcMMO.p, 100 * this.attempt);
    }

    private class ApplySuccessfulProfile
    extends BukkitRunnable {
        private final McMMOPlayer mcMMOPlayer;

        private ApplySuccessfulProfile(McMMOPlayer mcMMOPlayer) {
            this.mcMMOPlayer = mcMMOPlayer;
        }

        public void run() {
            if (!PlayerProfileLoadingTask.this.player.isOnline()) {
                mcMMO.p.getLogger().info("Aborting profile loading recovery for " + PlayerProfileLoadingTask.this.player.getName() + " - player logged out");
                return;
            }
            this.mcMMOPlayer.setupPartyData();
            UserManager.track(this.mcMMOPlayer);
            this.mcMMOPlayer.actualizeRespawnATS();
            ScoreboardManager.setupPlayer(PlayerProfileLoadingTask.this.player);
            if (Config.getInstance().getShowProfileLoadedMessage()) {
                PlayerProfileLoadingTask.this.player.sendMessage(LocaleLoader.getString("Profile.Loading.Success"));
            }
            if (Config.getInstance().getShowStatsAfterLogin()) {
                ScoreboardManager.enablePlayerStatsScoreboard(PlayerProfileLoadingTask.this.player);
                new McScoreboardKeepTask(PlayerProfileLoadingTask.this.player).runTaskLater((Plugin)mcMMO.p, 20L);
            }
        }
    }
}

