/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.items;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class TeleportationWarmup
extends BukkitRunnable {
    private McMMOPlayer mcMMOPlayer;
    private McMMOPlayer mcMMOTarget;

    public TeleportationWarmup(McMMOPlayer mcMMOPlayer, McMMOPlayer mcMMOTarget) {
        this.mcMMOPlayer = mcMMOPlayer;
        this.mcMMOTarget = mcMMOTarget;
    }

    public void run() {
        int timeRemaining;
        Player teleportingPlayer = this.mcMMOPlayer.getPlayer();
        Player targetPlayer = this.mcMMOTarget.getPlayer();
        Location previousLocation = this.mcMMOPlayer.getTeleportCommenceLocation();
        Location newLocation = this.mcMMOPlayer.getPlayer().getLocation();
        long recentlyHurt = this.mcMMOPlayer.getRecentlyHurt();
        this.mcMMOPlayer.setTeleportCommenceLocation(null);
        if (!PartyManager.inSameParty(teleportingPlayer, targetPlayer)) {
            teleportingPlayer.sendMessage(LocaleLoader.getString("Party.NotInYourParty", targetPlayer.getName()));
            return;
        }
        if (newLocation.distanceSquared(previousLocation) > 1.0) {
            teleportingPlayer.sendMessage(LocaleLoader.getString("Teleport.Cancelled"));
            return;
        }
        int hurtCooldown = Config.getInstance().getPTPCommandRecentlyHurtCooldown();
        if (hurtCooldown > 0 && (timeRemaining = SkillUtils.calculateTimeLeft(recentlyHurt * 1000L, hurtCooldown, teleportingPlayer)) > 0) {
            teleportingPlayer.sendMessage(LocaleLoader.getString("Item.Injured.Wait", timeRemaining));
            return;
        }
        EventUtils.handlePartyTeleportEvent(teleportingPlayer, targetPlayer);
    }
}

