/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.commands;

import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.MctopCommandDisplayTask;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MctopCommandAsyncTask
extends BukkitRunnable {
    private final CommandSender sender;
    private final SkillType skill;
    private final int page;
    private final boolean useBoard;
    private final boolean useChat;

    public MctopCommandAsyncTask(int page, SkillType skill, CommandSender sender, boolean useBoard, boolean useChat) {
        Validate.isTrue((useBoard || useChat ? 1 : 0) != 0, (String)"Attempted to start a rank retrieval with both board and chat off");
        Validate.notNull((Object)sender, (String)"Attempted to start a rank retrieval with no recipient");
        if (useBoard) {
            Validate.isTrue((boolean)(sender instanceof Player), (String)"Attempted to start a rank retrieval displaying scoreboard to a non-player");
        }
        this.page = page;
        this.skill = skill;
        this.sender = sender;
        this.useBoard = useBoard;
        this.useChat = useChat;
    }

    public void run() {
        List<PlayerStat> userStats = mcMMO.getDatabaseManager().readLeaderboard(this.skill, this.page, 10);
        new MctopCommandDisplayTask(userStats, this.page, this.skill, this.sender, this.useBoard, this.useChat).runTaskLater((Plugin)mcMMO.p, 1L);
    }
}

