/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.blockmeta.conversion.BlockStoreConversionMain;
import java.io.File;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class WorldListener
implements Listener {
    private final mcMMO plugin;

    public WorldListener(mcMMO plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        if (!mcMMO.getPlaceStore().isTrue(event.getLocation().getBlock())) {
            return;
        }
        for (BlockState blockState : event.getBlocks()) {
            mcMMO.getPlaceStore().setFalse(blockState);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldInit(WorldInitEvent event) {
        World world = event.getWorld();
        if (!new File(world.getWorldFolder(), "mcmmo_data").exists() || this.plugin == null) {
            return;
        }
        this.plugin.getLogger().info("Converting block storage for " + world.getName() + " to a new format.");
        new BlockStoreConversionMain(world).run();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        mcMMO.getPlaceStore().unloadWorld(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        mcMMO.getPlaceStore().chunkUnloaded(chunk.getX(), chunk.getZ(), event.getWorld());
    }
}

