/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.player.PlayerUpdateInventoryTask;
import com.gmail.nossr50.skills.alchemy.AlchemyPotionBrewer;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Furnace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class InventoryListener
implements Listener {
    private final mcMMO plugin;

    public InventoryListener(mcMMO plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        Block furnaceBlock = this.processInventoryOpenOrCloseEvent(event.getInventory());
        if (furnaceBlock == null || furnaceBlock.hasMetadata("mcMMO: Tracked Furnace")) {
            return;
        }
        HumanEntity player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        furnaceBlock.setMetadata("mcMMO: Tracked Furnace", (MetadataValue)UserManager.getPlayer((Player)player).getPlayerMetadata());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        Block furnaceBlock = this.processInventoryOpenOrCloseEvent(event.getInventory());
        if (furnaceBlock == null || furnaceBlock.hasMetadata("mcMMO: Tracked Furnace")) {
            return;
        }
        HumanEntity player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        furnaceBlock.removeMetadata("mcMMO: Tracked Furnace", (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceBurnEvent(FurnaceBurnEvent event) {
        ItemStack smelting;
        Block furnaceBlock = event.getBlock();
        BlockState furnaceState = furnaceBlock.getState();
        ItemStack itemStack = smelting = furnaceState instanceof Furnace ? ((Furnace)furnaceState).getInventory().getSmelting() : null;
        if (!ItemUtils.isSmeltable(smelting)) {
            return;
        }
        Player player = this.getPlayerFromFurnace(furnaceBlock);
        if (!UserManager.hasPlayerDataKey((Entity)player) || !Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FUEL_EFFICIENCY)) {
            return;
        }
        event.setBurnTime(UserManager.getPlayer(player).getSmeltingManager().fuelEfficiency(event.getBurnTime()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceSmeltEvent(FurnaceSmeltEvent event) {
        Block furnaceBlock = event.getBlock();
        ItemStack smelting = event.getSource();
        if (!ItemUtils.isSmeltable(smelting)) {
            return;
        }
        Player player = this.getPlayerFromFurnace(furnaceBlock);
        if (!UserManager.hasPlayerDataKey((Entity)player) || !SkillType.SMELTING.getPermissions(player)) {
            return;
        }
        event.setResult(UserManager.getPlayer(player).getSmeltingManager().smeltProcessing(smelting, event.getResult()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFurnaceExtractEvent(FurnaceExtractEvent event) {
        ItemStack result;
        Block furnaceBlock = event.getBlock();
        BlockState furnaceState = furnaceBlock.getState();
        ItemStack itemStack = result = furnaceState instanceof Furnace ? ((Furnace)furnaceState).getInventory().getResult() : null;
        if (!ItemUtils.isSmelted(result)) {
            return;
        }
        Player player = this.getPlayerFromFurnace(furnaceBlock);
        if (!UserManager.hasPlayerDataKey((Entity)player) || !Permissions.vanillaXpBoost((Permissible)player, SkillType.SMELTING)) {
            return;
        }
        event.setExpToDrop(UserManager.getPlayer(player).getSmeltingManager().vanillaXPBoost(event.getExpToDrop()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInventoryClickEventNormal(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof BrewerInventory)) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof BrewingStand)) {
            return;
        }
        HumanEntity whoClicked = event.getWhoClicked();
        if (!UserManager.hasPlayerDataKey((Entity)event.getWhoClicked()) || !Permissions.secondaryAbilityEnabled((Permissible)whoClicked, SecondaryAbility.CONCOCTIONS)) {
            return;
        }
        Player player = (Player)whoClicked;
        BrewingStand stand = (BrewingStand)holder;
        ItemStack clicked = event.getCurrentItem();
        ItemStack cursor = event.getCursor();
        if (clicked != null && clicked.getType() == Material.POTION || cursor != null && cursor.getType() == Material.POTION) {
            AlchemyPotionBrewer.scheduleCheck(player, stand);
            return;
        }
        ClickType click = event.getClick();
        InventoryType.SlotType slot = event.getSlotType();
        if (click.isShiftClick()) {
            switch (slot) {
                case FUEL: {
                    AlchemyPotionBrewer.scheduleCheck(player, stand);
                    return;
                }
                case CONTAINER: 
                case QUICKBAR: {
                    if (!AlchemyPotionBrewer.isValidIngredient(player, clicked)) {
                        return;
                    }
                    if (!AlchemyPotionBrewer.transferItems(event.getView(), event.getRawSlot(), click)) {
                        return;
                    }
                    event.setCancelled(true);
                    AlchemyPotionBrewer.scheduleUpdate(inventory);
                    AlchemyPotionBrewer.scheduleCheck(player, stand);
                    return;
                }
            }
            return;
        }
        if (slot == InventoryType.SlotType.FUEL) {
            boolean emptyClicked = AlchemyPotionBrewer.isEmpty(clicked);
            if (AlchemyPotionBrewer.isEmpty(cursor)) {
                if (emptyClicked && click == ClickType.NUMBER_KEY) {
                    AlchemyPotionBrewer.scheduleCheck(player, stand);
                    return;
                }
                AlchemyPotionBrewer.scheduleCheck(player, stand);
            } else if (emptyClicked && AlchemyPotionBrewer.isValidIngredient(player, cursor)) {
                int amount = cursor.getAmount();
                if (click == ClickType.LEFT || click == ClickType.RIGHT && amount == 1) {
                    event.setCancelled(true);
                    event.setCurrentItem(cursor.clone());
                    event.setCursor(null);
                    AlchemyPotionBrewer.scheduleUpdate(inventory);
                    AlchemyPotionBrewer.scheduleCheck(player, stand);
                } else if (click == ClickType.RIGHT) {
                    event.setCancelled(true);
                    ItemStack one = cursor.clone();
                    one.setAmount(1);
                    ItemStack rest = cursor.clone();
                    rest.setAmount(amount - 1);
                    event.setCurrentItem(one);
                    event.setCursor(rest);
                    AlchemyPotionBrewer.scheduleUpdate(inventory);
                    AlchemyPotionBrewer.scheduleCheck(player, stand);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInventoryDragEvent(InventoryDragEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof BrewerInventory)) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof BrewingStand)) {
            return;
        }
        HumanEntity whoClicked = event.getWhoClicked();
        if (!UserManager.hasPlayerDataKey((Entity)event.getWhoClicked()) || !Permissions.secondaryAbilityEnabled((Permissible)whoClicked, SecondaryAbility.CONCOCTIONS)) {
            return;
        }
        if (!event.getInventorySlots().contains(3)) {
            return;
        }
        ItemStack cursor = event.getCursor();
        ItemStack ingredient = ((BrewerInventory)inventory).getIngredient();
        if (AlchemyPotionBrewer.isEmpty(ingredient) || ingredient.isSimilar(cursor)) {
            Player player = (Player)whoClicked;
            if (AlchemyPotionBrewer.isValidIngredient(player, cursor)) {
                AlchemyPotionBrewer.scheduleCheck(player, (BrewingStand)holder);
                return;
            }
            event.setCancelled(true);
            AlchemyPotionBrewer.scheduleUpdate(inventory);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInventoryMoveItemEvent(InventoryMoveItemEvent event) {
        Inventory inventory = event.getDestination();
        if (!(inventory instanceof BrewerInventory)) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof BrewingStand)) {
            return;
        }
        ItemStack item = event.getItem();
        if (Config.getInstance().getPreventHopperTransferIngredients() && item.getType() != Material.POTION) {
            event.setCancelled(true);
            return;
        }
        if (Config.getInstance().getPreventHopperTransferBottles() && item.getType() == Material.POTION) {
            event.setCancelled(true);
            return;
        }
        if (Config.getInstance().getEnabledForHoppers() && AlchemyPotionBrewer.isValidIngredient(null, item)) {
            AlchemyPotionBrewer.scheduleCheck(null, (BrewingStand)holder);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        SkillUtils.removeAbilityBuff(event.getCurrentItem());
        if (event.getAction() == InventoryAction.HOTBAR_SWAP) {
            SkillUtils.removeAbilityBuff(event.getWhoClicked().getInventory().getItem(event.getHotbarButton()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpenEvent(InventoryOpenEvent event) {
        SkillUtils.removeAbilityBuff(event.getPlayer().getItemInHand());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCraftItem(CraftItemEvent event) {
        HumanEntity whoClicked = event.getWhoClicked();
        if (!whoClicked.hasMetadata("mcMMO: Player Data")) {
            return;
        }
        ItemStack result = event.getRecipe().getResult();
        if (!ItemUtils.isMcMMOItem(result)) {
            return;
        }
        new PlayerUpdateInventoryTask((Player)whoClicked).runTaskLater((Plugin)this.plugin, 0L);
    }

    private Block processInventoryOpenOrCloseEvent(Inventory inventory) {
        if (!(inventory instanceof FurnaceInventory)) {
            return null;
        }
        Furnace furnace = (Furnace)inventory.getHolder();
        if (furnace == null || furnace.getBurnTime() != 0) {
            return null;
        }
        return furnace.getBlock();
    }

    private Player getPlayerFromFurnace(Block furnaceBlock) {
        List metadata = furnaceBlock.getMetadata("mcMMO: Tracked Furnace");
        if (metadata.isEmpty()) {
            return null;
        }
        return this.plugin.getServer().getPlayerExact(((MetadataValue)metadata.get(0)).asString());
    }
}

