/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.juli;

import com.gmail.nossr50.database.tomcat.juli.FileHandler;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogRecord;

public class AsyncFileHandler
extends FileHandler {
    public static final int OVERFLOW_DROP_LAST = 1;
    public static final int OVERFLOW_DROP_FIRST = 2;
    public static final int OVERFLOW_DROP_FLUSH = 3;
    public static final int OVERFLOW_DROP_CURRENT = 4;
    public static final int OVERFLOW_DROP_TYPE = Integer.parseInt(System.getProperty("com.gmail.nossr50.database.tomcat.juli.AsyncOverflowDropType", "1"));
    public static final int DEFAULT_MAX_RECORDS = Integer.parseInt(System.getProperty("com.gmail.nossr50.database.tomcat.juli.AsyncMaxRecordCount", "10000"));
    public static final int LOGGER_SLEEP_TIME = Integer.parseInt(System.getProperty("com.gmail.nossr50.database.tomcat.juli.AsyncLoggerPollInterval", "1000"));
    protected static LinkedBlockingDeque<LogEntry> queue = new LinkedBlockingDeque(DEFAULT_MAX_RECORDS);
    protected static LoggerThread logger = new LoggerThread();
    protected volatile boolean closed = false;

    public AsyncFileHandler() {
        this(null, null, null);
    }

    public AsyncFileHandler(String directory, String prefix, String suffix) {
        super(directory, prefix, suffix);
        this.open();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
    }

    @Override
    protected void open() {
        if (!this.closed) {
            return;
        }
        this.closed = false;
        super.open();
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        LogEntry entry = new LogEntry(record, this);
        boolean added = false;
        try {
            while (!added && !queue.offer(entry)) {
                switch (OVERFLOW_DROP_TYPE) {
                    case 1: {
                        queue.pollLast();
                        break;
                    }
                    case 2: {
                        queue.pollFirst();
                        break;
                    }
                    case 3: {
                        added = queue.offer(entry, 1000L, TimeUnit.MILLISECONDS);
                        break;
                    }
                    case 4: {
                        added = true;
                    }
                }
            }
        }
        catch (InterruptedException x) {
            Thread.interrupted();
        }
    }

    protected void publishInternal(LogRecord record) {
        super.publish(record);
    }

    static {
        logger.start();
    }

    protected static class LogEntry {
        private LogRecord record;
        private AsyncFileHandler handler;

        public LogEntry(LogRecord record, AsyncFileHandler handler) {
            this.record = record;
            this.handler = handler;
        }

        public boolean flush() {
            if (this.handler.closed) {
                return false;
            }
            this.handler.publishInternal(this.record);
            return true;
        }
    }

    protected static class LoggerThread
    extends Thread {
        protected boolean run = true;

        public LoggerThread() {
            this.setDaemon(true);
            this.setName("AsyncFileHandlerWriter-" + System.identityHashCode(this));
        }

        @Override
        public void run() {
            while (this.run) {
                try {
                    LogEntry entry = queue.poll(LOGGER_SLEEP_TIME, TimeUnit.MILLISECONDS);
                    if (entry == null) continue;
                    entry.flush();
                }
                catch (InterruptedException x) {
                    Thread.interrupted();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }
}

