/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.tomcat.jdbc.pool;

import com.gmail.nossr50.database.tomcat.jdbc.pool.DataSourceProxy;
import com.gmail.nossr50.database.tomcat.jdbc.pool.PoolConfiguration;
import com.gmail.nossr50.database.tomcat.jdbc.pool.jmx.ConnectionPoolMBean;
import com.gmail.nossr50.database.tomcat.juli.logging.Log;
import com.gmail.nossr50.database.tomcat.juli.logging.LogFactory;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.ConnectionPoolDataSource;

public class DataSource
extends DataSourceProxy
implements javax.sql.DataSource,
MBeanRegistration,
ConnectionPoolMBean,
ConnectionPoolDataSource {
    private static final Log log = LogFactory.getLog(DataSource.class);
    protected volatile ObjectName oname = null;

    public DataSource() {
    }

    public DataSource(PoolConfiguration poolProperties) {
        super(poolProperties);
    }

    public void postDeregister() {
        if (this.oname != null) {
            this.unregisterJmx();
        }
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        try {
            if (this.isJmxEnabled()) {
                this.oname = this.createObjectName(name);
                if (this.oname != null) {
                    this.registerJmx();
                }
            }
        }
        catch (MalformedObjectNameException x) {
            log.error("Unable to create object name for JDBC pool.", x);
        }
        return name;
    }

    public ObjectName createObjectName(ObjectName original) throws MalformedObjectNameException {
        String domain = "tomcat.jdbc";
        Hashtable<String, String> properties = original.getKeyPropertyList();
        String origDomain = original.getDomain();
        properties.put("type", "ConnectionPool");
        properties.put("class", this.getClass().getName());
        if (original.getKeyProperty("path") != null || properties.get("context") != null) {
            properties.put("engine", origDomain);
        }
        ObjectName name = new ObjectName(domain, properties);
        return name;
    }

    protected void registerJmx() {
        try {
            if (this.pool.getJmxPool() != null) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.registerMBean(this.pool.getJmxPool(), this.oname);
            }
        }
        catch (Exception e) {
            log.error("Unable to register JDBC pool with JMX", e);
        }
    }

    protected void unregisterJmx() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.unregisterMBean(this.oname);
        }
        catch (InstanceNotFoundException ignore) {
        }
        catch (Exception e) {
            log.error("Unable to unregister JDBC pool with JMX", e);
        }
    }
}

