/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.database.UUIDUpdateAsyncTask;
import com.gmail.nossr50.util.Misc;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public final class FlatfileDatabaseManager
implements DatabaseManager {
    private final HashMap<SkillType, List<PlayerStat>> playerStatHash = new HashMap();
    private final List<PlayerStat> powerLevels = new ArrayList<PlayerStat>();
    private long lastUpdate = 0L;
    private final long UPDATE_WAIT_TIME = 600000L;
    private final File usersFile = new File(mcMMO.getUsersFilePath());
    private static final Object fileWritingLock = new Object();
    public static int USERNAME = 0;
    public static int SKILLS_MINING = 1;
    public static int EXP_MINING = 4;
    public static int SKILLS_WOODCUTTING = 5;
    public static int EXP_WOODCUTTING = 6;
    public static int SKILLS_REPAIR = 7;
    public static int SKILLS_UNARMED = 8;
    public static int SKILLS_HERBALISM = 9;
    public static int SKILLS_EXCAVATION = 10;
    public static int SKILLS_ARCHERY = 11;
    public static int SKILLS_SWORDS = 12;
    public static int SKILLS_AXES = 13;
    public static int SKILLS_ACROBATICS = 14;
    public static int EXP_REPAIR = 15;
    public static int EXP_UNARMED = 16;
    public static int EXP_HERBALISM = 17;
    public static int EXP_EXCAVATION = 18;
    public static int EXP_ARCHERY = 19;
    public static int EXP_SWORDS = 20;
    public static int EXP_AXES = 21;
    public static int EXP_ACROBATICS = 22;
    public static int SKILLS_TAMING = 24;
    public static int EXP_TAMING = 25;
    public static int COOLDOWN_BERSERK = 26;
    public static int COOLDOWN_GIGA_DRILL_BREAKER = 27;
    public static int COOLDOWN_TREE_FELLER = 28;
    public static int COOLDOWN_GREEN_TERRA = 29;
    public static int COOLDOWN_SERRATED_STRIKES = 30;
    public static int COOLDOWN_SKULL_SPLITTER = 31;
    public static int COOLDOWN_SUPER_BREAKER = 32;
    public static int SKILLS_FISHING = 34;
    public static int EXP_FISHING = 35;
    public static int COOLDOWN_BLAST_MINING = 36;
    public static int LAST_LOGIN = 37;
    public static int HEALTHBAR = 38;
    public static int SKILLS_ALCHEMY = 39;
    public static int EXP_ALCHEMY = 40;
    public static int UUID_INDEX = 41;
    public static int SCOREBOARD_TIPS = 42;

    protected FlatfileDatabaseManager() {
        this.checkStructure();
        this.updateLeaderboards();
        if (mcMMO.getUpgradeManager().shouldUpgrade(UpgradeType.ADD_UUIDS)) {
            new UUIDUpdateAsyncTask(mcMMO.p, this.getStoredUsers()).runTaskAsynchronously((Plugin)mcMMO.p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgePowerlessUsers() {
        int purgedUsers = 0;
        mcMMO.p.getLogger().info("Purging powerless users...");
        BufferedReader in = null;
        OutputStreamWriter out = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    Map<SkillType, Integer> skills = this.getSkillMapFromLine(character);
                    boolean powerless = true;
                    for (int skill : skills.values()) {
                        if (skill == 0) continue;
                        powerless = false;
                        break;
                    }
                    if (!powerless) {
                        writer.append(line).append("\r\n");
                        continue;
                    }
                    ++purgedUsers;
                }
                out = new FileWriter(usersFilePath);
                out.write(writer.toString());
            }
            catch (IOException e) {
                mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " (Are you sure you formatted it correctly?)" + e.toString());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        mcMMO.p.getLogger().info("Purged " + purgedUsers + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeOldUsers() {
        int removedPlayers = 0;
        long currentTime = System.currentTimeMillis();
        mcMMO.p.getLogger().info("Purging old users...");
        BufferedReader in = null;
        OutputStreamWriter out = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    Object[] character = line.split(":");
                    String name = character[USERNAME];
                    long lastPlayed = 0L;
                    boolean rewrite = false;
                    try {
                        lastPlayed = Long.parseLong(character[37]) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (lastPlayed == 0L) {
                        OfflinePlayer player = mcMMO.p.getServer().getOfflinePlayer(name);
                        lastPlayed = player.getLastPlayed();
                        rewrite = true;
                    }
                    if (currentTime - lastPlayed > PURGE_TIME) {
                        ++removedPlayers;
                        continue;
                    }
                    if (rewrite) {
                        character[37] = Long.toString(lastPlayed);
                        String newLine = StringUtils.join((Object[])character, (String)":");
                        writer.append(newLine).append("\r\n");
                        continue;
                    }
                    writer.append(line).append("\r\n");
                }
                out = new FileWriter(usersFilePath);
                out.write(writer.toString());
            }
            catch (IOException e) {
                mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " (Are you sure you formatted it correctly?)" + e.toString());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        mcMMO.p.getLogger().info("Purged " + removedPlayers + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(String playerName) {
        boolean worked = false;
        BufferedReader in = null;
        OutputStreamWriter out = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    if (!worked && line.split(":")[USERNAME].equalsIgnoreCase(playerName)) {
                        mcMMO.p.getLogger().info("User found, removing...");
                        worked = true;
                        continue;
                    }
                    writer.append(line).append("\r\n");
                }
                out = new FileWriter(usersFilePath);
                out.write(writer.toString());
            }
            catch (Exception e) {
                mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " (Are you sure you formatted it correctly?)" + e.toString());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Misc.profileCleanup(playerName);
        return worked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveUser(PlayerProfile profile) {
        String playerName = profile.getPlayerName();
        UUID uuid = profile.getUniqueId();
        BufferedReader in = null;
        OutputStreamWriter out = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            boolean bl;
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    if (!(uuid != null && character[UUID_INDEX].equalsIgnoreCase(uuid.toString()) || character[USERNAME].equalsIgnoreCase(playerName))) {
                        writer.append(line).append("\r\n");
                        continue;
                    }
                    writer.append(playerName).append(":");
                    writer.append(profile.getSkillLevel(SkillType.MINING)).append(":");
                    writer.append(":");
                    writer.append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.MINING)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.WOODCUTTING)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.WOODCUTTING)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.REPAIR)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.UNARMED)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.HERBALISM)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.EXCAVATION)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.ARCHERY)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.SWORDS)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.AXES)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.ACROBATICS)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.REPAIR)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.UNARMED)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.HERBALISM)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.EXCAVATION)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.ARCHERY)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.SWORDS)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.AXES)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.ACROBATICS)).append(":");
                    writer.append(":");
                    writer.append(profile.getSkillLevel(SkillType.TAMING)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.TAMING)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.BERSERK)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.GIGA_DRILL_BREAKER)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.TREE_FELLER)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.GREEN_TERRA)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.SERRATED_STRIKES)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.SKULL_SPLITTER)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.SUPER_BREAKER)).append(":");
                    writer.append(":");
                    writer.append(profile.getSkillLevel(SkillType.FISHING)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.FISHING)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.BLAST_MINING)).append(":");
                    writer.append(System.currentTimeMillis() / 1000L).append(":");
                    MobHealthbarType mobHealthbarType = profile.getMobHealthbarType();
                    writer.append(mobHealthbarType == null ? Config.getInstance().getMobHealthbarDefault().toString() : mobHealthbarType.toString()).append(":");
                    writer.append(profile.getSkillLevel(SkillType.ALCHEMY)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.ALCHEMY)).append(":");
                    writer.append(uuid != null ? uuid.toString() : "NULL").append(":");
                    writer.append(profile.getScoreboardTipsShown()).append(":");
                    writer.append("\r\n");
                }
                out = new FileWriter(usersFilePath);
                out.write(writer.toString());
                bl = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl2 = false;
                return bl2;
            }
            return bl;
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public List<PlayerStat> readLeaderboard(SkillType skill, int pageNumber, int statsPerPage) {
        this.updateLeaderboards();
        List<PlayerStat> statsList = skill == null ? this.powerLevels : this.playerStatHash.get((Object)skill);
        int fromIndex = (Math.max(pageNumber, 1) - 1) * statsPerPage;
        return statsList.subList(Math.min(fromIndex, statsList.size()), Math.min(fromIndex + statsPerPage, statsList.size()));
    }

    @Override
    public Map<SkillType, Integer> readRank(String playerName) {
        this.updateLeaderboards();
        HashMap<SkillType, Integer> skills = new HashMap<SkillType, Integer>();
        for (SkillType skill : SkillType.NON_CHILD_SKILLS) {
            skills.put(skill, this.getPlayerRank(playerName, this.playerStatHash.get((Object)skill)));
        }
        skills.put(null, this.getPlayerRank(playerName, this.powerLevels));
        return skills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newUser(String playerName, UUID uuid) {
        BufferedWriter out = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                out = new BufferedWriter(new FileWriter(mcMMO.getUsersFilePath(), true));
                out.append(playerName).append(":");
                out.append("0:");
                out.append(":");
                out.append(":");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append(":");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append(":");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append(String.valueOf(System.currentTimeMillis() / 1000L)).append(":");
                out.append(Config.getInstance().getMobHealthbarDefault().toString()).append(":");
                out.append("0:");
                out.append("0:");
                out.append(uuid != null ? uuid.toString() : "NULL").append(":");
                out.append("0:");
                out.newLine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    @Deprecated
    public PlayerProfile loadPlayerProfile(String playerName, boolean create) {
        return this.loadPlayerProfile(playerName, null, false);
    }

    @Override
    public PlayerProfile loadPlayerProfile(UUID uuid) {
        return this.loadPlayerProfile("", uuid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerProfile loadPlayerProfile(String playerName, UUID uuid, boolean create) {
        in = null;
        usersFilePath = mcMMO.getUsersFilePath();
        var6_6 = FlatfileDatabaseManager.fileWritingLock;
        synchronized (var6_6) {
            block27: {
                block29: {
                    block28: {
                        block26: {
                            try {
                                in = new BufferedReader(new FileReader(usersFilePath));
                                while ((line = in.readLine()) != null) {
                                    character = line.split(":");
                                    if (character[FlatfileDatabaseManager.UUID_INDEX].equalsIgnoreCase("NULL") == false ? uuid != null && character[FlatfileDatabaseManager.UUID_INDEX].equalsIgnoreCase(uuid.toString()) == false || uuid == null && character[FlatfileDatabaseManager.USERNAME].equalsIgnoreCase(playerName) == false : character[FlatfileDatabaseManager.USERNAME].equalsIgnoreCase(playerName) == false) continue;
                                    if (!character[FlatfileDatabaseManager.USERNAME].equalsIgnoreCase(playerName)) {
                                        mcMMO.p.debug("Name change detected: " + character[FlatfileDatabaseManager.USERNAME] + " => " + playerName);
                                        character[FlatfileDatabaseManager.USERNAME] = playerName;
                                    }
                                    var9_12 = this.loadFromLine(character);
                                    break block26;
                                }
                                if (!create) break block27;
                                if (uuid == null) {
                                    this.newUser(playerName, uuid);
                                    var8_11 = new PlayerProfile(playerName, true);
                                    break block28;
                                }
                                this.newUser(playerName, uuid);
                                var8_11 = new PlayerProfile(playerName, uuid, true);
                                break block29;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                break block27;
                            }
                        }
                        return var9_12;
                    }
                    return var8_11;
                }
                return var8_11;
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException var7_10) {}
                    }
                }
            }
            ** if (uuid != null) goto lbl42
        }
lbl41:
        // 1 sources

        return new PlayerProfile(playerName);
lbl42:
        // 1 sources

        return new PlayerProfile(playerName, uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertUsers(DatabaseManager destination) {
        BufferedReader in = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        int convertedUsers = 0;
        long startMillis = System.currentTimeMillis();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    try {
                        destination.saveUser(this.loadFromLine(character));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Misc.printProgress(++convertedUsers, 200, startMillis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUID(String userName, UUID uuid) {
        boolean worked = false;
        int i = 0;
        BufferedReader in = null;
        FileWriter out = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    if (!worked && character[USERNAME].equalsIgnoreCase(userName)) {
                        if (character.length < 42) {
                            mcMMO.p.getLogger().severe("Could not update UUID for " + userName + "!");
                            mcMMO.p.getLogger().severe("Database entry is invalid.");
                            continue;
                        }
                        line = line.replace(character[UUID_INDEX], uuid.toString());
                        worked = true;
                    }
                    ++i;
                    writer.append(line).append("\r\n");
                }
                out = new FileWriter(usersFilePath);
                out.write(writer.toString());
            }
            catch (Exception e) {
                mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " (Are you sure you formatted it correctly?)" + e.toString());
            }
            finally {
                mcMMO.p.getLogger().info(i + " entries written while saving UUID for " + userName);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return worked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUIDs(Map<String, UUID> fetchedUUIDs) {
        BufferedReader in = null;
        OutputStreamWriter out = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        int i = 0;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    Object[] character = line.split(":");
                    if (!fetchedUUIDs.isEmpty() && fetchedUUIDs.containsKey(character[USERNAME])) {
                        if (character.length < 42) {
                            mcMMO.p.getLogger().severe("Could not update UUID for " + character[USERNAME] + "!");
                            mcMMO.p.getLogger().severe("Database entry is invalid.");
                            continue;
                        }
                        character[FlatfileDatabaseManager.UUID_INDEX] = fetchedUUIDs.remove(character[USERNAME]).toString();
                        line = StringUtils.join((Object[])character, (String)":") + ":";
                    }
                    ++i;
                    writer.append(line).append("\r\n");
                }
                out = new FileWriter(usersFilePath);
                out.write(writer.toString());
            }
            catch (Exception e) {
                mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " (Are you sure you formatted it correctly?)" + e.toString());
            }
            finally {
                mcMMO.p.getLogger().info(i + " entries written while saving UUID batch");
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStoredUsers() {
        ArrayList<String> users = new ArrayList<String>();
        BufferedReader in = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    users.add(character[USERNAME]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLeaderboards() {
        if (System.currentTimeMillis() < this.lastUpdate + 600000L) {
            return;
        }
        String usersFilePath = mcMMO.getUsersFilePath();
        this.lastUpdate = System.currentTimeMillis();
        this.powerLevels.clear();
        ArrayList<PlayerStat> mining = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> woodcutting = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> herbalism = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> excavation = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> acrobatics = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> repair = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> swords = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> axes = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> archery = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> unarmed = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> taming = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> fishing = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> alchemy = new ArrayList<PlayerStat>();
        BufferedReader in = null;
        String playerName = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                while ((line = in.readLine()) != null) {
                    String[] data = line.split(":");
                    playerName = data[USERNAME];
                    int powerLevel = 0;
                    Map<SkillType, Integer> skills = this.getSkillMapFromLine(data);
                    powerLevel += this.putStat(acrobatics, playerName, skills.get((Object)SkillType.ACROBATICS));
                    powerLevel += this.putStat(alchemy, playerName, skills.get((Object)SkillType.ALCHEMY));
                    powerLevel += this.putStat(archery, playerName, skills.get((Object)SkillType.ARCHERY));
                    powerLevel += this.putStat(axes, playerName, skills.get((Object)SkillType.AXES));
                    powerLevel += this.putStat(excavation, playerName, skills.get((Object)SkillType.EXCAVATION));
                    powerLevel += this.putStat(fishing, playerName, skills.get((Object)SkillType.FISHING));
                    powerLevel += this.putStat(herbalism, playerName, skills.get((Object)SkillType.HERBALISM));
                    powerLevel += this.putStat(mining, playerName, skills.get((Object)SkillType.MINING));
                    powerLevel += this.putStat(repair, playerName, skills.get((Object)SkillType.REPAIR));
                    powerLevel += this.putStat(swords, playerName, skills.get((Object)SkillType.SWORDS));
                    powerLevel += this.putStat(taming, playerName, skills.get((Object)SkillType.TAMING));
                    powerLevel += this.putStat(unarmed, playerName, skills.get((Object)SkillType.UNARMED));
                    this.putStat(this.powerLevels, playerName, powerLevel += this.putStat(woodcutting, playerName, skills.get((Object)SkillType.WOODCUTTING)));
                }
            }
            catch (Exception e) {
                mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " during user " + playerName + " (Are you sure you formatted it correctly?) " + e.toString());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        SkillComparator c = new SkillComparator();
        Collections.sort(mining, c);
        Collections.sort(woodcutting, c);
        Collections.sort(repair, c);
        Collections.sort(unarmed, c);
        Collections.sort(herbalism, c);
        Collections.sort(excavation, c);
        Collections.sort(archery, c);
        Collections.sort(swords, c);
        Collections.sort(axes, c);
        Collections.sort(acrobatics, c);
        Collections.sort(taming, c);
        Collections.sort(fishing, c);
        Collections.sort(alchemy, c);
        Collections.sort(this.powerLevels, c);
        this.playerStatHash.put(SkillType.MINING, mining);
        this.playerStatHash.put(SkillType.WOODCUTTING, woodcutting);
        this.playerStatHash.put(SkillType.REPAIR, repair);
        this.playerStatHash.put(SkillType.UNARMED, unarmed);
        this.playerStatHash.put(SkillType.HERBALISM, herbalism);
        this.playerStatHash.put(SkillType.EXCAVATION, excavation);
        this.playerStatHash.put(SkillType.ARCHERY, archery);
        this.playerStatHash.put(SkillType.SWORDS, swords);
        this.playerStatHash.put(SkillType.AXES, axes);
        this.playerStatHash.put(SkillType.ACROBATICS, acrobatics);
        this.playerStatHash.put(SkillType.TAMING, taming);
        this.playerStatHash.put(SkillType.FISHING, fishing);
        this.playerStatHash.put(SkillType.ALCHEMY, alchemy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStructure() {
        if (this.usersFile.exists()) {
            BufferedReader in = null;
            OutputStreamWriter out = null;
            String usersFilePath = mcMMO.getUsersFilePath();
            Object object = fileWritingLock;
            synchronized (object) {
                try {
                    String line;
                    in = new BufferedReader(new FileReader(usersFilePath));
                    StringBuilder writer = new StringBuilder();
                    HashSet<String> usernames = new HashSet<String>();
                    HashSet<String> players = new HashSet<String>();
                    while ((line = in.readLine()) != null) {
                        if (line.isEmpty()) continue;
                        if (line.charAt(line.length() - 1) != ':') {
                            line = line.concat(":");
                        }
                        boolean updated = false;
                        Object[] character = line.split(":");
                        if (!usernames.add(character[USERNAME])) {
                            character[FlatfileDatabaseManager.USERNAME] = "_INVALID_OLD_USERNAME_'";
                            updated = true;
                            if (character.length < UUID_INDEX + 1 || character[UUID_INDEX].equals("NULL")) continue;
                        }
                        if (character.length >= 42 && !character[UUID_INDEX].isEmpty() && !character[UUID_INDEX].equals("NULL") && !players.add(character[UUID_INDEX])) continue;
                        if (character.length < 33) {
                            mcMMO.p.getLogger().warning("Dropping malformed or before version 1.0 line from database - " + line);
                            continue;
                        }
                        String oldVersion = null;
                        if (character.length > 33 && !character[33].isEmpty()) {
                            character[33] = "";
                            if (oldVersion == null) {
                                oldVersion = "1.4.07";
                            }
                            updated = true;
                        }
                        if (Config.getInstance().getTruncateSkills()) {
                            for (SkillType skill : SkillType.NON_CHILD_SKILLS) {
                                int index = this.getSkillIndex(skill);
                                if (index >= character.length) continue;
                                int cap = Config.getInstance().getLevelCap(skill);
                                if (Integer.valueOf(character[index]) <= cap) continue;
                                mcMMO.p.getLogger().warning("Truncating " + skill.getName() + " to configured max level for player " + character[USERNAME]);
                                character[index] = cap + "";
                                updated = true;
                            }
                        }
                        if (!updated && character.length == 43) {
                            writer.append(line).append("\r\n");
                            continue;
                        }
                        if (character.length <= 33) {
                            character = Arrays.copyOf(character, character.length + 1);
                            character[character.length - 1] = "";
                            oldVersion = "1.1.06";
                        }
                        if (character.length <= 35) {
                            character = Arrays.copyOf(character, character.length + 2);
                            character[character.length - 1] = "0";
                            character[character.length - 2] = "0";
                            if (oldVersion == null) {
                                oldVersion = "1.2.00";
                            }
                        }
                        if (character.length <= 36) {
                            character = Arrays.copyOf(character, character.length + 1);
                            character[character.length - 1] = "0";
                            if (oldVersion == null) {
                                oldVersion = "1.3.00";
                            }
                        }
                        if (character.length <= 37) {
                            character = Arrays.copyOf(character, character.length + 1);
                            character[character.length - 1] = "0";
                            if (oldVersion == null) {
                                oldVersion = "1.4.00";
                            }
                        }
                        if (character.length <= 38) {
                            character = Arrays.copyOf(character, character.length + 1);
                            character[character.length - 1] = Config.getInstance().getMobHealthbarDefault().toString();
                            if (oldVersion == null) {
                                oldVersion = "1.4.06";
                            }
                        }
                        if (character.length <= 39) {
                            character = Arrays.copyOf(character, character.length + 2);
                            character[character.length - 1] = "0";
                            character[character.length - 2] = "0";
                            if (oldVersion == null) {
                                oldVersion = "1.4.08";
                            }
                        }
                        if (character.length <= 41) {
                            character = Arrays.copyOf(character, character.length + 1);
                            character[character.length - 1] = "NULL";
                            if (oldVersion == null) {
                                oldVersion = "1.5.01";
                            }
                        }
                        if (character.length <= 42) {
                            character = Arrays.copyOf(character, character.length + 1);
                            character[character.length - 1] = "0";
                            if (oldVersion == null) {
                                oldVersion = "1.5.02";
                            }
                        }
                        boolean corrupted = false;
                        for (int i = 0; i < character.length; ++i) {
                            if (character[i].isEmpty() && i != 2 && i != 3 && i != 23 && i != 33 && i != 41) {
                                corrupted = true;
                                character[i] = i == 37 ? String.valueOf(System.currentTimeMillis() / 1000L) : (i == 38 ? Config.getInstance().getMobHealthbarDefault().toString() : "0");
                            }
                            if (com.gmail.nossr50.util.StringUtils.isInt(character[i]) && i == 38) {
                                corrupted = true;
                                character[i] = Config.getInstance().getMobHealthbarDefault().toString();
                            }
                            if (com.gmail.nossr50.util.StringUtils.isInt(character[i]) || i == 0 || i == 2 || i == 3 || i == 23 || i == 33 || i == 38 || i == 41) continue;
                            corrupted = true;
                            character[i] = "0";
                        }
                        if (corrupted) {
                            mcMMO.p.debug("Updating corrupted database line for player " + character[USERNAME]);
                        }
                        if (oldVersion != null) {
                            mcMMO.p.debug("Updating database line from before version " + oldVersion + " for player " + character[USERNAME]);
                        }
                        updated |= corrupted;
                        updated |= oldVersion != null;
                        if (Config.getInstance().getTruncateSkills()) {
                            Map<SkillType, Integer> skills = this.getSkillMapFromLine((String[])character);
                            for (SkillType skill : SkillType.NON_CHILD_SKILLS) {
                                int cap = Config.getInstance().getLevelCap(skill);
                                if (skills.get((Object)skill) <= cap) continue;
                                updated = true;
                            }
                        }
                        if (updated) {
                            line = StringUtils.join((Object[])character, (String)":") + ":";
                        }
                        writer.append(line).append("\r\n");
                    }
                    out = new FileWriter(usersFilePath);
                    out.write(writer.toString());
                }
                catch (IOException e) {
                    mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " (Are you sure you formatted it correctly?)" + e.toString());
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_FISHING);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_BLAST_MINING_COOLDOWN);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_SQL_INDEXES);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_MOB_HEALTHBARS);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.DROP_SQL_PARTY_NAMES);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.DROP_SPOUT);
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_ALCHEMY);
            return;
        }
        this.usersFile.getParentFile().mkdir();
        try {
            mcMMO.p.debug("Creating mcmmo.users file...");
            new File(mcMMO.getUsersFilePath()).createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Integer getPlayerRank(String playerName, List<PlayerStat> statsList) {
        if (statsList == null) {
            return null;
        }
        int currentPos = 1;
        for (PlayerStat stat : statsList) {
            if (stat.name.equalsIgnoreCase(playerName)) {
                return currentPos;
            }
            ++currentPos;
        }
        return null;
    }

    private int putStat(List<PlayerStat> statList, String playerName, int statValue) {
        statList.add(new PlayerStat(playerName, statValue));
        return statValue;
    }

    private PlayerProfile loadFromLine(String[] character) {
        int scoreboardTipsShown;
        UUID uuid;
        MobHealthbarType mobHealthbarType;
        Map<SkillType, Integer> skills = this.getSkillMapFromLine(character);
        EnumMap<SkillType, Float> skillsXp = new EnumMap<SkillType, Float>(SkillType.class);
        EnumMap<AbilityType, Integer> skillsDATS = new EnumMap<AbilityType, Integer>(AbilityType.class);
        skillsXp.put(SkillType.TAMING, Float.valueOf(Integer.valueOf(character[EXP_TAMING]).intValue()));
        skillsXp.put(SkillType.MINING, Float.valueOf(Integer.valueOf(character[EXP_MINING]).intValue()));
        skillsXp.put(SkillType.REPAIR, Float.valueOf(Integer.valueOf(character[EXP_REPAIR]).intValue()));
        skillsXp.put(SkillType.WOODCUTTING, Float.valueOf(Integer.valueOf(character[EXP_WOODCUTTING]).intValue()));
        skillsXp.put(SkillType.UNARMED, Float.valueOf(Integer.valueOf(character[EXP_UNARMED]).intValue()));
        skillsXp.put(SkillType.HERBALISM, Float.valueOf(Integer.valueOf(character[EXP_HERBALISM]).intValue()));
        skillsXp.put(SkillType.EXCAVATION, Float.valueOf(Integer.valueOf(character[EXP_EXCAVATION]).intValue()));
        skillsXp.put(SkillType.ARCHERY, Float.valueOf(Integer.valueOf(character[EXP_ARCHERY]).intValue()));
        skillsXp.put(SkillType.SWORDS, Float.valueOf(Integer.valueOf(character[EXP_SWORDS]).intValue()));
        skillsXp.put(SkillType.AXES, Float.valueOf(Integer.valueOf(character[EXP_AXES]).intValue()));
        skillsXp.put(SkillType.ACROBATICS, Float.valueOf(Integer.valueOf(character[EXP_ACROBATICS]).intValue()));
        skillsXp.put(SkillType.FISHING, Float.valueOf(Integer.valueOf(character[EXP_FISHING]).intValue()));
        skillsXp.put(SkillType.ALCHEMY, Float.valueOf(Integer.valueOf(character[EXP_ALCHEMY]).intValue()));
        skillsDATS.put(AbilityType.SUPER_BREAKER, Integer.valueOf(character[COOLDOWN_SUPER_BREAKER]));
        skillsDATS.put(AbilityType.TREE_FELLER, Integer.valueOf(character[COOLDOWN_TREE_FELLER]));
        skillsDATS.put(AbilityType.BERSERK, Integer.valueOf(character[COOLDOWN_BERSERK]));
        skillsDATS.put(AbilityType.GREEN_TERRA, Integer.valueOf(character[COOLDOWN_GREEN_TERRA]));
        skillsDATS.put(AbilityType.GIGA_DRILL_BREAKER, Integer.valueOf(character[COOLDOWN_GIGA_DRILL_BREAKER]));
        skillsDATS.put(AbilityType.SERRATED_STRIKES, Integer.valueOf(character[COOLDOWN_SERRATED_STRIKES]));
        skillsDATS.put(AbilityType.SKULL_SPLITTER, Integer.valueOf(character[COOLDOWN_SKULL_SPLITTER]));
        skillsDATS.put(AbilityType.BLAST_MINING, Integer.valueOf(character[COOLDOWN_BLAST_MINING]));
        try {
            mobHealthbarType = MobHealthbarType.valueOf(character[HEALTHBAR]);
        }
        catch (Exception e) {
            mobHealthbarType = Config.getInstance().getMobHealthbarDefault();
        }
        try {
            uuid = UUID.fromString(character[UUID_INDEX]);
        }
        catch (Exception e) {
            uuid = null;
        }
        try {
            scoreboardTipsShown = Integer.valueOf(character[SCOREBOARD_TIPS]);
        }
        catch (Exception e) {
            scoreboardTipsShown = 0;
        }
        return new PlayerProfile(character[USERNAME], uuid, skills, skillsXp, skillsDATS, mobHealthbarType, scoreboardTipsShown);
    }

    private Map<SkillType, Integer> getSkillMapFromLine(String[] character) {
        EnumMap<SkillType, Integer> skills = new EnumMap<SkillType, Integer>(SkillType.class);
        skills.put(SkillType.TAMING, Integer.valueOf(character[SKILLS_TAMING]));
        skills.put(SkillType.MINING, Integer.valueOf(character[SKILLS_MINING]));
        skills.put(SkillType.REPAIR, Integer.valueOf(character[SKILLS_REPAIR]));
        skills.put(SkillType.WOODCUTTING, Integer.valueOf(character[SKILLS_WOODCUTTING]));
        skills.put(SkillType.UNARMED, Integer.valueOf(character[SKILLS_UNARMED]));
        skills.put(SkillType.HERBALISM, Integer.valueOf(character[SKILLS_HERBALISM]));
        skills.put(SkillType.EXCAVATION, Integer.valueOf(character[SKILLS_EXCAVATION]));
        skills.put(SkillType.ARCHERY, Integer.valueOf(character[SKILLS_ARCHERY]));
        skills.put(SkillType.SWORDS, Integer.valueOf(character[SKILLS_SWORDS]));
        skills.put(SkillType.AXES, Integer.valueOf(character[SKILLS_AXES]));
        skills.put(SkillType.ACROBATICS, Integer.valueOf(character[SKILLS_ACROBATICS]));
        skills.put(SkillType.FISHING, Integer.valueOf(character[SKILLS_FISHING]));
        skills.put(SkillType.ALCHEMY, Integer.valueOf(character[SKILLS_ALCHEMY]));
        return skills;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.FLATFILE;
    }

    @Override
    public void onDisable() {
    }

    private int getSkillIndex(SkillType skill) {
        switch (skill) {
            case ACROBATICS: {
                return SKILLS_ACROBATICS;
            }
            case ALCHEMY: {
                return SKILLS_ALCHEMY;
            }
            case ARCHERY: {
                return SKILLS_ARCHERY;
            }
            case AXES: {
                return SKILLS_AXES;
            }
            case EXCAVATION: {
                return SKILLS_EXCAVATION;
            }
            case FISHING: {
                return SKILLS_FISHING;
            }
            case HERBALISM: {
                return SKILLS_HERBALISM;
            }
            case MINING: {
                return SKILLS_MINING;
            }
            case REPAIR: {
                return SKILLS_REPAIR;
            }
            case SWORDS: {
                return SKILLS_SWORDS;
            }
            case TAMING: {
                return SKILLS_TAMING;
            }
            case UNARMED: {
                return SKILLS_UNARMED;
            }
            case WOODCUTTING: {
                return SKILLS_WOODCUTTING;
            }
        }
        throw new RuntimeException("Primary Skills only");
    }

    private class SkillComparator
    implements Comparator<PlayerStat> {
        private SkillComparator() {
        }

        @Override
        public int compare(PlayerStat o1, PlayerStat o2) {
            return o2.statVal - o1.statVal;
        }
    }
}

