/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.skills.repair;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.skills.ItemType;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.skills.repair.repairables.RepairableFactory;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class RepairConfig
extends ConfigLoader {
    private List<Repairable> repairables;

    public RepairConfig(String fileName) {
        super(fileName);
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.repairables = new ArrayList<Repairable>();
        ConfigurationSection section = this.config.getConfigurationSection("Repairables");
        Set keys = section.getKeys(false);
        for (String key : keys) {
            int minimumQuantity;
            short maximumDurability;
            Material repairMaterial;
            if (this.config.contains("Repairables." + key + ".ItemId")) {
                this.backup();
                return;
            }
            ArrayList<String> reason = new ArrayList<String>();
            Material itemMaterial = Material.matchMaterial((String)key);
            if (itemMaterial == null) {
                reason.add("Invalid material: " + key);
            }
            MaterialType repairMaterialType = MaterialType.OTHER;
            String repairMaterialTypeString = this.config.getString("Repairables." + key + ".MaterialType", "OTHER");
            if (!this.config.contains("Repairables." + key + ".MaterialType") && itemMaterial != null) {
                ItemStack repairItem = new ItemStack(itemMaterial);
                if (ItemUtils.isWoodTool(repairItem)) {
                    repairMaterialType = MaterialType.WOOD;
                } else if (ItemUtils.isStoneTool(repairItem)) {
                    repairMaterialType = MaterialType.STONE;
                } else if (ItemUtils.isStringTool(repairItem)) {
                    repairMaterialType = MaterialType.STRING;
                } else if (ItemUtils.isLeatherArmor(repairItem)) {
                    repairMaterialType = MaterialType.LEATHER;
                } else if (ItemUtils.isIronArmor(repairItem) || ItemUtils.isIronTool(repairItem)) {
                    repairMaterialType = MaterialType.IRON;
                } else if (ItemUtils.isGoldArmor(repairItem) || ItemUtils.isGoldTool(repairItem)) {
                    repairMaterialType = MaterialType.GOLD;
                } else if (ItemUtils.isDiamondArmor(repairItem) || ItemUtils.isDiamondTool(repairItem)) {
                    repairMaterialType = MaterialType.DIAMOND;
                }
            } else {
                try {
                    repairMaterialType = MaterialType.valueOf(repairMaterialTypeString);
                }
                catch (IllegalArgumentException ex) {
                    reason.add(key + " has an invalid MaterialType of " + repairMaterialTypeString);
                }
            }
            String repairMaterialName = this.config.getString("Repairables." + key + ".RepairMaterial");
            Material material = repairMaterial = repairMaterialName == null ? repairMaterialType.getDefaultMaterial() : Material.matchMaterial((String)repairMaterialName);
            if (repairMaterial == null) {
                reason.add(key + " has an invalid repair material: " + repairMaterialName);
            }
            short s = maximumDurability = itemMaterial != null ? itemMaterial.getMaxDurability() : (short)this.config.getInt("Repairables." + key + ".MaximumDurability");
            if (maximumDurability <= 0) {
                maximumDurability = (short)this.config.getInt("Repairables." + key + ".MaximumDurability");
            }
            if (maximumDurability <= 0) {
                reason.add("Maximum durability of " + key + " must be greater than 0!");
            }
            ItemType repairItemType = ItemType.OTHER;
            String repairItemTypeString = this.config.getString("Repairables." + key + ".ItemType", "OTHER");
            if (!this.config.contains("Repairables." + key + ".ItemType") && itemMaterial != null) {
                ItemStack repairItem = new ItemStack(itemMaterial);
                if (ItemUtils.isMinecraftTool(repairItem)) {
                    repairItemType = ItemType.TOOL;
                } else if (ItemUtils.isArmor(repairItem)) {
                    repairItemType = ItemType.ARMOR;
                }
            } else {
                try {
                    repairItemType = ItemType.valueOf(repairItemTypeString);
                }
                catch (IllegalArgumentException ex) {
                    reason.add(key + " has an invalid ItemType of " + repairItemTypeString);
                }
            }
            byte repairMetadata = (byte)this.config.getInt("Repairables." + key + ".RepairMaterialMetadata", -1);
            int minimumLevel = this.config.getInt("Repairables." + key + ".MinimumLevel");
            double xpMultiplier = this.config.getDouble("Repairables." + key + ".XpMultiplier", 1.0);
            if (minimumLevel < 0) {
                reason.add(key + " has an invalid MinimumLevel of " + minimumLevel);
            }
            int n = minimumQuantity = itemMaterial != null ? SkillUtils.getRepairAndSalvageQuantities(new ItemStack(itemMaterial), repairMaterial, repairMetadata) : this.config.getInt("Repairables." + key + ".MinimumQuantity", 2);
            if (minimumQuantity <= 0 && itemMaterial != null) {
                minimumQuantity = this.config.getInt("Repairables." + key + ".MinimumQuantity", 2);
            }
            if (minimumQuantity <= 0) {
                reason.add("Minimum quantity of " + key + " must be greater than 0!");
            }
            if (!this.noErrorsInRepairable(reason)) continue;
            Repairable repairable = RepairableFactory.getRepairable(itemMaterial, repairMaterial, repairMetadata, minimumLevel, minimumQuantity, maximumDurability, repairItemType, repairMaterialType, xpMultiplier);
            this.repairables.add(repairable);
        }
    }

    protected List<Repairable> getLoadedRepairables() {
        return this.repairables == null ? new ArrayList() : this.repairables;
    }

    private boolean noErrorsInRepairable(List<String> issues) {
        for (String issue : issues) {
            plugin.getLogger().warning(issue);
        }
        return issues.isEmpty();
    }
}

