/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.mcMMO;
import java.io.InputStream;
import org.bukkit.configuration.file.YamlConfiguration;

public class HiddenConfig {
    private static HiddenConfig instance;
    private String fileName;
    private YamlConfiguration config;
    private boolean chunkletsEnabled;
    private int conversionRate;
    private boolean useEnchantmentBuffs;
    private int uuidConvertAmount;
    private int mojangRateLimit;
    private long mojangLimitPeriod;

    public HiddenConfig(String fileName) {
        this.fileName = fileName;
        this.load();
    }

    public static HiddenConfig getInstance() {
        if (instance == null) {
            instance = new HiddenConfig("hidden.yml");
        }
        return instance;
    }

    public void load() {
        if (mcMMO.p.getResource(this.fileName) != null) {
            this.config = YamlConfiguration.loadConfiguration((InputStream)mcMMO.p.getResource(this.fileName));
            this.chunkletsEnabled = this.config.getBoolean("Options.Chunklets", true);
            this.conversionRate = this.config.getInt("Options.ConversionRate", 1);
            this.useEnchantmentBuffs = this.config.getBoolean("Options.EnchantmentBuffs", true);
            this.uuidConvertAmount = this.config.getInt("Options.UUIDConvertAmount", 5);
            this.mojangRateLimit = this.config.getInt("Options.MojangRateLimit", 50000);
            this.mojangLimitPeriod = this.config.getLong("Options.MojangLimitPeriod", 600000L);
        }
    }

    public boolean getChunkletsEnabled() {
        return this.chunkletsEnabled;
    }

    public int getConversionRate() {
        return this.conversionRate;
    }

    public boolean useEnchantmentBuffs() {
        return this.useEnchantmentBuffs;
    }

    public int getUUIDConvertAmount() {
        return this.uuidConvertAmount;
    }

    public int getMojangRateLimit() {
        return this.mojangRateLimit;
    }

    public long getMojangLimitPeriod() {
        return this.mojangLimitPeriod;
    }
}

