/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.mining.BlastMining;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class MiningCommand
extends SkillCommand {
    private String doubleDropChance;
    private String doubleDropChanceLucky;
    private String superBreakerLength;
    private String superBreakerLengthEndurance;
    private int blastMiningRank;
    private int bonusTNTDrops;
    private double blastRadiusIncrease;
    private String oreBonus;
    private String debrisReduction;
    private String blastDamageDecrease;
    private boolean canSuperBreaker;
    private boolean canDoubleDrop;
    private boolean canBlast;
    private boolean canBiggerBombs;
    private boolean canDemoExpert;

    public MiningCommand() {
        super(SkillType.MINING);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        if (this.canSuperBreaker) {
            String[] superBreakerStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.superBreakerLength = superBreakerStrings[0];
            this.superBreakerLengthEndurance = superBreakerStrings[1];
        }
        if (this.canDoubleDrop) {
            String[] doubleDropStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.MINING_DOUBLE_DROPS, isLucky);
            this.doubleDropChance = doubleDropStrings[0];
            this.doubleDropChanceLucky = doubleDropStrings[1];
        }
        if (this.canBlast || this.canDemoExpert || this.canBiggerBombs) {
            MiningManager miningManager = UserManager.getPlayer(player).getMiningManager();
            this.blastMiningRank = miningManager.getBlastMiningTier();
            this.bonusTNTDrops = miningManager.getDropMultiplier();
            this.oreBonus = this.percent.format(miningManager.getOreBonus() / 30.0);
            this.debrisReduction = this.percent.format(miningManager.getDebrisReduction() / 30.0);
            this.blastDamageDecrease = this.percent.format(miningManager.getBlastDamageModifier() / 100.0);
            this.blastRadiusIncrease = miningManager.getBlastRadiusModifier();
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canBiggerBombs = Permissions.biggerBombs((Permissible)player);
        this.canBlast = Permissions.remoteDetonation((Permissible)player);
        this.canDemoExpert = Permissions.demolitionsExpertise((Permissible)player);
        this.canDoubleDrop = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.MINING_DOUBLE_DROPS) && !this.skill.getDoubleDropsDisabled();
        this.canSuperBreaker = Permissions.superBreaker((Permissible)player);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canSuperBreaker) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Mining.Effect.0"), LocaleLoader.getString("Mining.Effect.1")));
        }
        if (this.canDoubleDrop) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Mining.Effect.2"), LocaleLoader.getString("Mining.Effect.3")));
        }
        if (this.canBlast) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Mining.Effect.4"), LocaleLoader.getString("Mining.Effect.5")));
        }
        if (this.canBiggerBombs) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Mining.Effect.6"), LocaleLoader.getString("Mining.Effect.7")));
        }
        if (this.canDemoExpert) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Mining.Effect.8"), LocaleLoader.getString("Mining.Effect.9")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        int unlockLevel;
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canDoubleDrop) {
            messages.add(LocaleLoader.getString("Mining.Effect.DropChance", this.doubleDropChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.doubleDropChanceLucky) : ""));
        }
        if (this.canSuperBreaker) {
            messages.add(LocaleLoader.getString("Mining.Ability.Length", this.superBreakerLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.superBreakerLengthEndurance) : ""));
        }
        if (this.canBlast) {
            unlockLevel = AdvancedConfig.getInstance().getBlastMiningRankLevel(BlastMining.Tier.ONE);
            if (skillValue < (float)unlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Mining.Ability.Locked.0", unlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Mining.Blast.Rank", this.blastMiningRank, BlastMining.Tier.values().length, LocaleLoader.getString("Mining.Blast.Effect", this.oreBonus, this.debrisReduction, this.bonusTNTDrops)));
            }
        }
        if (this.canBiggerBombs) {
            unlockLevel = BlastMining.getBiggerBombsUnlockLevel();
            if (skillValue < (float)unlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Mining.Ability.Locked.1", unlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Mining.Blast.Radius.Increase", this.blastRadiusIncrease));
            }
        }
        if (this.canDemoExpert) {
            unlockLevel = BlastMining.getDemolitionExpertUnlockLevel();
            if (skillValue < (float)unlockLevel) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template.Lock", LocaleLoader.getString("Mining.Ability.Locked.2", unlockLevel)));
            } else {
                messages.add(LocaleLoader.getString("Mining.Effect.Decrease", this.blastDamageDecrease));
            }
        }
        return messages;
    }
}

