/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party.alliance;

import com.gmail.nossr50.commands.party.alliance.PartyAllianceAcceptCommand;
import com.gmail.nossr50.commands.party.alliance.PartyAllianceDisbandCommand;
import com.gmail.nossr50.commands.party.alliance.PartyAllianceInviteCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class PartyAllianceCommand
implements TabExecutor {
    private Player player;
    private Party playerParty;
    private Party targetParty;
    public static final List<String> ALLIANCE_SUBCOMMANDS = ImmutableList.of((Object)"invite", (Object)"accept", (Object)"disband");
    private CommandExecutor partyAllianceInviteCommand = new PartyAllianceInviteCommand();
    private CommandExecutor partyAllianceAcceptCommand = new PartyAllianceAcceptCommand();
    private CommandExecutor partyAllianceDisbandCommand = new PartyAllianceDisbandCommand();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (CommandUtils.noConsoleUsage(sender)) {
            return true;
        }
        this.player = (Player)sender;
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(this.player);
        this.playerParty = mcMMOPlayer.getParty();
        switch (args.length) {
            case 1: {
                if (this.playerParty.getLevel() < Config.getInstance().getPartyFeatureUnlockLevel(PartyFeature.ALLIANCE)) {
                    sender.sendMessage(LocaleLoader.getString("Party.Feature.Disabled.3"));
                    return true;
                }
                if (this.playerParty.getAlly() == null) {
                    this.printUsage();
                    return true;
                }
                this.targetParty = this.playerParty.getAlly();
                this.displayPartyHeader();
                this.displayMemberInfo(mcMMOPlayer);
                return true;
            }
            case 2: 
            case 3: {
                if (this.playerParty.getLevel() < Config.getInstance().getPartyFeatureUnlockLevel(PartyFeature.ALLIANCE)) {
                    sender.sendMessage(LocaleLoader.getString("Party.Feature.Disabled.3"));
                    return true;
                }
                if (args[1].equalsIgnoreCase("invite")) {
                    return this.partyAllianceInviteCommand.onCommand(sender, command, label, args);
                }
                if (args[1].equalsIgnoreCase("accept")) {
                    return this.partyAllianceAcceptCommand.onCommand(sender, command, label, args);
                }
                if (args[1].equalsIgnoreCase("disband")) {
                    return this.partyAllianceDisbandCommand.onCommand(sender, command, label, args);
                }
                if (this.playerParty.getAlly() == null) {
                    this.printUsage();
                    return true;
                }
                this.targetParty = this.playerParty.getAlly();
                this.displayPartyHeader();
                this.displayMemberInfo(mcMMOPlayer);
                return true;
            }
        }
        return false;
    }

    private boolean printUsage() {
        this.player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Help.0"));
        this.player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Help.1"));
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String label, String[] args) {
        switch (args.length) {
            case 1: {
                List matches = (List)StringUtil.copyPartialMatches((String)args[0], ALLIANCE_SUBCOMMANDS, new ArrayList(ALLIANCE_SUBCOMMANDS.size()));
                if (matches.size() == 0) {
                    List<String> playerNames = CommandUtils.getOnlinePlayerNames(commandSender);
                    return (List)StringUtil.copyPartialMatches((String)args[0], playerNames, new ArrayList(playerNames.size()));
                }
                return matches;
            }
        }
        return ImmutableList.of();
    }

    private void displayPartyHeader() {
        this.player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Header"));
        this.player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Ally", this.playerParty.getName(), this.targetParty.getName()));
    }

    private void displayMemberInfo(McMMOPlayer mcMMOPlayer) {
        List<Player> nearMembers = PartyManager.getNearMembers(mcMMOPlayer);
        this.player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Members.Header"));
        this.player.sendMessage(this.playerParty.createMembersList(this.player.getName(), nearMembers));
        this.player.sendMessage(ChatColor.DARK_GRAY + "----------------------------");
        this.player.sendMessage(this.targetParty.createMembersList(this.player.getName(), nearMembers));
    }
}

