/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.events.party.McMMOPartyChangeEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyRenameCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 2: {
                McMMOPlayer mcMMOPlayer = UserManager.getPlayer((Player)sender);
                Party playerParty = mcMMOPlayer.getParty();
                String oldPartyName = playerParty.getName();
                String newPartyName = args[1];
                if (oldPartyName.equalsIgnoreCase(newPartyName)) {
                    sender.sendMessage(LocaleLoader.getString("Party.Rename.Same"));
                    return true;
                }
                Player player = mcMMOPlayer.getPlayer();
                if (PartyManager.checkPartyExistence(player, newPartyName)) {
                    return true;
                }
                String leaderName = playerParty.getLeader().getPlayerName();
                for (Player member : playerParty.getOnlineMembers()) {
                    if (!PartyManager.handlePartyChangeEvent(member, oldPartyName, newPartyName, McMMOPartyChangeEvent.EventReason.CHANGED_PARTIES)) {
                        return true;
                    }
                    if (member.getName().equalsIgnoreCase(leaderName)) continue;
                    member.sendMessage(LocaleLoader.getString("Party.InformedOnNameChange", leaderName, newPartyName));
                }
                playerParty.setName(newPartyName);
                sender.sendMessage(LocaleLoader.getString("Commands.Party.Rename", newPartyName));
                return true;
            }
        }
        sender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "rename", "<" + LocaleLoader.getString("Commands.Usage.PartyName") + ">"));
        return true;
    }
}

