/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public class KrakenCommand
implements TabExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 0: {
                if (CommandUtils.noConsoleUsage(sender)) {
                    return true;
                }
                if (!Permissions.kraken((Permissible)sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!CommandUtils.hasPlayerDataKey(sender)) {
                    return true;
                }
                UserManager.getPlayer(sender.getName()).getFishingManager().unleashTheKraken();
                return true;
            }
            case 1: {
                McMMOPlayer mcMMOPlayer;
                if (!Permissions.krakenOthers((Permissible)sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                String playerName = CommandUtils.getMatchedPlayerName(args[0]);
                if (!CommandUtils.checkPlayerExistence(sender, playerName, mcMMOPlayer = UserManager.getPlayer(playerName))) {
                    return true;
                }
                mcMMOPlayer.getFishingManager().unleashTheKraken();
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args.length) {
            case 1: {
                List<String> playerNames = CommandUtils.getOnlinePlayerNames(sender);
                return (List)StringUtil.copyPartialMatches((String)args[0], playerNames, new ArrayList(playerNames.size()));
            }
        }
        return ImmutableList.of();
    }
}

