/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Turret;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.game.GuardsManager;

public class TurretUtil
implements Runnable {
    public static final String META_SHOOTER = "shooter";
    public static final String META_DAMAGE = "damage";
    public static Queue<ShotArrow> shotArrows = new LinkedList<ShotArrow>();
    private static final int removeDelay = 3;
    private static Map<Zombie, Player> soldierTargets = new ConcurrentHashMap<Zombie, Player>();
    private static final Map<UUID, Integer> healTasks = new ConcurrentHashMap<UUID, Integer>();

    @Override
    public void run() {
        while (Kingdoms.getInstance().isEnabled()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            TurretUtil.arrow();
            TurretUtil.zombie();
        }
    }

    private static void arrow() {
        if (shotArrows.isEmpty()) {
            return;
        }
        ShotArrow sarrow = shotArrows.peek();
        if (sarrow == null) {
            return;
        }
        Arrow arrow = sarrow.arrow;
        if (arrow.isOnGround() || !arrow.isValid()) {
            arrow.remove();
            shotArrows.poll();
        } else if (arrow.getVelocity().getX() == 0.0 && arrow.getVelocity().getY() == 0.0 && arrow.getVelocity().getZ() == 0.0) {
            arrow.remove();
            shotArrows.poll();
        } else if (sarrow.isExpired()) {
            arrow.remove();
            shotArrows.poll();
        }
    }

    public static void shootArrow(Kingdom shooter, Location target, Location origin, boolean crit, boolean fire) {
        Vector to = target.clone().add(0.0, 0.75, 0.0).toVector();
        Location fromLoc = origin.clone().add(0.5, 1.0, 0.5);
        Vector from = fromLoc.toVector();
        Vector direction = to.subtract(from);
        direction.normalize();
        Arrow arrow = origin.getWorld().spawnArrow(fromLoc, direction, 1.5f, 10.0f);
        if (crit) {
            arrow.setCritical(crit);
        }
        if (fire) {
            arrow.setFireTicks(Integer.MAX_VALUE);
        }
        arrow.setMetadata(META_SHOOTER, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.getInstance(), (Object)shooter.getKingdomName()));
        if (!crit && !fire) {
            arrow.setMetadata(META_DAMAGE, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.getInstance(), (Object)("" + Kingdoms.config.turret_arrow_damage)));
        }
        if (crit) {
            arrow.setMetadata(META_DAMAGE, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.getInstance(), (Object)("" + Kingdoms.config.turret_hellfire_damage)));
        }
        if (fire) {
            arrow.setMetadata(META_DAMAGE, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.getInstance(), (Object)("" + Kingdoms.config.turret_flameturret_damage)));
        }
        shotArrows.add(new ShotArrow(arrow));
    }

    public static void volley(Kingdom shooter, Location target, Location origin) {
        Location fromLoc = origin.clone().add(0.5, 1.0, 0.5);
        int i = -2;
        while (i < 2) {
            Location toLoc = target.clone().add((double)TurretUtil.randInt(-1, 1), (double)TurretUtil.randInt(0, 2), (double)TurretUtil.randInt(-1, 1));
            Vector to = toLoc.clone().add(0.0, 0.75, 0.0).toVector();
            ++i;
            Vector from = fromLoc.toVector();
            Vector direction = to.subtract(from);
            direction.normalize();
            Snowball arrow = (Snowball)origin.getWorld().spawnEntity(fromLoc, EntityType.SNOWBALL);
            arrow.setVelocity(direction);
            arrow.setFireTicks(Integer.MAX_VALUE);
            arrow.setMetadata(META_SHOOTER, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.getInstance(), (Object)shooter.getKingdomName()));
            arrow.setMetadata("flamesnowballs", (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.getInstance(), (Object)"fireballs"));
        }
    }

    public static int randInt(int min, int max) {
        Random rand = new Random();
        int randomNum = rand.nextInt(max - min + 1) + min;
        return randomNum;
    }

    private static void zombie() {
        for (Map.Entry<Zombie, Player> entry : soldierTargets.entrySet()) {
            Zombie soldier = entry.getKey();
            Entity target = (Entity)entry.getValue();
            if (soldier.isDead() || !soldier.isValid()) {
                soldierTargets.remove(soldier, target);
                soldier.remove();
                continue;
            }
            if (target.isDead() || !target.isValid()) {
                soldierTargets.remove(soldier, target);
                soldier.remove();
                continue;
            }
            soldier.setTarget((LivingEntity)target);
        }
    }

    public static LivingEntity spawnSoldier(Location loc, Player target, Kingdom owner, Turret turret) {
        Zombie soldier = (Zombie)loc.getWorld().spawn(loc, Zombie.class);
        soldier.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 999999, 2));
        soldier.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 999999, 2));
        soldier.getEquipment().setItemInHand(new ItemStack(Material.IRON_SWORD));
        soldier.getEquipment().setHelmet(new ItemStack(Material.LEATHER_HELMET));
        soldier.setBaby(false);
        soldier.getEquipment().setItemInHandDropChance(0.0f);
        soldier.setTarget((LivingEntity)target);
        soldier.setCustomName(GuardsManager.GUARDNAME);
        soldier.setCustomNameVisible(true);
        soldier.setMetadata("kingdom+" + owner.getKingdomName(), (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.getInstance(), (Object)""));
        if (Kingdoms.config.turret_soldierspawner_damage > -1) {
            soldier.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 99999, Kingdoms.config.turret_soldierspawner_damage - 1));
        }
        soldier.setMetadata("finalservice", (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.getInstance(), (Object)""));
        soldierTargets.put(soldier, target);
        return soldier;
    }

    public static void fireHeatBeam(Entity target, Location origin, double damange, SplashAction action) {
        int distInt;
        origin = origin.clone().add(0.5, 1.0, 0.5);
        Location targetLoc = target.getLocation().clone().add(0.0, 0.5, 0.0);
        double distance = Math.abs(targetLoc.distance(origin));
        if (distance > (double)(distInt = (int)distance)) {
            ++distInt;
        }
        World world = origin.getWorld();
        int i = 0;
        while (i < distInt) {
            double delta = (double)i / 15.0 * distance;
            double x = (1.0 - delta) * origin.getX() + delta * (targetLoc.getX() + 0.5);
            double y = (1.0 - delta) * origin.getY() + delta * (targetLoc.getY() + 0.5);
            double z = (1.0 - delta) * origin.getZ() + delta * (targetLoc.getZ() + 0.5);
            Location loc = new Location(world, x, y, z);
            world.playEffect(loc, Effect.COLOURED_DUST, 0);
            for (Entity e : Turret.getNearbyEntities(loc, 1.0)) {
                if (!action.canAttack(origin.getChunk(), e) || !(e instanceof Damageable)) continue;
                ((Damageable)e).damage(damange);
            }
            ++i;
        }
        if (target instanceof Damageable) {
            ((Damageable)target).damage(damange);
        }
    }

    public static void psionicEffect(Entity target, double damage, boolean isVoodoo) {
        if (!(target instanceof Damageable)) {
            return;
        }
        Damageable d = (Damageable)target;
        double calcDamage = damage;
        if (d.getHealth() - damage < 6.0) {
            calcDamage = d.getHealth() - 6.0;
        }
        d.damage(calcDamage < 0.0 ? 0.0 : calcDamage);
        if (target instanceof LivingEntity) {
            if (target instanceof Player) {
                ((Player)target).sendMessage(ChatColor.RED + "You were hit by a Psionic Strike!");
            }
            int dur = 10;
            if (isVoodoo) {
                dur = 40;
            }
            ((LivingEntity)target).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, dur, 6));
            ((LivingEntity)target).addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 10, 6));
        }
    }

    public static void healEffect(Player target, double amount) {
        target.setHealth(target.getHealth() + amount > target.getMaxHealth() ? target.getMaxHealth() : target.getHealth() + amount);
    }

    public static void regenHealEffect(final Player target, final double amount) {
        int i = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Kingdoms.getInstance(), new Runnable(){
            int timesRun = 0;

            @Override
            public void run() {
                ++this.timesRun;
                if (this.timesRun >= 4) {
                    if (healTasks.get(target.getUniqueId()) != null) {
                        Bukkit.getScheduler().cancelTask(((Integer)healTasks.remove(target.getUniqueId())).intValue());
                    }
                    return;
                }
                target.setHealth(target.getHealth() + amount > target.getMaxHealth() ? target.getMaxHealth() : target.getHealth() + amount);
            }
        }, 0L, 3L);
        healTasks.put(target.getUniqueId(), i);
    }

    public static class ShotArrow {
        private long timestamp = new Date().getTime();
        private Arrow arrow;

        public ShotArrow(Arrow arrow) {
            this.arrow = arrow;
        }

        public boolean isExpired() {
            return this.timestamp + 3000L < new Date().getTime();
        }
    }

    public static interface SplashAction {
        public boolean canAttack(Chunk var1, Entity var2);
    }
}

