/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.utils.LoreOrganizer;

public class TurretUpgradeGUIManager
extends Manager
implements Listener {
    protected TurretUpgradeGUIManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onTurretUpgradeClick(InventoryClickEvent event) {
        if (event.getInventory().getName() == null) {
            return;
        }
        if (!event.getInventory().getName().equals(ChatColor.AQUA + "Turret Upgrades")) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getLore() == null) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)event.getWhoClicked());
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            Kingdoms.logInfo((String)"kingdom was null!");
            return;
        }
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        List lores = event.getCurrentItem().getItemMeta().getLore();
        if (lores.contains(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled))) {
            return;
        }
        if (this.upgradeTurretUpgrade(kingdom, displayName)) {
            this.openMenu(kp);
        } else {
            this.openMenu(kp);
        }
    }

    public boolean upgradeTurretUpgrade(Kingdom kingdom, String type) {
        int cost = 0;
        if (type.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_SimplifiedModel_Title))) {
            cost = Kingdoms.config.turretupgrade_simplified_cost;
            if (kingdom.getResourcepoints() >= cost) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getTurretUpgrades().setSimplifiedModel(true);
                return true;
            }
        } else if (type.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Flurry_Title))) {
            cost = Kingdoms.config.turretupgrade_flurry_cost;
            if (kingdom.getResourcepoints() >= cost) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getTurretUpgrades().setFlurry(true);
                return true;
            }
        } else if (type.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_ConcentratedBlast_Title))) {
            cost = Kingdoms.config.turretupgrade_concentrated_cost;
            if (kingdom.getResourcepoints() >= cost) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getTurretUpgrades().setConcentratedBlast(true);
                return true;
            }
        } else if (type.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_VirulentPlague_Title))) {
            cost = Kingdoms.config.turretupgrade_virulent_cost;
            if (kingdom.getResourcepoints() >= cost) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getTurretUpgrades().setVirulentPlague(true);
                return true;
            }
        } else if (type.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_ImprovedHeal_Title))) {
            cost = Kingdoms.config.turretupgrade_improvedhealing_cost;
            if (kingdom.getResourcepoints() >= cost) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getTurretUpgrades().setImprovedHeal(true);
                return true;
            }
        } else if (type.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Voodoo_Title))) {
            cost = Kingdoms.config.turretupgrade_voodoo_cost;
            if (kingdom.getResourcepoints() >= cost) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getTurretUpgrades().setVoodoo(true);
                return true;
            }
        } else if (type.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_FinalService_Title))) {
            cost = Kingdoms.config.turretupgrade_finalservice_cost;
            if (kingdom.getResourcepoints() >= cost) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getTurretUpgrades().setFinalService(true);
                return true;
            }
        } else if (type.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Hellstorm_Title))) {
            cost = Kingdoms.config.turretupgrade_hellstorm_cost;
            if (kingdom.getResourcepoints() >= cost) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getTurretUpgrades().setHellstorm(true);
                return true;
            }
        } else if (type.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_UnrelentingGaze_Title))) {
            cost = Kingdoms.config.turretupgrade_unrelenting_cost;
            if (kingdom.getResourcepoints() >= cost) {
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                kingdom.getTurretUpgrades().setUnrelentingGaze(true);
                return true;
            }
        }
        return false;
    }

    public void openMenu(KingdomPlayer kp) {
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        Inventory menu = Bukkit.createInventory(null, (int)27, (String)(ChatColor.AQUA + "Turret Upgrades"));
        ItemStack t1 = new ItemStack(Material.STONE);
        ItemMeta t1m = t1.getItemMeta();
        t1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_SimplifiedModel_Title));
        ArrayList<String> t1l = new ArrayList<String>();
        t1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_SimplifiedModel_Lore));
        t1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_SimplifiedModel_Changes));
        if (kingdom.getTurretUpgrades().isSimplifiedModel()) {
            t1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled));
        } else {
            t1l.add(ChatColor.RED + Kingdoms.config.turretupgrade_simplified_cost + "RP");
        }
        t1m.setLore(LoreOrganizer.organize(t1l));
        t1.setItemMeta(t1m);
        ItemStack t2 = new ItemStack(Material.SNOW_BALL);
        ItemMeta t2m = t2.getItemMeta();
        t2m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Flurry_Title));
        ArrayList<String> t2l = new ArrayList<String>();
        t2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Flurry_Lore));
        t2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Flurry_Changes));
        if (kingdom.getTurretUpgrades().isFlurry()) {
            t2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled));
        } else {
            t2l.add(ChatColor.RED + Kingdoms.config.turretupgrade_flurry_cost + "RP");
        }
        t2m.setLore(LoreOrganizer.organize(t2l));
        t2.setItemMeta(t2m);
        ItemStack t3 = new ItemStack(Material.TNT);
        ItemMeta t3m = t3.getItemMeta();
        t3m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_ConcentratedBlast_Title));
        ArrayList<String> t3l = new ArrayList<String>();
        t3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_ConcentratedBlast_Lore));
        t3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_ConcentratedBlast_Changes));
        if (kingdom.getTurretUpgrades().isConcentratedBlast()) {
            t3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled));
        } else {
            t3l.add(ChatColor.RED + Kingdoms.config.turretupgrade_concentrated_cost + "RP");
        }
        t3m.setLore(LoreOrganizer.organize(t3l));
        t3.setItemMeta(t3m);
        ItemStack t4 = new ItemStack(Material.POTION, 1, 36);
        ItemMeta t4m = t4.getItemMeta();
        t4m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_VirulentPlague_Title));
        ArrayList<String> t4l = new ArrayList<String>();
        t4l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_VirulentPlague_Lore));
        t4l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_VirulentPlague_Changes));
        if (kingdom.getTurretUpgrades().isVirulentPlague()) {
            t4l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled));
        } else {
            t4l.add(ChatColor.RED + Kingdoms.config.turretupgrade_virulent_cost + "RP");
        }
        t4m.setLore(LoreOrganizer.organize(t4l));
        t4.setItemMeta(t4m);
        ItemStack t5 = new ItemStack(Material.POTION, 1, 33);
        ItemMeta t5m = t5.getItemMeta();
        t5m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_ImprovedHeal_Title));
        ArrayList<String> t5l = new ArrayList<String>();
        t5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_ImprovedHeal_Lore));
        t5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_ImprovedHeal_Changes));
        if (kingdom.getTurretUpgrades().isImprovedHeal()) {
            t5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled));
        } else {
            t5l.add(ChatColor.RED + Kingdoms.config.turretupgrade_improvedhealing_cost + "RP");
        }
        t5m.setLore(LoreOrganizer.organize(t5l));
        t5.setItemMeta(t5m);
        ItemStack t6 = new ItemStack(Material.EYE_OF_ENDER);
        ItemMeta t6m = t6.getItemMeta();
        t6m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Voodoo_Title));
        ArrayList<String> t6l = new ArrayList<String>();
        t6l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Voodoo_Lore));
        t6l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Voodoo_Changes));
        if (kingdom.getTurretUpgrades().isVoodoo()) {
            t6l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled));
        } else {
            t6l.add(ChatColor.RED + Kingdoms.config.turretupgrade_voodoo_cost + "RP");
        }
        t6m.setLore(LoreOrganizer.organize(t6l));
        t6.setItemMeta(t6m);
        ItemStack t7 = new ItemStack(Material.NETHER_STAR);
        ItemMeta t7m = t7.getItemMeta();
        t7m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_FinalService_Title));
        ArrayList<String> t7l = new ArrayList<String>();
        t7l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_FinalService_Lore));
        t7l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_FinalService_Changes));
        if (kingdom.getTurretUpgrades().isFinalService()) {
            t7l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled));
        } else {
            t7l.add(ChatColor.RED + Kingdoms.config.turretupgrade_finalservice_cost + "RP");
        }
        t7m.setLore(LoreOrganizer.organize(t7l));
        t7.setItemMeta(t7m);
        ItemStack t8 = new ItemStack(Material.ARROW);
        ItemMeta t8m = t8.getItemMeta();
        t8m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Hellstorm_Title));
        ArrayList<String> t8l = new ArrayList<String>();
        t8l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Hellstorm_Lore));
        t8l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_Hellstorm_Changes));
        if (kingdom.getTurretUpgrades().isHellstorm()) {
            t8l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled));
        } else {
            t8l.add(ChatColor.RED + Kingdoms.config.turretupgrade_hellstorm_cost + "RP");
        }
        t8m.setLore(LoreOrganizer.organize(t8l));
        t8.setItemMeta(t8m);
        ItemStack t9 = new ItemStack(Material.BLAZE_POWDER);
        ItemMeta t9m = t9.getItemMeta();
        t9m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_UnrelentingGaze_Title));
        ArrayList<String> t9l = new ArrayList<String>();
        t9l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_UnrelentingGaze_Lore));
        t9l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_TurretUpgrades_UnrelentingGaze_Changes));
        if (kingdom.getTurretUpgrades().isUnrelentingGaze()) {
            t9l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled));
        } else {
            t9l.add(ChatColor.RED + Kingdoms.config.turretupgrade_unrelenting_cost + "RP");
        }
        t9m.setLore(LoreOrganizer.organize(t9l));
        t9.setItemMeta(t9m);
        ItemStack r = new ItemStack(Material.HAY_BLOCK);
        ItemMeta rm = r.getItemMeta();
        rm.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Title));
        ArrayList<String> rl = new ArrayList<String>();
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Desc));
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Count).replaceAll("%amount%", "" + kingdom.getResourcepoints()));
        rm.setLore(LoreOrganizer.organize(rl));
        r.setItemMeta(rm);
        ItemStack backbtn = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta backbtnmeta = backbtn.getItemMeta();
        backbtnmeta.setDisplayName(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Back_Btn));
        backbtn.setItemMeta(backbtnmeta);
        if (Kingdoms.config.turretupgrade_simplified_enabled) {
            menu.addItem(new ItemStack[]{t1});
        }
        if (Kingdoms.config.turretupgrade_flurry_enabled) {
            menu.addItem(new ItemStack[]{t2});
        }
        if (Kingdoms.config.turretupgrade_concentrated_enabled) {
            menu.addItem(new ItemStack[]{t3});
        }
        if (Kingdoms.config.turretupgrade_virulent_enabled) {
            menu.addItem(new ItemStack[]{t4});
        }
        if (Kingdoms.config.turretupgrade_improvedhealing_enabled) {
            menu.addItem(new ItemStack[]{t5});
        }
        if (Kingdoms.config.turretupgrade_voodoo_enabled) {
            menu.addItem(new ItemStack[]{t6});
        }
        if (Kingdoms.config.turretupgrade_finalservice_enabled) {
            menu.addItem(new ItemStack[]{t7});
        }
        if (Kingdoms.config.turretupgrade_hellstorm_enabled) {
            menu.addItem(new ItemStack[]{t8});
        }
        if (Kingdoms.config.turretupgrade_unrelenting_enabled) {
            menu.addItem(new ItemStack[]{t9});
        }
        menu.setItem(17, r);
        menu.setItem(26, backbtn);
        kp.getPlayer().openInventory(menu);
    }

    @Override
    public void onDisable() {
    }
}

