/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.utils.LoreOrganizer;

public class StructureGUIManager
extends Manager
implements Listener {
    protected StructureGUIManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onStructureShopClick(InventoryClickEvent event) {
        if (event.getInventory().getName() == null) {
            return;
        }
        if (!event.getInventory().getName().equals(ChatColor.AQUA + "Structure Shop")) {
            return;
        }
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)event.getWhoClicked());
        if (kp.getKingdom() == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta().getLore() == null) {
            return;
        }
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        List lores = event.getCurrentItem().getItemMeta().getLore();
        if (lores.contains(ChatColor.LIGHT_PURPLE + "Placable Structure")) {
            if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Powercell))) {
                int cost = Kingdoms.config.structure_powercell_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kp.getPlayer().getInventory().firstEmpty() == -1) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Inventory_Full));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                ItemStack IS = GameManagement.getStructureManager().getPowerCellDisk();
                kp.getPlayer().getInventory().addItem(new ItemStack[]{IS});
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Outpost))) {
                int cost = Kingdoms.config.structure_outpost_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kp.getPlayer().getInventory().firstEmpty() == -1) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Inventory_Full));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                ItemStack IS = GameManagement.getStructureManager().getOutpostDisk();
                kp.getPlayer().getInventory().addItem(new ItemStack[]{IS});
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Extractor))) {
                int cost = Kingdoms.config.structure_extractor_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kp.getPlayer().getInventory().firstEmpty() == -1) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Inventory_Full));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                ItemStack IS = GameManagement.getStructureManager().getExtractorDisk();
                kp.getPlayer().getInventory().addItem(new ItemStack[]{IS});
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_WarpPad))) {
                int cost = Kingdoms.config.structure_warppad_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kp.getPlayer().getInventory().firstEmpty() == -1) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Inventory_Full));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                ItemStack IS = GameManagement.getStructureManager().getWarpPadDisk();
                kp.getPlayer().getInventory().addItem(new ItemStack[]{IS});
            } else if (displayName.equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Regulator))) {
                int cost = Kingdoms.config.structure_regulator_cost;
                if (kingdom.getResourcepoints() - cost < 0) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", "" + cost));
                    return;
                }
                if (kp.getPlayer().getInventory().firstEmpty() == -1) {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Inventory_Full));
                    return;
                }
                kingdom.setResourcepoints(kingdom.getResourcepoints() - cost);
                ItemStack IS = GameManagement.getStructureManager().getRegulatorDisk();
                kp.getPlayer().getInventory().addItem(new ItemStack[]{IS});
            }
        }
    }

    public void openMenu(KingdomPlayer kp) {
        Kingdom kingdom = kp.getKingdom();
        Inventory menu = Bukkit.createInventory(null, (int)27, (String)(ChatColor.AQUA + "Structure Shop"));
        ItemStack i1 = new ItemStack(Material.MAGMA_CREAM);
        ItemMeta i1m = i1.getItemMeta();
        i1m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Powercell));
        ArrayList<String> i1l = new ArrayList<String>();
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Powercell_Desc));
        String cost = "" + Kingdoms.config.structure_powercell_cost;
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i1l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Placement_Instructions));
        i1l.add(ChatColor.LIGHT_PURPLE + "Placable Structure");
        i1m.setLore(LoreOrganizer.organize(i1l));
        i1.setItemMeta(i1m);
        if (!Kingdoms.config.structure_powercell_enabled) {
            i1 = new ItemStack(Material.AIR);
        }
        ItemStack i2 = new ItemStack(Material.WHEAT);
        ItemMeta i2m = i2.getItemMeta();
        i2m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Outpost));
        ArrayList<String> i2l = new ArrayList<String>();
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Outpost_Desc));
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Placement_Instructions));
        cost = "" + Kingdoms.config.structure_outpost_cost;
        i2l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i2l.add(ChatColor.LIGHT_PURPLE + "Placable Structure");
        i2m.setLore(LoreOrganizer.organize(i2l));
        i2.setItemMeta(i2m);
        if (!Kingdoms.config.structure_powercell_enabled) {
            i2 = new ItemStack(Material.AIR);
        }
        ItemStack i3 = new ItemStack(Material.IRON_PICKAXE);
        ItemMeta i3m = i3.getItemMeta();
        i3m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Extractor));
        ArrayList<String> i3l = new ArrayList<String>();
        i3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Extractor_Desc));
        i3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Placement_Instructions));
        cost = "" + Kingdoms.config.structure_extractor_cost;
        i3l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i3l.add(ChatColor.LIGHT_PURPLE + "Placable Structure");
        i3m.setLore(LoreOrganizer.organize(i3l));
        i3.setItemMeta(i3m);
        if (!Kingdoms.config.structure_powercell_enabled) {
            i3 = new ItemStack(Material.AIR);
        }
        ItemStack i4 = new ItemStack(Material.PRISMARINE_CRYSTALS);
        ItemMeta i4m = i4.getItemMeta();
        i4m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_WarpPad));
        ArrayList<String> i4l = new ArrayList<String>();
        i4l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_WarpPad_Desc));
        i4l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Placement_Instructions));
        cost = "" + Kingdoms.config.structure_warppad_cost;
        i4l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i4l.add(ChatColor.LIGHT_PURPLE + "Placable Structure");
        i4m.setLore(LoreOrganizer.organize(i4l));
        i4.setItemMeta(i4m);
        if (!Kingdoms.config.structure_warppad_enabled) {
            i4 = new ItemStack(Material.AIR);
        }
        ItemStack i5 = new ItemStack(Material.REDSTONE_LAMP_OFF);
        ItemMeta i5m = i5.getItemMeta();
        i5m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Regulator));
        ArrayList<String> i5l = new ArrayList<String>();
        i5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Regulator_Desc));
        i5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Structures_Placement_Instructions));
        cost = "" + Kingdoms.config.structure_regulator_cost;
        i5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Cost_Text).replaceAll("%cost%", cost));
        i5l.add(ChatColor.LIGHT_PURPLE + "Placable Structure");
        i5m.setLore(LoreOrganizer.organize(i5l));
        i5.setItemMeta(i5m);
        if (!Kingdoms.config.structure_regulator_enabled) {
            i5 = new ItemStack(Material.AIR);
        }
        ItemStack r = new ItemStack(Material.HAY_BLOCK);
        ItemMeta rm = r.getItemMeta();
        rm.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Title));
        ArrayList<String> rl = new ArrayList<String>();
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Desc));
        rl.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_ResourcePoints_Count).replaceAll("%amount%", "" + kingdom.getResourcepoints()));
        rm.setLore(LoreOrganizer.organize(rl));
        r.setItemMeta(rm);
        ItemStack backbtn = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta backbtnmeta = backbtn.getItemMeta();
        backbtnmeta.setDisplayName(ChatColor.RED + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Back_Btn));
        backbtn.setItemMeta(backbtnmeta);
        menu.setItem(17, r);
        menu.setItem(26, backbtn);
        menu.addItem(new ItemStack[]{i1});
        menu.addItem(new ItemStack[]{i2});
        menu.addItem(new ItemStack[]{i3});
        menu.addItem(new ItemStack[]{i4});
        menu.addItem(new ItemStack[]{i5});
        kp.getPlayer().openInventory(menu);
    }

    @Override
    public void onDisable() {
    }
}

