/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.Regulator;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.gui.GUIManagement;
import org.kingdoms.manager.gui.ScrollerInventory;
import org.kingdoms.utils.LoreOrganizer;

public class RegulatorGUIManager
extends Manager {
    HashMap<UUID, Regulator> regulators = new HashMap();

    protected RegulatorGUIManager(Plugin plugin) {
        super(plugin);
    }

    public void openRegulatorMenu(KingdomPlayer kp, Land land) {
        Kingdom kingdom = kp.getKingdom();
        Regulator regulator = (Regulator)land.getStructure();
        Inventory regulatorInv = Bukkit.createInventory(null, (int)27, (String)(ChatColor.AQUA + "[" + land.getLoc().toString() + "]"));
        ItemStack i3 = new ItemStack(Material.WOOL);
        ItemMeta i3m = i3.getItemMeta();
        i3m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_WhoCanBuild_Title));
        ArrayList<String> i3l = new ArrayList<String>();
        i3m.setLore(LoreOrganizer.organize(i3l));
        i3.setItemMeta(i3m);
        ItemStack i4 = new ItemStack(Material.WOOL);
        ItemMeta i4m = i4.getItemMeta();
        i4m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_WhoCanInteract_Title));
        ArrayList<String> i4l = new ArrayList<String>();
        i4m.setLore(LoreOrganizer.organize(i4l));
        i4.setItemMeta(i4m);
        ItemStack i5 = new ItemStack(Material.ROTTEN_FLESH);
        ItemMeta i5m = i5.getItemMeta();
        i5m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_CanMonstersSpawn_Title));
        ArrayList<String> i5l = new ArrayList<String>();
        if (regulator.isAllowMonsterSpawning()) {
            i5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled));
        } else {
            i5l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Disabled));
        }
        i5m.setLore(LoreOrganizer.organize(i5l));
        i5.setItemMeta(i5m);
        ItemStack i6 = new ItemStack(Material.PORK);
        ItemMeta i6m = i6.getItemMeta();
        i6m.setDisplayName(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_CanAnimalsSpawn_Title));
        ArrayList<String> i6l = new ArrayList<String>();
        if (regulator.isAllowAnimalSpawning()) {
            i6l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Enabled));
        } else {
            i6l.add(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Misc_Disabled));
        }
        i6m.setLore(LoreOrganizer.organize(i6l));
        i6.setItemMeta(i6m);
        regulatorInv.addItem(new ItemStack[]{i3});
        regulatorInv.addItem(new ItemStack[]{i4});
        if (Kingdoms.config.regulatorAllowMonsterToggle) {
            regulatorInv.addItem(new ItemStack[]{i5});
        }
        if (Kingdoms.config.regulatorAllowAnimalToggle) {
            regulatorInv.addItem(new ItemStack[]{i6});
        }
        this.regulators.put(kp.getUuid(), regulator);
        kp.getPlayer().openInventory(regulatorInv);
    }

    @EventHandler
    public void onClickRegulatorMenu(InventoryClickEvent e) {
        if (e.getClickedInventory() == null) {
            return;
        }
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta().getDisplayName() == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        Kingdoms.getManagers();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(p);
        if (e.getCurrentItem().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_WhoCanBuild_Title))) {
            this.openRegulatorWhoCanBuildMenu(kp, this.regulators.get(kp.getUuid()));
            e.setCancelled(true);
        } else if (e.getCurrentItem().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_WhoCanInteract_Title))) {
            this.openRegulatorWhoCanInteractMenu(kp, this.regulators.get(kp.getUuid()));
            e.setCancelled(true);
        } else if (e.getCurrentItem().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_CanMonstersSpawn_Title))) {
            if (this.regulators.get(kp.getUuid()).isAllowMonsterSpawning()) {
                this.regulators.get(kp.getUuid()).setAllowMonsterSpawning(false);
            } else {
                this.regulators.get(kp.getUuid()).setAllowMonsterSpawning(true);
            }
            Kingdoms.getManagers();
            this.openRegulatorMenu(kp, GameManagement.getLandManager().getOrLoadLand(this.regulators.get(kp.getUuid()).getLoc().toSimpleChunk()));
            e.setCancelled(true);
        } else if (e.getCurrentItem().getItemMeta().getDisplayName().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_CanAnimalsSpawn_Title))) {
            if (this.regulators.get(kp.getUuid()).isAllowAnimalSpawning()) {
                this.regulators.get(kp.getUuid()).setAllowAnimalSpawning(false);
            } else {
                this.regulators.get(kp.getUuid()).setAllowAnimalSpawning(true);
            }
            Kingdoms.getManagers();
            this.openRegulatorMenu(kp, GameManagement.getLandManager().getOrLoadLand(this.regulators.get(kp.getUuid()).getLoc().toSimpleChunk()));
            e.setCancelled(true);
        }
    }

    public void openRegulatorWhoCanBuildMenu(KingdomPlayer kp, Regulator regulator) {
        Kingdom kingdom = kp.getKingdom();
        if (kp.getKingdom() == null) {
            return;
        }
        ArrayList<ItemStack> members = new ArrayList<ItemStack>();
        for (UUID uuid : kingdom.getMembersList()) {
            OfflineKingdomPlayer okp;
            if (uuid.equals(kp.getUuid()) || (okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(uuid)) == null) continue;
            members.add(this.getByStatusCanBuild(regulator, okp));
        }
        new ScrollerInventory(members, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_WhoCanBuild_Title), kp.getPlayer());
    }

    @EventHandler
    public void onClickCanBuildButton(InventoryClickEvent e) {
        if (e.getClickedInventory() == null) {
            return;
        }
        if (e.getClickedInventory().getTitle() == null) {
            return;
        }
        if (!e.getClickedInventory().getTitle().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_WhoCanBuild_Title))) {
            return;
        }
        e.setCancelled(true);
        if (!GUIManagement.allowedActions.contains(e.getAction())) {
            return;
        }
        ItemStack clickedItem = e.getCurrentItem();
        if (clickedItem.getItemMeta() == null) {
            return;
        }
        if (clickedItem.getItemMeta().getDisplayName() == null) {
            return;
        }
        if (clickedItem.getItemMeta().getLore() == null) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)e.getWhoClicked());
        Regulator regulator = this.regulators.get(kp.getUuid());
        String playerName = clickedItem.getItemMeta().getDisplayName();
        OfflinePlayer offp = Bukkit.getOfflinePlayer((String)playerName);
        if (offp != null) {
            if (clickedItem.getData().getData() == DyeColor.RED.getWoolData()) {
                if (!regulator.getWhoCanBuild().contains(offp.getUniqueId())) {
                    regulator.getWhoCanBuild().add(offp.getUniqueId());
                }
            } else {
                regulator.getWhoCanBuild().remove(offp.getUniqueId());
            }
        }
        this.regulators.put(kp.getUuid(), regulator);
        this.openRegulatorWhoCanBuildMenu(kp, this.regulators.get(kp.getUuid()));
    }

    private ItemStack getByStatusCanBuild(Regulator regulator, OfflineKingdomPlayer okp) {
        if (regulator.getWhoCanBuild().contains(okp.getUuid())) {
            return this.makeButton(Material.WOOL, DyeColor.GREEN.getWoolData(), okp.getName(), LanguageSupport.Languages.Guis_Regulator_CanBuild_Title);
        }
        return this.makeButton(Material.WOOL, DyeColor.RED.getWoolData(), okp.getName(), LanguageSupport.Languages.Guis_Regulator_CannotBuild_Title);
    }

    public void openRegulatorWhoCanInteractMenu(KingdomPlayer kp, Regulator regulator) {
        Kingdom kingdom = kp.getKingdom();
        if (kp.getKingdom() == null) {
            return;
        }
        ArrayList<ItemStack> members = new ArrayList<ItemStack>();
        for (UUID uuid : kingdom.getMembersList()) {
            OfflineKingdomPlayer okp;
            if (uuid.equals(kp.getUuid()) || (okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(uuid)) == null) continue;
            members.add(this.getByStatusCanInteract(regulator, okp));
        }
        new ScrollerInventory(members, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_WhoCanInteract_Title), kp.getPlayer());
    }

    @EventHandler
    public void onClickCanInteractButton(InventoryClickEvent e) {
        if (e.getClickedInventory() == null) {
            return;
        }
        if (e.getClickedInventory().getTitle() == null) {
            return;
        }
        if (!e.getClickedInventory().getTitle().equals(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Regulator_WhoCanInteract_Title))) {
            return;
        }
        e.setCancelled(true);
        if (!GUIManagement.allowedActions.contains(e.getAction())) {
            return;
        }
        ItemStack clickedItem = e.getCurrentItem();
        if (clickedItem.getItemMeta() == null) {
            return;
        }
        if (clickedItem.getItemMeta().getDisplayName() == null) {
            return;
        }
        if (clickedItem.getItemMeta().getLore() == null) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession((Player)e.getWhoClicked());
        Regulator regulator = this.regulators.get(kp.getUuid());
        String playerName = clickedItem.getItemMeta().getDisplayName();
        OfflinePlayer offp = Bukkit.getOfflinePlayer((String)playerName);
        if (offp != null) {
            if (clickedItem.getData().getData() == DyeColor.RED.getWoolData()) {
                if (!regulator.getWhoCanInteract().contains(offp.getUniqueId())) {
                    regulator.getWhoCanInteract().add(offp.getUniqueId());
                }
            } else {
                regulator.getWhoCanInteract().remove(offp.getUniqueId());
            }
        }
        this.regulators.put(kp.getUuid(), regulator);
        this.openRegulatorWhoCanInteractMenu(kp, this.regulators.get(kp.getUuid()));
    }

    private ItemStack getByStatusCanInteract(Regulator regulator, OfflineKingdomPlayer okp) {
        if (regulator.getWhoCanInteract().contains(okp.getUuid())) {
            return this.makeButton(Material.WOOL, DyeColor.GREEN.getWoolData(), okp.getName(), LanguageSupport.Languages.Guis_Regulator_CanInteract_Title);
        }
        return this.makeButton(Material.WOOL, DyeColor.RED.getWoolData(), okp.getName(), LanguageSupport.Languages.Guis_Regulator_CannotInteract_Title);
    }

    private ItemStack makeButton(Material mat, byte id, String title, LanguageSupport.Languages ... lore) {
        ItemStack IS = new ItemStack(mat, 1, (short)id);
        ItemMeta IM = IS.getItemMeta();
        IM.setDisplayName(title);
        ArrayList<String> l = new ArrayList<String>();
        LanguageSupport.Languages[] languagesArray = lore;
        int n = lore.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageSupport.Languages lang = languagesArray[n2];
            l.add(Kingdoms.getLang().parseFirstString(lang));
            ++n2;
        }
        IM.setLore(l);
        IS.setItemMeta(IM);
        return IS;
    }

    @Override
    public void onDisable() {
    }
}

