/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.gui;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.gui.ScrollerInventory;

public class MemberManagerGui
extends Manager {
    private final String TITLE = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Member_Manager_Title);

    protected MemberManagerGui(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onInvMove(InventoryClickEvent event) {
        if (event.getInventory().getName() != null && event.getInventory().getName().equals(this.TITLE)) {
            event.setCancelled(true);
        }
    }

    public void openMenu(KingdomPlayer kp) {
        if (kp.getKingdom() == null) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        ArrayList<ItemStack> members = new ArrayList<ItemStack>();
        for (UUID uuid : kingdom.getMembersList()) {
            OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(uuid);
            if (okp == null) continue;
            members.add(this.getByInfo(okp));
        }
        new ScrollerInventory(members, this.TITLE, kp.getPlayer());
    }

    public ItemStack getByInfo(OfflineKingdomPlayer player) {
        DyeColor color = null;
        if (player.getLastTimeDonated() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(player.getLastTimeDonated());
            cal.add(6, 5);
            Date future = cal.getTime();
            if (new Date().after(future)) {
                color = DyeColor.RED;
            } else {
                color = DyeColor.LIME;
                if (player.getLastDonatedAmt() < 100) {
                    color = DyeColor.YELLOW;
                }
            }
        } else {
            color = DyeColor.RED;
        }
        String rank = ChatColor.GRAY + "[" + ChatColor.YELLOW + player.getRank().toString() + ChatColor.GRAY + "]";
        String lastTime = Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Member_NeverDonated);
        if (player.getLastTimeDonated() != null) {
            lastTime = DateFormat.getDateInstance(2).format(player.getLastTimeDonated());
        }
        ItemStack member = this.makeButton(Material.WOOL, color, String.valueOf(rank) + ChatColor.AQUA + player.getName(), LanguageSupport.Languages.Guis_Member_Lore, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Member_LastTimeDonated).replaceAll("%lasttime%", lastTime), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Member_LastTimeDonatedAmt).replaceAll("%amt%", String.valueOf(player.getLastDonatedAmt())), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Guis_Member_TotalDonated).replaceAll("%amt%", "" + player.getDonatedAmt()));
        return member;
    }

    private ItemStack makeButton(Material mat, DyeColor color, String title, LanguageSupport.Languages btnType, String ... lore) {
        ItemStack IS = new ItemStack(mat, 1, (short)color.getWoolData());
        ItemMeta IM = IS.getItemMeta();
        IM.setDisplayName(title);
        ArrayList<String> l = new ArrayList<String>();
        String[] stringArray = lore;
        int n = lore.length;
        int n2 = 0;
        while (n2 < n) {
            String lores = stringArray[n2];
            l.add(lores);
            ++n2;
        }
        l.add(Kingdoms.getLang().parseFirstString(btnType));
        IM.setLore(l);
        IS.setItemMeta(IM);
        return IS;
    }

    @Override
    public void onDisable() {
    }
}

