/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.StructureType;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.KingdomChest;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomPlayerLostEvent;
import org.kingdoms.events.KingdomPlayerWonEvent;
import org.kingdoms.events.KingdomResourcePointChangeEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;

public class FightManager
extends Manager
implements Listener {
    protected FightManager(Plugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onChallengerWin(KingdomPlayerWonEvent e) {
        KingdomPlayer challenger = e.getChallenger();
        Kingdom attacker = challenger.getKingdom();
        Kingdom defender = e.getLostKingdom();
        SimpleChunkLocation chunk = e.getChunk();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        attacker.addInvasionLog(defender, challenger, true, land);
        defender.addInvasionLog(defender, challenger, false, land);
        if (land == null) {
            Kingdoms.logInfo((String)"land was null!");
            return;
        }
        attacker.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Invasion_Victory).replaceAll("%chunk%", chunk.toString()).replaceAll("%kingdom%", defender.getKingdomName()), true);
        if (land.getStructure() != null) {
            if (land.getStructure().getType() == StructureType.NEXUS) {
                List<ItemStack> ISs;
                GameManagement.getNexusManager().breakNexus(land);
                int temp = defender.getResourcepoints();
                defender.setResourcepoints(0);
                attacker.setResourcepoints(attacker.getResourcepoints() + temp);
                Bukkit.getPluginManager().callEvent((Event)new KingdomResourcePointChangeEvent(attacker, temp));
                if (defender.getKingdomChest().getUsing() != null) {
                    defender.getKingdomChest().getUsing().getPlayer().closeInventory();
                }
                if ((ISs = defender.getKingdomChest().getInv()) != null) {
                    for (ItemStack IS : ISs) {
                        challenger.getPlayer().getWorld().dropItemNaturally(challenger.getPlayer().getLocation(), IS);
                    }
                }
                KingdomChest chest = new KingdomChest();
                chest.setInv(new ArrayList<ItemStack>());
                defender.setKingdomChest(chest);
                attacker.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Invasion_Nexus_Victory).replaceAll("%rp%", String.valueOf(temp)).replaceAll("%kingdom%", defender.getKingdomName()), true);
            } else if (land.getStructure().getType() == StructureType.POWERCELL) {
                GameManagement.getStructureManager().breakStructure(land);
            }
        }
        land.setOwner(attacker.getKingdomName());
        GameManagement.getVisualManager().visualizeLand(challenger, chunk);
        attacker.setLand(attacker.getLand() + 1);
        defender.setLand(defender.getLand() - 1);
    }

    @EventHandler
    public void onChallengerLose(KingdomPlayerLostEvent e) {
        KingdomPlayer challenger = e.getChallenger();
        SimpleChunkLocation chunk = e.getLoc();
        Land land = GameManagement.getLandManager().getOrLoadLand(chunk);
        Kingdom attacker = challenger.getKingdom();
        Kingdom defender = e.getDefender();
        attacker.addInvasionLog(defender, challenger, false, land);
        defender.addInvasionLog(defender, challenger, true, land);
    }

    @Override
    public void onDisable() {
    }
}

