/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.game;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.naming.NamingException;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.generallib.database.Database;
import org.generallib.database.file.DatabaseFile;
import org.generallib.database.mysql.DatabaseMysql;
import org.generallib.database.tasks.DatabaseTransferTask;
import org.kingdoms.constants.conquest.ActiveConquestBattle;
import org.kingdoms.constants.conquest.ConquestLand;
import org.kingdoms.constants.conquest.ConquestMap;
import org.kingdoms.constants.conquest.ConquestTurret;
import org.kingdoms.constants.conquest.SchematicParser;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.KingdomCooldown;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;

public class ConquestManager
extends Manager {
    public static World world;
    public static HashMap<String, ConquestMap> maps;
    public static HashMap<Kingdom, ActiveConquestBattle> kingdomsMissions;
    static int highestX;
    static int highestZ;
    private static Database<ConquestLand> db;
    private Thread autoSaveThread;
    public static HashMap<UUID, Location> locations;
    public static HashMap<UUID, Double> hp;
    public static HashMap<UUID, Integer> food;

    static {
        maps = new HashMap();
        kingdomsMissions = new HashMap();
        highestX = 15;
        highestZ = 15;
        locations = new HashMap();
        hp = new HashMap();
        food = new HashMap();
    }

    protected ConquestManager(Plugin plugin) {
        super(plugin);
        world = Bukkit.getWorld((String)"KingdomsConquest");
        if (!Kingdoms.config.worlds.contains("KingdomsConquest")) {
            Kingdoms.config.worlds.add("KingdomsConquest");
        }
        if (world == null) {
            Bukkit.createWorld((WorldCreator)WorldCreator.name((String)"KingdomsConquest").type(WorldType.FLAT).generatorSettings("3;minecraft:air;2").generateStructures(false));
            world = Bukkit.getWorld((String)"KingdomsConquest");
        }
        db = this.createFileDB();
        Kingdoms.logInfo((String)"Using file database for Conquest Map data");
        maps.clear();
        this.autoSaveThread = new Thread(new AutoSaveTask());
        this.autoSaveThread.setPriority(1);
        this.autoSaveThread.start();
        this.loadSchematics();
        this.loadAll();
        Bukkit.getScheduler().scheduleAsyncRepeatingTask(plugin, (Runnable)new ConquestMapLogisticsTask(this), 0L, (long)(1200 * Kingdoms.config.conquestLogisticsLoopTime));
    }

    public boolean createNewConquestMap(String name) {
        if (!maps.containsKey(name.toLowerCase())) {
            ConquestMap map = new ConquestMap(name.toLowerCase());
            maps.put(name.toLowerCase(), map);
            return true;
        }
        return false;
    }

    public boolean deleteConquestMap(String name) {
        if (maps.containsKey(name.toLowerCase())) {
            ArrayList<Kingdom> delete = new ArrayList<Kingdom>();
            for (Kingdom kingdom : kingdomsMissions.keySet()) {
                ActiveConquestBattle battle = kingdomsMissions.get(kingdom);
                if (!battle.land.map.equals(maps.get(name.toLowerCase()))) continue;
                battle.stopInvasionServerStop();
                delete.add(kingdom);
            }
            for (Kingdom k : delete) {
                kingdomsMissions.remove(k);
            }
            maps.remove(name.toLowerCase());
            return true;
        }
        return false;
    }

    public static ActiveConquestBattle createNewArena(ConquestLand land, Kingdom invader) {
        int nextChunk = 5;
        ActiveConquestBattle c = new ActiveConquestBattle(world.getChunkAt(highestX + nextChunk, highestZ + nextChunk), land);
        c.getMiddle().load();
        try {
            Skull s;
            Block turretBlock;
            if (land.getWalllevel() == 0) {
                SchematicParser.pasteSchematic(c.getMiddle().getWorld(), "nowall.schematic", c.getMiddle().getBlock(0, 100, 0).getLocation());
            } else if (land.getWalllevel() == 1) {
                SchematicParser.pasteSchematic(c.getMiddle().getWorld(), "wall1.schematic", c.getMiddle().getBlock(0, 100, 0).getLocation());
            } else if (land.getWalllevel() == 2) {
                SchematicParser.pasteSchematic(c.getMiddle().getWorld(), "wall2.schematic", c.getMiddle().getBlock(0, 100, 0).getLocation());
            } else if (land.getWalllevel() == 3) {
                SchematicParser.pasteSchematic(c.getMiddle().getWorld(), "wall3.schematic", c.getMiddle().getBlock(0, 100, 0).getLocation());
            }
            Chunk tchunk = c.getMiddle().getWorld().getChunkAt(c.getMiddle().getX(), c.getMiddle().getZ() + 1);
            c.turrets.put(1, new ConquestTurret(c, tchunk.getBlock(12, 102, 0).getLocation(), land.getTurretLevelAtSlot(1)));
            c.turrets.put(2, new ConquestTurret(c, tchunk.getBlock(9, 102, 0).getLocation(), land.getTurretLevelAtSlot(2)));
            c.turrets.put(3, new ConquestTurret(c, tchunk.getBlock(6, 102, 0).getLocation(), land.getTurretLevelAtSlot(3)));
            c.turrets.put(4, new ConquestTurret(c, tchunk.getBlock(3, 102, 0).getLocation(), land.getTurretLevelAtSlot(4)));
            if (land.getTurretLevelAtSlot(1) > 0) {
                turretBlock = tchunk.getBlock(12, 102, 0);
                turretBlock.setType(Material.SKULL);
                turretBlock.setData((byte)1);
                s = (Skull)turretBlock.getState();
                s.setSkullType(SkullType.SKELETON);
                s.setRotation(BlockFace.SOUTH);
                s.update();
            }
            if (land.getTurretLevelAtSlot(2) > 0) {
                turretBlock = tchunk.getBlock(9, 102, 0);
                turretBlock.setType(Material.SKULL);
                turretBlock.setData((byte)1);
                s = (Skull)turretBlock.getState();
                s.setSkullType(SkullType.SKELETON);
                s.setRotation(BlockFace.SOUTH);
                s.update();
            }
            if (land.getTurretLevelAtSlot(3) > 0) {
                turretBlock = tchunk.getBlock(6, 102, 0);
                turretBlock.setType(Material.SKULL);
                turretBlock.setData((byte)1);
                s = (Skull)turretBlock.getState();
                s.setSkullType(SkullType.SKELETON);
                s.setRotation(BlockFace.SOUTH);
                s.update();
            }
            if (land.getTurretLevelAtSlot(4) > 0) {
                turretBlock = tchunk.getBlock(3, 102, 0);
                turretBlock.setType(Material.SKULL);
                turretBlock.setData((byte)1);
                s = (Skull)turretBlock.getState();
                s.setSkullType(SkullType.SKELETON);
                s.setRotation(BlockFace.SOUTH);
                s.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        highestX = c.getMiddle().getX();
        highestZ = c.getMiddle().getZ();
        return c;
    }

    public static boolean startOffensive(KingdomPlayer first, Kingdom invader, ConquestLand land) {
        if (land.isUnderSiege) {
            return false;
        }
        land.isUnderSiege = true;
        ActiveConquestBattle battle = ConquestManager.createNewArena(land, invader);
        battle.invadingKingdom = invader;
        kingdomsMissions.put(invader, battle);
        KingdomCooldown cooldown = new KingdomCooldown(invader.getKingdomName(), "attackcd", 60 * Kingdoms.config.conquestAttackCooldown);
        cooldown.start();
        ConquestManager.joinOffensive(first);
        return true;
    }

    public static void storePreGameInfo(Player p) {
        p.setGameMode(GameMode.SURVIVAL);
        locations.put(p.getUniqueId(), p.getLocation());
        hp.put(p.getUniqueId(), p.getHealth());
        food.put(p.getUniqueId(), p.getFoodLevel());
        p.setHealth(p.getMaxHealth());
        p.setFoodLevel(20);
    }

    public static void restorePreGameInfo(Player p) {
        p.setHealth(hp.get(p.getUniqueId()).doubleValue());
        p.setFoodLevel(food.get(p.getUniqueId()).intValue());
        p.teleport(locations.get(p.getUniqueId()));
    }

    public static void joinOffensive(KingdomPlayer kp) {
        Kingdom k = kp.getKingdom();
        ActiveConquestBattle battle = kingdomsMissions.get(k);
        battle.invaders.add(kp);
        ConquestManager.storePreGameInfo(kp.getPlayer());
        Chunk invaderchunk = world.getChunkAt(battle.getMiddle().getX(), battle.getMiddle().getZ() + 2);
        Location invaderLoc = invaderchunk.getBlock(8, 101, 8).getLocation();
        invaderLoc.setYaw(180.0f);
        kp.getPlayer().setGameMode(GameMode.SURVIVAL);
        kp.getPlayer().setAllowFlight(false);
        kp.getPlayer().teleport(invaderLoc);
    }

    public static void leaveOffensive(KingdomPlayer kp) {
        Kingdom k = kp.getKingdom();
        if (k == null) {
            return;
        }
        ActiveConquestBattle battle = kingdomsMissions.get(k);
        if (battle == null) {
            return;
        }
        if (battle.invaders.contains(kp)) {
            ConquestManager.restorePreGameInfo(kp.getPlayer());
            battle.invaders.remove(kp);
        }
        if (battle.invaders.size() == 0) {
            battle.concludeDefeat();
        }
    }

    @Override
    public void onDisable() {
        for (Kingdom kingdom : kingdomsMissions.keySet()) {
            kingdomsMissions.get(kingdom).stopInvasionServerStop();
        }
        kingdomsMissions.clear();
        this.autoSaveThread.interrupt();
        try {
            this.autoSaveThread.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        Kingdoms.logInfo((String)"Saving loaded conquest lands and maps...");
        try {
            this.saveAll();
            Kingdoms.logInfo((String)"Done!");
        }
        catch (Exception e) {
            Kingdoms.logInfo((String)"SQL connection failed! Saving to file DB");
            db = this.createFileDB();
            this.saveAll();
            Kingdoms.config.grabConquestMapsFromFileDB = true;
        }
        maps.clear();
    }

    private void loadSchematics() {
        ArrayList<String> schematics = new ArrayList<String>(){
            {
                this.add("nowall.schematic");
                this.add("wall1.schematic");
                this.add("wall2.schematic");
                this.add("wall3.schematic");
            }
        };
        for (String name : schematics) {
            File schematic = new File(name);
            if (schematic.exists()) continue;
            InputStream ddlStream = Kingdoms.class.getClassLoader().getResourceAsStream(name);
            try {
                int r;
                FileOutputStream fos = new FileOutputStream(name);
                byte[] buf = new byte[2048];
                while (-1 != (r = ddlStream.read(buf))) {
                    fos.write(buf, 0, r);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveAll() {
        HashMap<String, ConquestMap> hashMap = maps;
        synchronized (hashMap) {
            for (ConquestMap map : maps.values()) {
                for (ConquestLand land : map.lands) {
                    Kingdoms.logColor((String)("Saving conquest land: " + land.getDataID()));
                    try {
                        db.save(land.getDataID(), (Object)land);
                    }
                    catch (Exception e) {
                        if (Kingdoms.config.isDebugging) {
                            e.printStackTrace();
                        }
                        Bukkit.getLogger().severe("[Kingdoms] Failed autosave for a conquest map!");
                    }
                }
            }
        }
    }

    private synchronized void loadAll() {
        HashMap<ConquestLand, String> landToMap = new HashMap<ConquestLand, String>();
        ArrayList<String> conquestMapNames = new ArrayList<String>();
        if (db == null) {
            return;
        }
        for (String s : db.getKeys()) {
            Kingdoms.logColor((String)("Loading conquest land: " + s));
            ConquestLand land = (ConquestLand)db.load(s, null);
            if (land == null) {
                Kingdoms.logInfo((String)("Error: Conquestland, " + s + " could not be loaded!"));
                continue;
            }
            if (land.map == null) {
                Kingdoms.logInfo((String)("Error: Conquestland, " + s + " could not be loaded!"));
                continue;
            }
            if (!conquestMapNames.contains(land.map)) {
                conquestMapNames.add(land.map);
            }
            landToMap.put(land, land.map);
        }
        for (String name : conquestMapNames) {
            ArrayList<ConquestLand> lands = new ArrayList<ConquestLand>();
            for (ConquestLand land : landToMap.keySet()) {
                land.isUnderSiege = false;
                if (!land.map.equalsIgnoreCase(name)) continue;
                lands.add(land);
            }
            maps.put(name, new ConquestMap(name, lands));
        }
    }

    public DatabaseFile<ConquestLand> createFileDB() {
        return new DatabaseFile(new File(this.plugin.getDataFolder(), "conquestmaps"), ConquestLand.class);
    }

    public DatabaseMysql<ConquestLand> createMysqlDB() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NamingException {
        return new DatabaseMysql(Kingdoms.config.dbAddress, Kingdoms.config.dbName, "conquestmaps", Kingdoms.config.dbUser, Kingdoms.config.dbPassword, Kingdom.class);
    }

    public DatabaseTransferTask.TransferPair<ConquestLand> getTransferPair(Database<ConquestLand> from) {
        return new DatabaseTransferTask.TransferPair(from, db);
    }

    private class AutoSaveTask
    implements Runnable {
        private AutoSaveTask() {
        }

        @Override
        public void run() {
            while (ConquestManager.this.plugin.isEnabled()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Kingdoms.logInfo((String)"Kingdom auto save is interrupted.");
                    return;
                }
                ConquestManager.this.saveAll();
            }
        }
    }

    private class ConquestMapLogisticsTask
    implements Runnable {
        ConquestManager manager;

        public ConquestMapLogisticsTask(ConquestManager manager) {
            this.manager = manager;
        }

        @Override
        public void run() {
            Kingdoms.logDebug((String)"ConquestLogistics Loop Initiate");
            for (ConquestMap map : maps.values()) {
                for (ConquestLand land : map.lands) {
                    if (land.getOwner() == null) continue;
                    int income = Kingdoms.config.conquestLandReward;
                    if (land.isCapital()) {
                        income = Kingdoms.config.conquestCapitalReward;
                    }
                    int upkeep = land.getUpKeepAmount();
                    Kingdoms.getManagers();
                    Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
                    income -= upkeep;
                    if (land.isEncircled() && upkeep > 0) {
                        income = 0;
                        land.setSupplylevel(land.getSupplylevel() - upkeep);
                        kingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Conquests_Land_Is_Encircled).replaceAll("%land%", land.getDataID()), true);
                    }
                    if (kingdom.getResourcepoints() + income > 0) {
                        kingdom.setResourcepoints(kingdom.getResourcepoints() + income);
                        continue;
                    }
                    if (land.isEncircled()) continue;
                    land.setSupplylevel(land.getSupplylevel() - upkeep);
                    kingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Conquests_Land_Is_UnderSupplied).replaceAll("%land%", land.getDataID()), true);
                }
            }
        }
    }
}

