/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.external;

import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.Manager;

public class VaultManager
extends Manager {
    private static Economy econ;

    protected VaultManager(Plugin plugin) {
        super(plugin);
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp != null) {
            econ = (Economy)rsp.getProvider();
        }
        if (econ != null) {
            Kingdoms.logInfo((String)"Vault Hooked!");
        } else {
            Kingdoms.logInfo((String)"Vault could not be hooked into!");
        }
    }

    @Override
    public void onDisable() {
    }

    public static double getBalance(OfflinePlayer p) {
        if (econ == null) {
            return 0.0;
        }
        return econ.getBalance(p);
    }

    public static void withdraw(OfflinePlayer p, double amt) {
        if (econ != null) {
            econ.withdrawPlayer(p, amt);
        }
    }

    public static void deposit(OfflinePlayer p, double amt) {
        if (econ != null) {
            econ.depositPlayer(p, amt);
        }
    }

    public Economy getEcon() {
        return econ;
    }
}

