/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.external;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import be.maximvdw.placeholderapi.PlaceholderReplaceEvent;
import be.maximvdw.placeholderapi.PlaceholderReplacer;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.game.GameManagement;

public class MVdWPlaceholderManager
extends Manager {
    protected MVdWPlaceholderManager(Plugin plugin) {
        super(plugin);
    }

    private void init() {
        PlaceholderAPI.registerPlaceholder((Plugin)Kingdoms.getInstance(), (String)"kingdom", (PlaceholderReplacer)new PlaceholderReplacer(){

            public String onPlaceholderReplace(PlaceholderReplaceEvent e) {
                OfflinePlayer op = e.getOfflinePlayer();
                if (op == null) {
                    return "none";
                }
                OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(op);
                if (okp == null) {
                    return "none";
                }
                if (okp.getKingdomName() == null) {
                    return "none";
                }
                return okp.getKingdomName();
            }
        });
        PlaceholderAPI.registerPlaceholder((Plugin)Kingdoms.getInstance(), (String)"rp", (PlaceholderReplacer)new PlaceholderReplacer(){

            public String onPlaceholderReplace(PlaceholderReplaceEvent e) {
                OfflinePlayer op = e.getOfflinePlayer();
                if (op == null) {
                    return "0";
                }
                OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(op);
                if (okp == null) {
                    return "0";
                }
                OfflineKingdom ok = GameManagement.getKingdomManager().getOfflineKingdom(okp.getKingdomName());
                if (ok == null) {
                    return "0";
                }
                return String.valueOf(ok.getResourcepoints());
            }
        });
        PlaceholderAPI.registerPlaceholder((Plugin)Kingdoms.getInstance(), (String)"land", (PlaceholderReplacer)new PlaceholderReplacer(){

            public String onPlaceholderReplace(PlaceholderReplaceEvent e) {
                OfflinePlayer op = e.getOfflinePlayer();
                if (op == null) {
                    return "0";
                }
                OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(op);
                if (okp == null) {
                    return "0";
                }
                Kingdom ok = GameManagement.getKingdomManager().getOrLoadKingdom(okp.getKingdomName());
                if (ok == null) {
                    return "0";
                }
                return String.valueOf(ok.getLand());
            }
        });
        PlaceholderAPI.registerPlaceholder((Plugin)Kingdoms.getInstance(), (String)"rank", (PlaceholderReplacer)new PlaceholderReplacer(){

            public String onPlaceholderReplace(PlaceholderReplaceEvent e) {
                Kingdoms.getManagers();
                OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(e.getOfflinePlayer());
                return String.valueOf(okp.getRank().getFancyMark());
            }
        });
        PlaceholderAPI.registerPlaceholder((Plugin)Kingdoms.getInstance(), (String)"onlinemembers", (PlaceholderReplacer)new PlaceholderReplacer(){

            public String onPlaceholderReplace(PlaceholderReplaceEvent e) {
                Player op = e.getPlayer();
                if (op == null) {
                    return "0";
                }
                KingdomPlayer kp = GameManagement.getPlayerManager().getSession(op);
                if (kp == null) {
                    return "0";
                }
                Kingdom k = kp.getKingdom();
                if (k == null) {
                    return "0";
                }
                return String.valueOf(k.getOnlineMembers().size());
            }
        });
        PlaceholderAPI.registerPlaceholder((Plugin)Kingdoms.getInstance(), (String)"members", (PlaceholderReplacer)new PlaceholderReplacer(){

            public String onPlaceholderReplace(PlaceholderReplaceEvent e) {
                OfflinePlayer op = e.getOfflinePlayer();
                if (op == null) {
                    return "0";
                }
                OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(op);
                if (okp == null) {
                    return "0";
                }
                OfflineKingdom ok = GameManagement.getKingdomManager().getOfflineKingdom(okp.getKingdomName());
                if (ok == null) {
                    return "0";
                }
                return String.valueOf(ok.getMembersList().size());
            }
        });
        PlaceholderAPI.registerPlaceholder((Plugin)Kingdoms.getInstance(), (String)"king", (PlaceholderReplacer)new PlaceholderReplacer(){

            public String onPlaceholderReplace(PlaceholderReplaceEvent e) {
                OfflinePlayer op = e.getOfflinePlayer();
                if (op == null) {
                    return "nil";
                }
                OfflineKingdomPlayer okp = GameManagement.getPlayerManager().getOfflineKingdomPlayer(op);
                if (okp == null) {
                    return "nil";
                }
                OfflineKingdom ok = GameManagement.getKingdomManager().getOfflineKingdom(okp.getKingdomName());
                if (ok == null) {
                    return "nil";
                }
                return ok.getKingName();
            }
        });
    }

    @Override
    public void onDisable() {
    }
}

