/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.manager.external;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.Manager;
import org.kingdoms.manager.external.ActionbarAPIManager;
import org.kingdoms.manager.external.CitizensManager;
import org.kingdoms.manager.external.DynmapManager;
import org.kingdoms.manager.external.MVdWPlaceholderManager;
import org.kingdoms.manager.external.PlaceholderAPIManager;
import org.kingdoms.manager.external.ResidenceManager;
import org.kingdoms.manager.external.ScoreboardManager;
import org.kingdoms.manager.external.TitleAPIManager;
import org.kingdoms.manager.external.VaultManager;
import org.kingdoms.manager.external.WorldGuardManager;

public class ExternalManager
extends Manager {
    private static PlaceholderAPIManager placeholderAPIManager;
    private static WorldGuardManager worldGuardManager;
    private static ResidenceManager residenceManager;
    private static ScoreboardManager scoreboardManager;
    private static PlaceholderAPIManager placeholderManager;
    private static MVdWPlaceholderManager mvdwplaceholderManager;
    private static TitleAPIManager titleAPIManager;
    private static ActionbarAPIManager actionBarAPIManager;
    private static MVdWPlaceholderManager mvdwPlaceholderManager;
    private static DynmapManager dynmapManager;
    private static VaultManager vaultManager;
    private static CitizensManager citizensManager;

    public ExternalManager(Plugin plugin) {
        super(plugin);
        PluginManager pm = Bukkit.getPluginManager();
        if (Kingdoms.config.useWorldguardSupport && pm.getPlugin("WorldGuard") != null) {
            worldGuardManager = new WorldGuardManager(plugin);
        }
        if (Kingdoms.config.useResidenceSupport && pm.getPlugin("Residence") != null) {
            residenceManager = new ResidenceManager(plugin);
        }
        if (Kingdoms.config.useTitleAPISupport && pm.getPlugin("TitleAPI") != null) {
            titleAPIManager = new TitleAPIManager(plugin);
        }
        if (Kingdoms.config.useActionBarAPISupport && pm.getPlugin("ActionBarAPI") != null) {
            actionBarAPIManager = new ActionbarAPIManager(plugin);
        }
        if (Kingdoms.config.useScoreboardStatsSupport && pm.getPlugin("ScoreboardStats") != null) {
            scoreboardManager = new ScoreboardManager(plugin);
        }
        if (Kingdoms.config.usePlaceHolderAPISupport && pm.getPlugin("PlaceholderAPI") != null) {
            placeholderAPIManager = new PlaceholderAPIManager(plugin);
        }
        if (Kingdoms.config.useMVdWPlaceHolderAPISupport && pm.getPlugin("MVdWPlaceholderAPI") != null) {
            mvdwPlaceholderManager = new MVdWPlaceholderManager(plugin);
        }
        if (Kingdoms.config.useDynmapSupport && pm.getPlugin("dynmap") != null) {
            dynmapManager = new DynmapManager(plugin);
        }
        if (pm.getPlugin("Vault") != null) {
            vaultManager = new VaultManager(plugin);
        }
        if (pm.getPlugin("Citizens") != null) {
            citizensManager = new CitizensManager(plugin);
        }
    }

    public static boolean isCitizen(Entity e) {
        if (citizensManager != null) {
            return citizensManager.isCitizen(e);
        }
        return false;
    }

    public static boolean isInRegion(Location loc) {
        if (worldGuardManager != null && WorldGuardManager.isInRegion(loc)) {
            return true;
        }
        return residenceManager != null && ResidenceManager.isInRegion(loc);
    }

    public static boolean canBuild(Player p, Location loc) {
        if (worldGuardManager != null) {
            return worldGuardManager.canBuild(p, loc);
        }
        if (residenceManager != null) {
            return ResidenceManager.canBuild(p, loc);
        }
        return true;
    }

    public static boolean canBuild(Player p, Block b) {
        Location loc = b.getLocation();
        if (worldGuardManager != null) {
            return worldGuardManager.canBuild(p, loc);
        }
        if (residenceManager != null) {
            return ResidenceManager.canBuild(p, loc);
        }
        return true;
    }

    public static double getBalance(OfflinePlayer p) {
        if (vaultManager != null) {
            return VaultManager.getBalance(p);
        }
        return 0.0;
    }

    public static void depositPlayer(OfflinePlayer p, double amt) {
        if (vaultManager != null) {
            VaultManager.deposit(p, amt);
        }
    }

    public static void withdrawPlayer(OfflinePlayer p, double amt) {
        if (vaultManager != null) {
            VaultManager.withdraw(p, amt);
        }
    }

    public static void sendTitleBar(Player p, String title, String lore) {
        if (titleAPIManager != null) {
            TitleAPIManager.sendTitle(p, title, lore);
        }
    }

    public static void sendActionBar(Player p, String message) {
        if (actionBarAPIManager != null) {
            ActionbarAPIManager.sendActionBar(p, message);
        }
    }

    public static ScoreboardManager getScoreboardManager() {
        return scoreboardManager;
    }

    public static VaultManager getVaultManager() {
        return vaultManager;
    }

    public static DynmapManager getDynmapManager() {
        return dynmapManager;
    }

    @Override
    public void onDisable() {
    }
}

