/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.main;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.generallib.serializetools.FileSerialize;
import org.generallib.serializetools.exceptions.FileSerializeException;
import org.kingdoms.main.Kingdoms;

public class LanguageSupport
extends FileSerialize {
    private Kingdoms plugin;
    private String lang;
    private Queue<Double> doub = new LinkedList<Double>();
    private Queue<Integer> integer = new LinkedList<Integer>();
    private Queue<String> string = new LinkedList<String>();
    private Queue<Boolean> bool = new LinkedList<Boolean>();

    private LanguageSupport(File dbPath, String name) throws FileSerializeException {
        super(dbPath, name);
    }

    LanguageSupport(Plugin plugin, String lang) throws FileSerializeException {
        this(new File(plugin.getDataFolder(), "lang"), String.valueOf(lang) + ".yml");
        Validate.notNull((Object)lang);
        this.plugin = (Kingdoms)plugin;
        this.lang = lang;
        this.fillIfEmpty();
    }

    private void fillIfEmpty() {
        int i = 0;
        Languages[] languagesArray = Languages.values();
        int n = languagesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Languages lang = languagesArray[n2];
            String str = lang.toString();
            if (this.load(str) == null) {
                try {
                    this.save(str, new ArrayList<String>(lang){
                        {
                            this.add(languages.getDefault());
                        }
                    });
                    Bukkit.getLogger().info("[Kingdoms] Added language setting " + str);
                }
                catch (FileSerializeException e) {
                    Bukkit.getLogger().info("[Kingdoms] Could not fill empty string " + str);
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        Bukkit.getLogger().info("[Kingdoms]: Loaded " + i + " language statements");
    }

    public String[] parseStrings(Languages lang) {
        ArrayList<String> str = new ArrayList<String>();
        str.addAll((List)this.load(lang.toString()));
        Validate.notNull(str);
        this.replaceVariables(str);
        int i = 0;
        while (i < str.size()) {
            str.set(i, (Object)((Object)lang) + " is null");
            ++i;
        }
        return str.toArray(new String[str.size()]);
    }

    public String parseFirstString(Languages lang) {
        ArrayList str = new ArrayList();
        str.addAll((List)this.load(lang.toString()));
        Validate.notNull(str);
        if (str.size() == 0) {
            return null;
        }
        if (str.size() > 1) {
            int i = 1;
            while (i < str.size()) {
                str.remove(i);
                ++i;
            }
        }
        this.replaceVariables(str);
        return str.get(0) == null ? (Object)((Object)lang) + " is null" : (String)str.get(0);
    }

    public String colorize(String msg) {
        String coloredMsg = "";
        int i = 0;
        while (i < msg.length()) {
            coloredMsg = msg.charAt(i) == '&' ? String.valueOf(coloredMsg) + '\u00a7' : String.valueOf(coloredMsg) + msg.charAt(i);
            ++i;
        }
        return coloredMsg;
    }

    private void replaceVariables(List strings) {
        int i = 0;
        while (i < strings.size()) {
            block30: {
                String str;
                block31: {
                    str = "";
                    str = !(strings.get(i) instanceof String) ? strings.get(i).toString() : (String)strings.get(i);
                    if (str == null) break block30;
                    if (!(str = this.colorize(str)).contains("${")) break block31;
                    int start = -1;
                    int end = -1;
                    while ((start = str.indexOf("${")) != -1 && (end = str.indexOf("}")) != -1) {
                        String varName;
                        String leftStr = str.substring(0, start);
                        String rightStr = str.substring(end + 1, str.length());
                        switch (varName = str.substring(start + 2, end)) {
                            case "double": {
                                str = String.valueOf(leftStr) + String.valueOf(this.doub.poll()) + rightStr;
                                break;
                            }
                            case "integer": {
                                str = String.valueOf(leftStr) + String.valueOf(this.integer.poll()) + rightStr;
                                break;
                            }
                            case "string": {
                                str = String.valueOf(leftStr) + String.valueOf(this.string.poll()) + rightStr;
                                break;
                            }
                            case "bool": {
                                str = String.valueOf(leftStr) + String.valueOf(this.bool.poll()) + rightStr;
                                break;
                            }
                            case "claimcost": {
                                str = String.valueOf(leftStr) + Kingdoms.config.claimcost + rightStr;
                                break;
                            }
                            case "itemsperrp": {
                                str = String.valueOf(leftStr) + Kingdoms.config.items_needed_for_one_resource_point + rightStr;
                                break;
                            }
                            case "invadecost": {
                                str = String.valueOf(leftStr) + Kingdoms.config.invadecost + rightStr;
                                break;
                            }
                            case "maxkingdomnamelength": {
                                str = String.valueOf(leftStr) + Kingdoms.config.kingdom_char_tag_limit + rightStr;
                                break;
                            }
                            default: {
                                str = String.valueOf(leftStr) + String.valueOf("[UnkownVar]") + rightStr;
                            }
                        }
                    }
                }
                strings.set(i, str);
            }
            ++i;
        }
        this.doub.clear();
        this.integer.clear();
        this.string.clear();
        this.bool.clear();
    }

    public void addDouble(double doub) {
        this.doub.add(doub);
    }

    public void addInteger(int integer) {
        this.integer.add(integer);
    }

    public void addString(String string) {
        Validate.notNull((Object)string);
        this.string.add(string);
    }

    public void addBoolean(boolean bool) {
        this.bool.add(bool);
    }

    public static enum Languages {
        Plugin_Display("&6[Kingdoms]"),
        Plugin_NotEnabled("Plugin is not enabled."),
        Plugin_SetEnableToTrue("Please set Enable option to true in your config.yml file."),
        Plugin_WillBeDisabled("This plugin will be disabled."),
        Plugin_OreRegeneratorNotFound("No OreRegenerator plugin found, disabling kingdom ore regeneration after land expiry"),
        Rank_King("\u265a"),
        Rank_Mods("\u2694"),
        Rank_All("\u265f"),
        Rank_King_Name("King"),
        Rank_Mods_Name("Mods"),
        Rank_All_Name("All"),
        Chat_Prefix_Members("&8[&a\u265f&8][&7%kingdom%&8]"),
        Chat_Prefix_Mods("&8[&1\u2694&8][&7%kingdom%&8]"),
        Chat_Prefix_Kings("&8[&c\u265a&8][&7%kingdom%&8]"),
        Chat_Allychat_Prefix("&d[%rank%] %player%: "),
        Chat_Kingdomchat_Prefix("&a[%rank%] %player%: "),
        Command_Info_PageTextHeader("&6Page %currpagenum%"),
        Command_Info_NextPageText("&6Do /k info &7%nextpagenum% &6to see the next page"),
        Command_Info_Page1Title("&aContents"),
        Command_Info_Page2Title("&aWhat is Kingdoms?"),
        Command_Info_Page2Content1("Kingdoms is a plugin similar to the popular Factions plugin, but with changes to the gameplay. It allows a player to create his own Kingdom, protect land with the kingdom, and invade other's land for items (and for fun). To see all commands, do /k."),
        Command_Info_Page3Title("&aStarting"),
        Command_Info_Page3Content1("First off, you would want to find a good place to build a base, a normal minecraft base. Once you find a nice spot, do /k create [kingdomname] to start your own kingdom. Then, do /k claim to claim the land you are standing on."),
        Command_Info_Page3Content2("Kingdoms claims chunks. Chunks are 16x255x16 groups of blocks in a minecraft world. So a chunk has the height of a world, and the width and breadth of 16 blocks."),
        Command_Info_Page3Content3("This chunk claimed by your kingdom can only be edited by you and your kingdom members, so this means non-members can't break, place or interact with the things in your land. Beware of tnt cannons and invasions though"),
        Command_Info_Page3Content4("You don't necessarily have to create your own kingdom. You can ask another kingdom mod or king to invite you to their kingdom, then you can join their kingdoms instead. "),
        Command_Info_Page3Content5("/k claim costs ${claimcost} resource points"),
        Command_Info_Page4Title("&aThe Nexus"),
        Command_Info_Page4Content1("Once you have claimed your land, do /k nexus to place your nexus block, which resembles a beacon."),
        Command_Info_Page4Content2("Nexuses can't be broken with your hand, and can be used to access upgrades, gain resource points, or buy turrets. The nexus is your kingdom's base of operations. When broken by enemies, the enemies can steal your resource points, and if the land your nexus is on is sucessfully invaded, the items stored in the nexus, and all your kingdom resource points will go to the invading kingdom. So ALWAYS protect your nexus land, and the nexus itself."),
        Command_Info_Page4Content3("How to get resourcepoints? First off, do /k tradable. In that list, is the list of items you can't trade for resource points, and the items that give more resourcepoints when traded. To trade resource points, right-click your nexus, and click the wheat. You will now see an empty GUI to place items in. Every ${itemsperrp} item(s) you place in the GUI, you earn 1 resource point. Close the GUI to confirm"),
        Command_Info_Page5Title("&aChampions and Invading"),
        Command_Info_Page5Content1("Now this is where the real difference between Kingdoms and Factions shows. You are able to invade others land (and vice versa) to claim their land to plunder their resources, build in that space, or just to vent your anger at a guy who deserves it."),
        Command_Info_Page5Content2("To invade someone's land, do /k invade while standing on it. By doing so, you summon their kingdom's champion. You will need to kill the champion in order to claim the land. If the champion kills you, you don't gain the land, and you die. The strength of a kingdom's champion depends on its upgrades."),
        Command_Info_Page5Content3("You can access champion upgrades through the nexus. It is recommended to upgrade Drag, Mock and Champion Speed first as they are the more effective upgrades for your champion. This does not mean that those are the only upgrades you need."),
        Command_Info_Page5Content4("If you happen to invade some other kingdom's nexus land, you will duel a stronger version of their kingom's champion. This nexus champion can summon nexus guards and has more health"),
        Command_Info_Page5Content5("Invasions cost ${invadecost} resource points each."),
        Command_Info_Page6Title("&aTurrets"),
        Command_Info_Page6Content1("Do you want an auto mob killer? Do you hate people walking into your base to mine your nexus? Then turrets are the best solution! Nothing says Stay Out like a lovely skull on a fence that shoots projectiles."),
        Command_Info_Page6Content2("Turrets can be purchased from the nexus, thought most are rather expensive. Most turrets must be placed on top of fences. Turrets will shoot at all mobs, non-allies and non-members."),
        Command_Info_Page6Content3("Mines are a one-time-use defense system to deter players from entering, and careless players to get killed. Or if you just want an invader to explode just before an invasion.  Mines can ONLY BE TRIGGERED BY NON-MEMBER AND NON-ALLY PLAYERS, so mobs don't activate them. If you plan to repeatedly replace mines, then they are in no means cheap, but if an enemy was to step ona mine, it would be a sad day for that guy due to the Mine's heavy attack."),
        Command_Info_Page7Title("&aPowercells"),
        Command_Info_Page7Content1("Don't you hate it when your enemies walk right up to your nexus to invade it? That can be solved with power cells."),
        Command_Info_Page7Content2("Power cells can be purchased from the nexus, and are placed similar to how nexuses are placed"),
        Command_Info_Page7Content3("Invaders can't invade a chunk next to a chunk with a power cell. So they need to invade the land with the power cell to proceed, making the invasion more costly and time-consuming. However, power cell land does not prevent invaders from invading other power cell land. So remember this before you buy a power cell for each land you have."),
        Command_Info_EndingText("This is the last page of /k info, you can report bugs at https://www.spigotmc.org/threads/kingdoms-battle-for-land-might-and-glory-25-off-until-next-monday-1-7-x-1-8-x-paid.90294/ and if you still have questions, feel free to ask server staff, or fellow players."),
        Command_Info_Page8Title("&aProtected Chests"),
        Command_Info_Page8Content1("Tired of players joining your kingdom...just to rob you blind and leave? Then this feature is for you! Protection signs allow your members to lock their chests! &bJust sneak, and place a sign on the chest you want to protect, write &c&l[Protected]&b on the first line of the sign. "),
        Command_Info_Page8Content2("Protected chests will become unprotected if the land they are on is unclaimed or invaded. Kings, by default, can open any protected chest in their kingdom."),
        Command_Help_Invalid_Page("%args% is an invalid page"),
        Command_Info_Page9Title("&aConquests"),
        Command_Info_Page9Content1("Visit this page to learn about Conquests"),
        Command_Info_Page9Content2("https://goo.gl/BOmwOj"),
        Command_Help_Help("Shows all commands"),
        Command_Help_Accept("Accept an invite from a kingdom"),
        Command_Help_Decline("Decline an invite from a kingdom"),
        Command_Help_Broadcast("Broadcast a message to kingdom members"),
        Command_Help_Create("Creates a kingdom"),
        Command_Help_Tradable("Shows what items you can or cannot trade for RP"),
        Command_Help_Sethome("Sets the home of your kingdom"),
        Command_Help_List("Displays the top ten richest kingdoms"),
        Command_Help_Markers("Toggles land markers"),
        Command_Help_Nexus("Changes a block into your kingdom's nexus block"),
        Command_Help_Info("Shows how to use Kingdoms"),
        Command_Help_Join("Joins a kingdom. Must be invited"),
        Command_Help_Leave("Leave your kingdom"),
        Command_Help_Claim("Claims a 16x16 patch of land for your Kingdom"),
        Command_Help_Chat("Sets your chat to kingdom, allies and public (k, a, p)"),
        Command_Help_Unclaim("Unclaims a patch of land from your kingdom. &d/k unclaim all &fto unclaim all lands"),
        Command_Help_Unclaimall("Unclaims All your land from your kingdom except your nexus land"),
        Command_Help_Invade("Challenges another kingdom's champion for a patch of their land. Stand on another kingdom's land before using"),
        Command_Help_King("Hands the leadership of your kingdom to another member"),
        Command_Help_Mod("Promotes a member in your kingdom into a Kingdom mod"),
        Command_Help_Demote("Demotes a mod in your kingdom to a normal Kingdom member"),
        Command_Help_Setlore("sets the lore of your Kingdom"),
        Command_Help_Kick("Kicks a player from your kingdom"),
        Command_Help_Invite("Invites a player to your kingdom so he can join"),
        Command_Help_Uninvite("Uninvites an invited player from your kingdom"),
        Command_Help_Home("Teleports to your kingdom home"),
        Command_Help_Ally("&b/k ally add &f- &7Marks another kingdom as an ally. Allies can't damage each other, and turrets don't shoot allies"),
        Command_Help_Ally_Description("/k ally to see more info"),
        Command_Help_Enemy_Description("/k enemy to see more info"),
        Command_Help_Neutral("&b/k ally|enemy break &f- &7Marks another kingdom as neutral"),
        Command_Help_Enemy("&b/k enemy add &f- &7Marks another kingdom as enemy, allowing you to damage them in their land"),
        Command_Help_Disband("Disbands your kingdom"),
        Command_Help_Donate("Donates the specified amount of resource points to another kingdom"),
        Command_Help_Rename("Renames your kingdom"),
        Command_Help_Deposit("Changes the specified amount into resourcepoints for your kingdom. Cannot be undone. You will gain 1 resourcepoint for ${moneyforonerp}"),
        Command_Help_Map("Shows a map of the surrounding territory"),
        Command_Help_Show("Shows information of the specified kingdom or player's kingdom"),
        Command_Help_Defend("Use to teleport to the last area where someone invaded the kingdom"),
        Command_Help_Admin_Toggle("Allows the ability to damage players regardless of kingdom, and break blocks in other kingdom land"),
        Command_Help_Admin_Disband("Forcefully disbands a kingdom."),
        Command_Help_Admin_Safezone("Claims the current position as a safezone"),
        Command_Help_Admin_Warzone("Claims the current position as a warzone"),
        Command_Help_Admin_Unclaim("Forcefully unclaims the current piece of land you are standing on. Can be used to unclaim safezones and warzones"),
        Command_Help_Admin_Show("Shows all information of the specified kingdom"),
        Command_Help_Admin_ExtraLandClaims("adds or subtracts extra land claims from the specified kingdom. To subtract, put a minus '-' in front of the amount."),
        Command_Help_Admin_Rp("adds or subtracts resourcepoints from the specified kingdom. To subtract, put a minus '-' in front of the amount. A kingdom's rp cannot go below 0"),
        Command_Help_Admin_Rp_For_All("adds or subtracts resourcepoints from the specified kingdom. To subtract, put a minus '-' in front of the amount. A kingdom's rp cannot go below 0"),
        Command_Help_Admin_RpforPlayer("adds or subtracts resourcepoints to all kingdoms. To subtract, put a minus '-' in front of the amount. A kingdom's  rp cannot go below 0"),
        Command_Help_Admin_SetallRp("Sets the rp of ALL server kingdoms to the specified amount"),
        Command_Help_Admin_MassWar("Starts a MassWar for the specified time"),
        Command_Help_Admin_ForcestopMasswar("Force stop an ongoing masswar event"),
        Command_Help_Admin_King("Make specified player king of specified kingdom"),
        Command_Help_Admin_Mod("Make specified player mod of specified kingdom"),
        command_Help_Admin_Join("Enforce specified player to join the specified kingdom"),
        Command_Help_Admin_ForceKick("Forcefully kicks a player from his current kingdom. Does not work on Kings."),
        Command_Help_Admin_Set_ResourcePlot("Sets a chunk as a Resource Plot, for players to occupy for resources at where you're standing"),
        Command_Help_Admin_Remove_ResourcePlot("Removes the ResourcePlot you are standing on"),
        Command_Help_Admin_Help("Shows admin commands"),
        Command_Help_Admin_SeeNexus("Opens the specified kingdom's nexus chest"),
        Command_Help_Admin_CreateConquestMap("Creates a new conquest map"),
        Command_Help_Admin_DeleteConquestMap("Deletes an existing conquest map"),
        Command_Help_Admin_Backup("Creates a backup of current Kingdoms files"),
        Command_Help_Admin_PacifistToggle("Toggles Pacifism for the selected kingdom"),
        Command_Help_Reload("Reloads Kingdom's config file and lang file"),
        Command_Usage_Accept("/k accept when you have a pending invite from another Kingdom to accept it"),
        Command_Usage_Claim("/k claim to claim the chunk you're standing on for your Kingdom"),
        Command_Usage_Broadcast("/k broad [message] | Sends a message to all Kingdom members"),
        Command_Usage_Create("/k create [name] | Create a kingdom with the specified name"),
        Command_Usage_Decline("/k decline when you have a pending invite from another Kingdom to decline it"),
        Command_Usage_Defend("/k defend to teleport to the area of your Kingdom getting invaded"),
        Command_Usage_Deposit("/k deposit [amount] | Donate the specified amount of money to your Kingdom for Resource Points | Cannot be undone."),
        Command_Accept_No_Invite_Error("&cNo pending invites to accept!"),
        Command_Accept_Kingdom_Full_Error("&cThe kingdom you are trying to join is full!"),
        Command_Accept_Success("&cSuccessfully joined &e%kingdom%!"),
        Command_Ally_No_Kingdom_Error("&cYou need to be in a kingdom to use that command!"),
        Command_Ally_Kingdom_Doesnt_Exist_Error("&cThe specified kingdom, %kingdom%, doesn't exist!"),
        Command_Ally_Kingdom_Already_Ally_Error("&cThe specified kingdom, %kingdom%, has already been marked as an ally!"),
        Command_Ally_Kingdom_Is_Enemy_Error("&c%kingdom% is your enemy! Do /k enemy break %kingdom% before trying to ally them"),
        Command_Ally_Success("&anow %kingdom% is now an ally!"),
        Command_Get_Ally("&aWe are now allies with %kingdom%"),
        Command_Ally_Break("&cAlliance ties with %kingdom% have been broken!"),
        Command_Ally_Get_Break("&cthe kingdom %kingdom% has betrayed your kingdom!"),
        Command_Ally_Kingdom_Not_Ally_Error("&c%kingdom% is not your ally!"),
        Command_Chat_Help_Kingdom("&a/k chat k  Switches to Kingdom chat"),
        Command_Chat_Help_Ally("&d/k chat a  Switches to Ally chat"),
        Command_Chat_Help_Public("&1/k chat p  Switches to Public chat"),
        Command_Claim_Land_Owned_Error("&cYour kingdom already owns this land"),
        Command_Claim_Land_Occupied_Error("This land is occupied by %kingdom%. Use /k invade to attack this land"),
        Command_Claim_Success("&aLand claimed. %cost% resourcepoints taken"),
        Command_Claim_FirstTime1("&aGreetings member of new kingdom %kingdom%!."),
        Command_Claim_Op("&bAdmin mode detected, claim is free"),
        Command_Claim_FirstTime2("&aWe presented one free claim to you! good luck!"),
        Command_Create_Already_In_Kingdom_Error("&cYou are already in %kingdom%. You must leave in order to create a kingdom"),
        Command_Create_Invalid_Name_Error("&cThe name you've entered is invalid!"),
        Command_Create_Name_Too_Long_Error("&cYour kingdom name can only be up to 12 characters long!"),
        Command_Create_Name_Exists("&cAnother kingdom with the name specified already exists!"),
        Command_Create_Success("&aKingdom created!"),
        Command_Create_Banned_Name("&cYou cannot name your kingdom safezone or warzone!"),
        Command_Decline_Success("&aDeclined invitation from %kingdom%"),
        Command_Disband_Success("&cYou have disbanded %kingdom%!"),
        Command_Disband_DoNotMove("&6Do not move! you are about to disband your kingdom."),
        Command_Disband_TypeAgain("&cDo you really want to remove your kingdom? &6type /k disband to confirm."),
        Command_Enemy_Kingdom_Already_Enemy("&cThe specified kingdom is already an enemy!"),
        Command_Enemy_Kingdom_Is_Ally("&c%kingdom% is your ally! Do /k ally break %kingdom% before trying to enemy them"),
        Command_Enemy_Success("&c%kingdom% is now an enemy!"),
        Command_Enemy_Kingdom_Not_Enemy("&c%kingdom% is not an enemy!"),
        Command_Enemy_Break_Success("&a%kingdom% is no longer an enemy!"),
        Command_Home_No_Home_Error("&cYour kingdom doesn't have a home set!"),
        Command_Home_Not_Own_Land("&cYour kingdom home was unclaimed!"),
        Command_Home_Wait("&cTeleport started! don't move, or you are going to cancel the teleport."),
        Command_Home_Success("&aTeleporting to kingdom home"),
        Command_Home_Failed("&cWarp to kingdom home cancelled"),
        Command_Invade_No_Occupant_Error("&cNobody owns this land! Do /k claim to claim it"),
        Command_Invade_Land_Ownded_Error("&cYour kingdom already owns this land!"),
        Command_Invade_Kingdom_Owner_Not_Enough_Online("&cAt least %number% members must be present online in their kingdom to be invaded!"),
        Command_Invade_SafeWarZone_Error("&cYou can't invade safezones and warzones!"),
        Command_Invade_Powercell_Present_Error("&cA nearby powercell is shielding this land from invasion! Invade the powercell land to destroy it first!"),
        Command_Invade_Commence("&6==Be prepared! The Champion is being summoned!=="),
        Command_Invade_Warning("&c&lThe land at ${string} got invaded! Do /k defend to teleport to the invaded location!"),
        Command_Invade_MassWar_Boost("&aMass War free invade!"),
        Command_Invade_Cannot_Ally("&cYou can't invade allies! Break the alliance before invading!"),
        Command_Invite_Too_Many_Members("&cMaximum member limit reached"),
        Command_Invite_Player_Not_Online_Error("&cThe specified player must be online!"),
        Command_Invite_Player_Is_In_Another_Kingdom_Error("&cThe specified player already has a kingdom!"),
        Command_Invite_Player_Has_Offer_Error("&cThe specified player already has another invite request! Try again later"),
        Command_Invite_Success("&a%player% has recieved the invite!"),
        Command_Invite_Text("&6%inviter% has invited you to %kingdom%!"),
        Command_Invite_Text2("&aDo /k accept to accept the invite"),
        Command_Invite_Text3("&cDo /k decline to reject the invite"),
        Command_Invite_Text4("&6This invitation will be automatically rejected in ${integer} seconds"),
        Command_Reload_Success("&aKingdoms config and language settings reloaded!"),
        Command_Kick_Cannot_Kick_Yourself("&cYou cannot kick yourself!"),
        Command_Kick_Member_Not_In_Kingdom("&cYou cannot kick player not in your kingdom!"),
        Command_Kick_Member_Not_Found("&cThe member you're trying to kick doesn't exist"),
        Command_Kick_Rank_Error("&cYou cannot kick someone with a higher rank than you!"),
        Command_Kick_Specified_Not_In("&cYou cannot kick someone who is not in your kingdom!"),
        Command_Kick_Message("&cYou have been kicked from the kingdom!"),
        Command_Kick_Broadcast("&c%kicker% kicked %victim% from the kingdom! :O"),
        Command_King_Member_Not_Found("&cThe member you're trying to king doesn't exist!"),
        Command_King_Kingdom_Not_Found("&cThe kingdom you're trying to change doesn't exist!"),
        Command_King_Member_Not_A_Member("&cSpecified player is not in this kingdom!"),
        Command_King_Member_Not_In_A_Kingdom("&cSpecified player is not in a kingdom!"),
        Command_King_Already_A_King("&cSpecified player is already a king!"),
        Command_Mod_Kingdom_Not_Found("&cThe kingdom you're trying to change doesn't exist!"),
        Command_Mod_Member_Not_A_Member("&cSpecified player is not in this kingdom!"),
        Command_Mod_Member_Not_In_A_Kingdom("&cSpecified player is not in a kingdom!"),
        Command_Mod_Already_A_Mod("&cSpecified player is already a mod!"),
        Command_Admin_Join_Member_Not_Found("&cThe member you're trying to king doesn't exist!"),
        Command_Admin_Join_Kingdom_Not_Found("&cThe kingdom you're trying to change doesn't exist!"),
        Command_Admin_Join_King_Warning("&cWARNING! this user was previously a king therefore can cause unexpected behavior to the previous kingdom [${string}]!"),
        Command_Admin_CreateConquestMap_Success("&aMap created successfully!"),
        Command_Admin_CreateConquestMap_Failure("&cYou cannot use the name of an existing conquest map! Existing Maps:"),
        Command_Admin_DeleteConquestMap_Success("&aMap deleted successfully! Remaining maps:"),
        Command_Admin_DeleteConquestMap_Failure("&cThe specified map does not exist! Existing maps:"),
        Command_King_Target_Is_Loading("&cThis player is loading. Please try again later."),
        Command_King_Success_Broadcast("&aThe new King of your kingdom is %player%"),
        Command_Leave_King_Error("&cKings cannot leave the kingdom! Make another member the king with /k king, or disband the kingdom with /k disband"),
        Command_Leave_Success("&cYou are no longer a member of %kingdom%"),
        Command_Leave_Broadcast("&c%player% has left the kingdom!"),
        Command_Top_Header("&6Top 10 Kingdoms"),
        Command_Markers_Enabled("&aLand Markers enabled"),
        Command_Markers_Disabled("&cLand Markers disabled"),
        Command_Mod_Member_Not_Found("&cThe member you're trying to mod doesn't exist!"),
        Command_Mod_Player_Not_In("&cThe player specified is not in your kingdom"),
        Command_Mod_Member_Already_Mod("&cThe player specified is already a mod"),
        Command_Mod_Member_Not_Mod("&cThe player specified is not a mod"),
        Command_Mod_Broadcast("%player% has been promoted to kingdom mod"),
        Command_Demote_Description("Set target player into normal kingdom member again."),
        Command_Demote_Usage1("/k demote <name> &f- &7set <name> into a normal kingdom member."),
        Command_Demote_Broadcast("%player% is no longer a kingdom mod"),
        Command_Nexus_Land_Not_Owned_Error("&cYou can only place the nexus in your own land!"),
        Command_Nexus_Setting_Activated("&6Right click a block in your land to place your nexus. Leaving your current land will cancel the placement"),
        Command_Sethome_Not_On_Land("&cYou can only set your home in your own land!"),
        Command_Sethome_Success("&aHome set at: %coords%"),
        Command_Setlore_Lore_Too_Long("&cThe lore you want is too long. Maximum: 30 characters"),
        Command_Setlore_Invalid_Word("&cThe lore contains an invalid word"),
        Command_Setlore_Success("&aKingdom lore has been set to &e%lore%"),
        Command_Show_Non_Existant("&cThe kingdom or player specified doesn't exist!"),
        Command_Show_Player_No_Kingdom("&cThe specified player has no kingdom!"),
        Command_Show_Kingdom_Loading("&cThe specified kingdom is loading. Try again later."),
        Command_Show_Members("Members"),
        Command_Show_King("King"),
        Command_Show_Land("Land"),
        Command_Show_MaxLandClaims("Max Land Claims"),
        Command_Show_Might("Might"),
        Command_Show_Home("Home"),
        Command_Show_Nexus("Nexus"),
        Command_Show_Allies("Allies"),
        Command_Show_Enemies("Enemies"),
        Command_Show_Shield("Shielded"),
        Command_Show_ResourcePoints("Resource Points"),
        Command_Map_AutoMapOn("&bAuto map enabled. Use /k map off to toggle automap"),
        Command_Map_AutoMapOff("&bAuto map disabled. Use /k map on to toggle automap"),
        Command_Tradable_Conversion_Ratio_Msg("&aConversion Ratio: 1 resourcepoint per %rpi% items"),
        Command_Tradable_Enabled_Items_Title("&a===Enabled Items==="),
        Command_Tradable_Disabled_Items_Title("&c===Disabled Items==="),
        Command_Tradable_Special_Case_Items_Title("&6===Special Items==="),
        Command_Tradable_Worth("Worth"),
        Command_Tradable_ItemsUnit("item(s)"),
        Command_Donate_Success("&aDonated %amount% to %kingdom%"),
        Command_Donate_Kingdom_Non_Existant("&cThe kingdom specified doesn't exist!"),
        Command_Donate_Must_Be_Number("&cAmount to donate must be a number!"),
        Command_Defend_Teleport_Used("&cThe current teleports have been used, or there is no land to defend from attack"),
        Command_Defend_Success("&c&lDefend your kingdom!"),
        Command_Admin_Toggle_True("&aAdmin mode: on"),
        Command_Admin_Toggle_False("&cAdmin mode: off"),
        Command_Admin_SafeWar_Claim("&cUse /k admin clear to forcefully remove the land you are in!"),
        Command_Admin_SafeZone_Success("&aSafezone created!"),
        Command_Admin_WarZone_Success("&aWarzone created!"),
        Command_Admin_Clear_Land_Empty("&cThe land is unoccupied!"),
        Command_Admin_Clear_Success("&aLand Cleared!"),
        Command_Admin_ExtraLandClaims_Not_Number("&cAmount of extra land claims must be a number!"),
        Command_Admin_ExtraLandClaims_Added_Success("&a%amount% extra land claims added to %kingdom%"),
        Command_Admin_ExtraLandClaims_Deducted_Success("&a%amount% extra land claims deducted from %kingdom%"),
        Command_Admin_ExtraLandClaims_Kingdom_Doesnt_Exist("&cThe specified kingdom doesn't exist!"),
        Command_Admin_Rp_Not_Number("&cAmount of resourcepoints must be a number!"),
        Command_Admin_Rp_Added_Success("&a%amount% resourcepoints added to %kingdom%"),
        Command_Admin_Rp_Deducted_Success("&a%amount% resourcepoints deducted from %kingdom%"),
        Command_Admin_Rp_Kingdom_Doesnt_Exist("&cThe specified kingdom doesn't exist!"),
        Command_Admin_Rpforplayer_Player_Has_No_Kingdom("&cThe specified player does not have a kingdom!"),
        Command_Admin_Disband_Success("&aThe specified kingdom %kingdom% has been disbanded."),
        Command_Admin_Disband_KingdomNoutFound("&cThe specified kingdom %kingdom% is not exist."),
        Command_Admin_SeeNexus_Kingdom_Not_Found("&cThe specified kingdom doesn't exist"),
        Command_Admin_Set_Resourceplot("Added resourceplot at %location%"),
        Command_Admin_Set_Resourceplot_Error("There is already a resourceplot at %location%"),
        Command_Admin_Remove_Resourceplot("Removed resourceplot at %location%"),
        Command_Admin_Remove_Resourceplot_Error("There is no resourceplot at %location%"),
        Command_Admin_ForceKick_Success("&a%player% was sucessfully kicked from %kingdom%"),
        Command_Admin_ForceKick_NoKingdom_Failed("&cThe player already has a kingdom!"),
        Command_Admin_ForceKick_IsKing_Failed("&cKingdom Kings cannot be kicked!"),
        Command_Admin_Home_Success("&aTeleporting"),
        Command_Admin_Home_Failed("&cThe specified kingdom does not have a home set!"),
        Command_Admin_Masswar_Success("&aMassWar has been activated for %time% minutes!"),
        Command_Admin_Masswar_Not_Number("&cThe specified time must be a number!"),
        Command_Admin_Masswar_Broadcast("&cMassWar has begun! Invading is now FREE for %time% minutes!"),
        Command_Admin_Masswar_End_Broadcast("&6MassWar has ended! Invading is no longer FREE now."),
        Command_Admin_PacifistToggle_True("&a%kingdom% has pacifism on!"),
        Command_Admin_PacifistToggle_False("&c%kingdom% has pacifism off!"),
        Command_Admin_PacifistToggle_Warning("&cPacifist is not enabled in config, and these changes may not be permanent."),
        Misc_Turret_Limit("&cYou can only place %number% %type% turrets in one land."),
        Misc_Resourceplot_Reward_Message("Your kingdom received %amount% from resourceplot %plot%"),
        Misc_Resourceplot_Reset_Broadcast("ALL RESOURCE PLOTS HAVE BEEN RESET!"),
        Misc_Resourceplot_Reset_Private_Notification("Your kingdom's resourceplot at %location% has been reset"),
        Misc_Economy_Amount_Insufficient_For_Trade("&cYou need at least $${moneyforonerp} to obtain 1 resource point for your kingdom!"),
        Misc_Economy_Trade_Successful("&bYou have traded &e$%amount% &bfor &e%traded% &bresource points."),
        Misc_Economy_Insufficient_Money("&cYou specified an amount higher than your balance!"),
        Misc_Economy_Trade_Leftover_Return("&bThe leftover &b$%leftover% &bwas left over from the trade, and will be return to you."),
        Misc_Enonomy_Not_Enabled("&cEconomy is disabled for kingdoms!"),
        Misc_Not_In_Kingdom("&cYou need to be in a kingdom to do that!"),
        Misc_Not_Enough_Permissions("&cYou don't have enough permissions!"),
        Misc_IllegalGamemode("&cThis function cannot be used in your current gamemode!"),
        Misc_Unknown_Command("&cUnknown Command"),
        Misc_Turret_No_Fence_Error("&cTurrets need a fence underneath to function!"),
        Misc_Anti_Claim_World("&cLand claiming is disabled in this world"),
        Misc_Members_Needed("&cYou can only claim %amount% land with %members% members"),
        Misc_Max_Land_Reached("&cMaximum land claims reached"),
        Misc_Must_Be_Connected("&cYour land must be connected to your other land!"),
        Misc_Not_Enough_Points("&cYou need %cost% resourcepoints!"),
        Misc_Invalid_Command("&cInvalid command, do /k for help"),
        Misc_Invalid_World("&cInvalid world. This command is disabled in this world."),
        Misc_Preparing_Info("&cPreparing your new player data..."),
        Misc_Preparing_Info_Finished("&aData loaded! Enjoy!"),
        Misc_Not_In_Land("&cYou can only do that in your land"),
        Misc_Confirmation_Cancel("&cConfirmation cancelled."),
        Misc_Previous_Request_Processing("&cYour command is still processing. If this problem persists, contact an administrator"),
        Misc_Kingdom_Creation_Loading("Kingdom creation started, please wait a moment..."),
        Misc_Kingdom_Creation_Success("You have successfully created a kingdom by the name of %kingdom%!"),
        Misc_Kingdom_Deleting("Kingdom is disbanding. Please wait a moment..."),
        Misc_Kingdom_Deleted("Kingdom has been disbanded"),
        Misc_Cannot_Attack_Own_Member("&cYou can't attack your own kingdom members!"),
        Misc_Cannot_Attack_Own_Ally("&cYou can't attack your own kingdom allies!"),
        Misc_Cannot_Trample_Soil("&bYour kingdom soil cannot be trampled"),
        Misc_Cannot_Trample_Other_Soil("&cYou cannot trample soil in %kingdom%'s land"),
        Misc_Nexus_Setting_Disabled("&cNexus Placing mode disabled!"),
        Misc_Nexus_Setting_Different_Land("&cYou moved into another piece of land!"),
        Misc_Nexus_Setting_Cannot_Replace("&cYou cannot replace this block!"),
        Misc_Nexus_Setting_Not_In_Land("&cThe land you're trying to place your nexus in is not owned by your kingdom"),
        Misc_Nexus_Setting_Success("&aNexus successfully placed!"),
        Misc_Cannot_Build_In_Unoccupied_Land("&cYou need to claim this land to build in it!"),
        Misc_Cannot_Break_In_Other_Land("&cYou cannot interact with, break or place blocks in another kingdom's land"),
        Misc_Regulator_Cannot_Build("&cYou cannot build in this land! Ask a higher ranked member to change regulator settings for this land."),
        Misc_Regulator_Cannot_Interact("&cYou cannot interact in this land! Ask a higher ranked member to change regulator settings for this land."),
        Misc_Cannot_Use_Other_Nexus("&cYou cannot use another kingdom's nexus"),
        Misc_Cannot_Use_Nexus_In_GMC("&cYou can't use the nexus while in creative mode!"),
        Misc_Cannot_Claim_In_WG("&cYou cannot claim in worldguard regions"),
        Misc_PrivateSigns_Wrong_Land_Error("You can only place chest protection signs on your own kingdom land!"),
        Misc_PrivateSigns_Created_Message("Successfully created Protection sign!"),
        Misc_PrivateSigns_Unregistered_Sign("Sign successfully removed."),
        Misc_PrivateSigns_Not_Owner_Error("You must be the owner of the chest to edit it!"),
        Misc_Private_Signs_Cannot_Open("This chest is sealed!"),
        Misc_PrivateSigns_No_Hopper_Tracks("You can't place hoppers or rails under protected chests!"),
        Misc_Kingdom_Creation_Broadcast("&4A new kingdom, %tag% has been founded by %player%"),
        Misc_Rp_For_Player_Broadcast("&a%player% has earned %amount% for his kingdom!"),
        Misc_Kingdom_Tag_Too_Long("&cYour kingdom tag cannot be longer than ${maxkingdomnamelength} characters long."),
        Misc_Kingdom_Rename_Broadcast("&c%player% has renamed %oldtag% to %newtag%"),
        Misc_Kingdom_Invite_Message("&a%player% has invite you to %kingdom%. Do /k join %kingdom% to accept the invitation"),
        Misc_Kingdom_Too_Many_Members("&cYou can only have %amount% members. Upgrade the max members upgrade in the nexus"),
        Misc_Rank_Too_Low("&cYour rank is too low to use this function! Only %rank% can use this function!"),
        Misc_Rank_Too_Low_NexusBuild("&cYour rank is too low to build in the nexus chunk! Only %rank% can do so!"),
        Misc_Worldguard_Claim_Off_Limits("&cYou cannot claim in server regions!"),
        Misc_Max_Level_Reached("&cMaximum level reached"),
        Misc_Inventory_Full("&cPlease have at least one empty slot in your inventory"),
        Misc_Invasion_Victory("We have conquered [%chunk%] from %kingdom%"),
        Misc_Invasion_Nexus_Victory("We have pillaged %rp% from %kingdom%"),
        Misc_Neutral_Toggled("&aNeutrality toggled."),
        Misc_Cannot_Neutral("&cKingdoms that have invaded before cannot become pacifist!"),
        Misc_Shield_Up_Invade_Warning("&cYour Kingdom shield is still up for %time% minutes! Use /k invade again in the next 5 seconds to discard shield and begin invasion."),
        Misc_Cannot_Invade_Shielded("&cYou cannot invade a shielded kingdom! Their shield expires in %time% minutes."),
        Misc_Neutral_Cannot_Invade("&cPacifist kingdoms cannot invade!"),
        Misc_Neutral_Cannot_Be_Invaded("&cYou can't invade pacifist kingdoms!"),
        Misc_Can_Only_Invade_During_Mass_War("&cYou can only invade during a mass war!"),
        Misc_Cannot_Be_Traded_For_Points("&c%item% cannot be traded for resource points! Do /k tradable to see what can be traded!"),
        Champion_Drag("&cThe champion dragged you back!"),
        Champion_Thor("&cThe champion smites you!"),
        Champion_Determination("&c&lChampion Determination: &a&l[&c&l%amt%&a&l/&c&l%max%&a&l]"),
        Champion_Own_Kingdom("&cYou can't attack your own kingdom's champion"),
        Champion_Command_Block("&cYou can't use commands during the champion fight!"),
        Champion_Mock("&cYou can't build within %mock% blocks of the champion!"),
        Champion_DeathDuel("&cYou only deal half damage to the champion"),
        Soldier_Name("&cKingdom Guard"),
        Map_Your_Kingdom("Your Kingdom"),
        Map_Unidentified("Unidentified Kingdom"),
        Map_Enemies("Enemy Kingdoms"),
        Map_Unoccupied("Unoccupied Land"),
        Map_Allies("Allied Kingdoms"),
        Map_You("You"),
        Map_NexusChunk("Nexus Chunk"),
        Map_Powercell("PowerCell Chunk"),
        Map_Outpost("Outpost Chunk"),
        Structures_Outpost("&bOutpost"),
        Structures_Outpost_Desc("&aThe Outpost allows direct access to your nexus, and unlocks more structures, turrets and upgrades Outposts can produce exp bottles from resource points"),
        Structures_Powercell("&bPowercell"),
        Structures_Powercell_Desc("&aChunks next to the chunk with a power cell cannot be invaded without invading the power cell first. Does not work on other power cell land"),
        Structures_Extractor("&bExtractor"),
        Structures_Extractor_Desc("&aExtractors are special structures that produce resource points every set time. Resource points must be manually collected from extractor before production can continue."),
        Structures_WarpPad("&bWarp Pad"),
        Structures_WarpPad_Desc("&aWarp Pads allow your members to teleport to your Kingdom's outposts and nexus."),
        Structures_Nexus("&bNexus"),
        Structures_Regulator("&bRegulator"),
        Structures_Regulator_Desc("&aRegulators can allow ranked players to change who can build, who can interact in each chunk of land, if monsters can spawn, if animals can spawn, and other similar functions in each chunk of land"),
        Structures_Placement_Instructions("&cOnly one structure is allowed per land."),
        Guis_Enabled("Enabled: %enabled%"),
        Guis_NextPage("&6Next Page"),
        Guis_PreviousPage("&6Previous Page"),
        Guis_Max("Max Level: "),
        Guis_Cost_Text("&cCost: %cost% resource points"),
        Guis_TurretUpgrades_Title("&bTurret Upgrades"),
        Guis_TurretUpgrades_Lore("&aResearch turret upgrades here"),
        Guis_ResourcePoints_Title("&bResource Points"),
        Guis_ResourcePoints_Desc("&aYour kingdom currently has"),
        Guis_ResourcePoints_Count("&e%amount% &aresource points"),
        Guis_Back_Btn("&4Return to main menu"),
        Guis_ResourcePointsConverter("Convert items to resource points"),
        Guis_ResourcePointsConverter_Lore1("1 resourcepoint per ${itemsperrp} items"),
        Guis_Logs_Title("&bBattle Logs"),
        Guis_Logs_Description("&aClick to view battle logs"),
        Guis_Log_Title("&bBattle Log"),
        Guis_Log_Victory("&aVictory"),
        Guis_Log_Defeat("&cDefeat"),
        Guis_Log_Invader("Invader: "),
        Guis_Log_Defending("Defending Kingdom: "),
        Guis_Log_Land("&bAt Chunk: "),
        Guis_TurretUpgrades_SimplifiedModel_Title("&bSimplified Model"),
        Guis_TurretUpgrades_SimplifiedModel_Lore("&aArrow turrets will be simplified, and will cost less"),
        Guis_TurretUpgrades_SimplifiedModel_Changes("&6- Arrow Turret Cost reduced by 30%"),
        Guis_TurretUpgrades_Flurry_Title("&bFlurry"),
        Guis_TurretUpgrades_Flurry_Lore("&aFlame turrets will unleash a barrage of low damage projectiles which set fire to targets"),
        Guis_TurretUpgrades_Flurry_Changes("&6- Flurry for Flame Turrets"),
        Guis_TurretUpgrades_ConcentratedBlast_Title("&bConcentrated Blast"),
        Guis_TurretUpgrades_ConcentratedBlast_Lore("&aPressure Mines will be more densely packed, increasing damage dealt"),
        Guis_TurretUpgrades_ConcentratedBlast_Changes("&6- Pressure Mine damage increased by 50%"),
        Guis_TurretUpgrades_VirulentPlague_Title("&bVirulent Plague"),
        Guis_TurretUpgrades_VirulentPlague_Lore("&aChemical Mines will now pack a more potent brew of poison."),
        Guis_TurretUpgrades_VirulentPlague_Changes("&6- Chemical Mine poison timer increased by 5 seconds"),
        Guis_TurretUpgrades_ImprovedHeal_Title("&bImproved Heal"),
        Guis_TurretUpgrades_ImprovedHeal_Lore("&aHealing turrets will release a cloud of potions, giving an extra heal that lasts over a short period of time"),
        Guis_TurretUpgrades_ImprovedHeal_Changes("&6- Healing Turrets will give a burst of regeneration after healing"),
        Guis_TurretUpgrades_Voodoo_Title("&bVoodoo"),
        Guis_TurretUpgrades_Voodoo_Lore("&aPsionic turrets will rip into its target's mind, temporarily gaining control and rooting its target"),
        Guis_TurretUpgrades_Voodoo_Changes("&6- Psionic Turrets will apply a heavy slow to its target for 2 seconds"),
        Guis_TurretUpgrades_FinalService_Title("&bFinal Service"),
        Guis_TurretUpgrades_FinalService_Lore("&aSoldiers spawned with soldier turrets will smite their target upon death"),
        Guis_TurretUpgrades_FinalService_Changes("&6- Soldiers spawned with soldier turrets will cause damage upon dying"),
        Guis_TurretUpgrades_Hellstorm_Title("&bHellstorm"),
        Guis_TurretUpgrades_Hellstorm_Lore("&aHellfire turrets will have an improved launcher, increasing attack speed"),
        Guis_TurretUpgrades_Hellstorm_Changes("&6- Increase Hellfire turret attack speed by 50%"),
        Guis_TurretUpgrades_UnrelentingGaze_Title("&bUnrelenting Gaze"),
        Guis_TurretUpgrades_UnrelentingGaze_Lore("&aHeatbeam turrets will release small bursts of extreme heat, increasing damage dealt."),
        Guis_TurretUpgrades_UnrelentingGaze_Changes("&6- Heatbeam turrets will deal 3 extra damage"),
        Guis_Member_Manager_Title("&bMembers"),
        Guis_Member_Lore("&bMember"),
        Guis_Member_NeverDonated("&cNever Donated"),
        Guis_Member_LastTimeDonated("&aLast Donation Time: &c%lasttime%"),
        Guis_Member_LastTimeDonatedAmt("&aLast Donation Amount: &c%amt%"),
        Guis_Member_TotalDonated("&aTotal Donations: %amt%"),
        Guis_PrivateSign_Manager_CanOpen("This user can open your protected chest"),
        Guis_PrivateSign_Manager_CannotOpen("This user cannot open your protected chest"),
        Guis_DamageReduction_Title("&bDamage Reduction"),
        Guis_DamageReduction_Description("Each upgrade reduces damage taken by another 1%"),
        Guis_DamageReduction_CurrLevel("Current Damage Reduction: "),
        Guis_Regeneration_Title("&bRegeneration Boost"),
        Guis_Regeneration_Description("&aWhile in your own land, boost your health regeneration by 5% more."),
        Guis_Regeneration_CurrLevel("Current Regeneration Boost: "),
        Guis_DamageBoost_Title("&bDamage Boost"),
        Guis_DamageBoost_Description("Each upgrade increases your melee damage by 1%"),
        Guis_DamageBoost_CurrLevel("Current Damage Boost: "),
        Guis_ArrowDamage_Title("&bArrow Damage"),
        Guis_ArrowDamage_Description("Each upgrade increases your bow damage by 1%"),
        Guis_ArrowDamage_CurrLevel("Current Arrow Damage: "),
        Guis_MaxMembers_Title("&bMax Members"),
        Guis_MaxMembers_Description("Each upgrade increases max member count by 1"),
        Guis_MaxMembers_CurrMaxMem("Current Member Max: "),
        Guis_MaxMembers_CurrLevel("Current Upgrade level: "),
        Guis_Research_Title("&bResearch"),
        Guis_Research_Description("Access Kingdom Research"),
        Guis_KingdomChestSize_Title("&bIncrease Kingdom Chest Size"),
        Guis_KingdomChestSize_Description("Increases the size of Nexus Chest by 9 slots per upgrade"),
        Guis_KingdomChestSize_CurrLevel("Current Nexus Chest Size: "),
        Guis_Nexus_RP_Trade_Insufficient_Itemcount("You need %amount% more item(s) to make this trade!"),
        Guis_Nexus_RP_Trade_Overflowing_Itemcount("%amount% item(s) are being returned"),
        Guis_Nexus_ChampionUpgrades_Title("&bChampion Upgrades"),
        Guis_Nexus_ChampionUpgrades_Desc("Click to open Champion Upgrades. Improve your defenses by upgrading your kingdom's champion!"),
        Guis_Nexus_Structures_Title("&bStructure Shop"),
        Guis_Nexus_Structures_Desc("Click to open Structures shop. Structures have different functions"),
        Guis_Nexus_Turrets_Title("&bTurrets Shop"),
        Guis_Nexus_Turrets_Desc("Click to open turrets shop. Build turrets with resource points"),
        Guis_Nexus_Conquests_Title("&bConquests"),
        Guis_Nexus_Conquests_Desc("Click to conquer faraway lands and earn rewards!"),
        Guis_Nexus_MiscUpgrades_Title("&bExtra Upgrades"),
        Guis_Nexus_MiscUpgrades_Desc("Click to open Miscellaneous upgrades"),
        Guis_Nexus_Permissions_Title("&bPermissions"),
        Guis_Nexus_Permissions_Desc("Click to manage who can do what"),
        Guis_Nexus_Members_Title("&bMembers"),
        Guis_Nexus_Members_Desc("Click to monitor donation status"),
        Guis_Nexus_MassWarStatus_Title("&bMass War Status"),
        Guis_Nexus_MassWarStatus_On("&bMass war is &aON"),
        Guis_Nexus_MassWarStatus_Off("&bMass war is &cOFF"),
        Guis_Nexus_MassWarStatus_Desc1("&bDuring Mass war"),
        Guis_Nexus_MassWarStatus_Desc2("&e- Invade for free during the period"),
        Guis_Nexus_MassWarStatus_Desc3("&cTime Left: %time%"),
        Guis_Nexus_KingdomChest_Title("&bNexus Chest"),
        Guis_Nexus_KingdomChest_Desc("Click to open Nexus chest. Store items in the nexus chest, that can only be lost if enemies invade your nexus land."),
        Guis_Nexus_Neutral_Title("&bClick to toggle pacifism"),
        Guis_Nexus_Neutral_Desc("You can't invade other kingdoms, and other kingdoms can't invade you while you're pacifist. Once you invade, your kingdom cannot become pacifist again"),
        Guis_Nexus_Neutral_Status("&aEnabled: %status%"),
        Guis_Nexus_Low_Rank_Error("&cOnly Kings and Mods can open special upgrade menus!"),
        Conquests_No_Conquest_Running("&cThere is no conquest currently running!"),
        Conquests_Land_Is_UnderSupplied("&cThere is not enough resourcepoints to supply the land at %land%!"),
        Conquests_Land_Is_Encircled("&cThe land at %land% is encircled, and cannot be resupplied!"),
        Conquests_Kingdom_Conquered_Land("The Kingdom has conquered land at %land%!"),
        Conquests_Kingdom_Defeat("The Kingdom has failed the attack on %land%"),
        Conquests_Kingdom_No_Commands("You cannot use any commands in the conquest battle! If you believe this is a mistake, please relog"),
        Conquests_Kingdom_Attacking_Land("Your Kingdom is attacking the land at %land%! Do /k joinconquest to join in the attack!"),
        Conquests_Kingdom_Joined_Map("The Kingdom has started the %map% campaign!"),
        Guis_ConquestMap_Click_A_Land("&eClick one of the buttons on the right to display information, and access upgrades"),
        Guis_ConquestMap_Owned_By("&eLand held by:"),
        Guis_ConquestMap_Attack("&c[&4%cost% RP&c] Attack"),
        Guis_ConquestMap_Resupply("&aResupply land for %cost% RP"),
        Guis_ConquestMap_Buy("&aClick to buy for %cost% RP. This structure will use %upkeep% RP every hour."),
        Guis_ConquestMap_Upgrade("&aClick to upgrade for %cost% RP."),
        Guis_ConquestMap_Sell("&cClick to sell ALL defenses for &a%amount% &cRP"),
        Guis_ConquestMap_Supplies("Supply Level: %amount%/%max%"),
        Guis_ConquestMap_Upkeep("This land's defenses use %upkeep% RP per hour"),
        Guis_ConquestMap_Encircled("&cEncircled. Upkeep will be applied to supply instead. Defenses will malfunction when Supply goes below 50%, and stop working when supplies reach 0"),
        Guis_ConquestMap_Wall("&eWall Level:"),
        Guis_ConquestMap_Turret("&eTurret %number% status"),
        Guis_ConquestMap_Turret_Status_Online("&a[Active] Lvl %level%"),
        Guis_ConquestMap_Turret_Status_No_Supplies("&c[Inactive] Turret has not enough supplies"),
        Guis_ConquestMap_Turret_Status_Offline("&cInactive"),
        Guis_ConquestMap_Spawner_Status_Online("&a[Active] Lvl %level%"),
        Guis_ConquestMap_Spawner_Status_No_Supplies("&c[Inactive] Spawner has not enough supplies"),
        Guis_ConquestMap_Spawner_Status_Offline("&cInactive"),
        Guis_ConquestMap_Spawner("&eSpawner Level:"),
        Guis_ConquestMap_ButtonLore("&bConquest Land"),
        Guis_ConquestMap_Claim_Capital("&eClick to claim this Capital, and begin conquesting in this area!"),
        Guis_ConquestMap_Cannot_Attack_Own_Land("&cYou cannot attack your own land!"),
        Guis_ConquestMap_Attack_Area("&cClick to attack this land. You will be teleported to lay siege to this area. Explosives are recommended."),
        Guis_ConquestMap_On_Cooldown("&cYour Kingdom is not ready to attack again! Cooldown:"),
        Guis_ConquestMap_Attack_Out_Of_Range("&cYou can only attack land close to your own!"),
        Guis_ConquestMap_Attack_Encircled("&cYou can't launch attacks from encircled land"),
        Guis_ConquestMap_Attack_Already_Ongoing("&cAn attack is already ongoing on this land!"),
        Guis_ConquestMap_Claim_Land("&eClick to claim this land."),
        Guis_Conquests_ButtonLore("&bConquest Map"),
        Guis_Conquests_Kingdom_Conquered_Map("&aYour Kingdom has conquered this entire Conquest Map!"),
        Guis_Conquests_Kingdom_Is_In_Map("&cYour Kingdom is competing for this Conquest Map"),
        Guis_Conquests_Kingdom_Is_Not_In_Full_Map("&eYour Kingdom is not inside this Map, and this Map is full"),
        Guis_Conquests_Kingdom_Can_Join_Map("&eYour Kingdom is not inside this Map, but can join"),
        Guis_Conquests_Map_Income_Yield("This map yields %amount% RP per hour for your kingdom"),
        Guis_ChampionUpgrades_Weapon_Title("&bChampion Weapon"),
        Guis_ChampionUpgrades_Weapon_Desc("Provides your champion with a better weapon each upgrade. Max level is 10"),
        Guis_ChampionUpgrades_Health_Title("&bChampion Health"),
        Guis_ChampionUpgrades_CurrHealth("&5Current Health: %hp%"),
        Guis_ChampionUpgrades_Health_Desc("Increases Champion Health by 2"),
        Guis_ChampionUpgrades_HealthII_Title("&bChampion Health II"),
        Guis_ChampionUpgrades_HealthII_Desc("Increases Champion Health by 50"),
        Guis_ChampionUpgrades_Determination_Title("&bDetermination"),
        Guis_ChampionUpgrades_CurrDetermination("&5Current Determination: %determination%"),
        Guis_ChampionUpgrades_Determination_Desc("Increases Determination by 2. Champion Determination will act as a shield that will absorb damage. Armor does not affect this shield."),
        Guis_ChampionUpgrades_DeterminationII_Title("&bDetermination II"),
        Guis_ChampionUpgrades_DeterminationII_Desc("Increases Determination by 50"),
        Guis_ChampionUpgrades_Resistance_Title("&bResistance"),
        Guis_ChampionUpgrades_Resistance_Desc("Each upgrade adds 20% chance that the champion won't be knocked back by an attack. Max is 100%"),
        Guis_ChampionUpgrades_Speed_Title("&bChampion Speed"),
        Guis_ChampionUpgrades_Speed_Desc("Increases Champion Speed. Max: 5"),
        Guis_ChampionUpgrades_Drag_Title("&bDrag"),
        Guis_ChampionUpgrades_Drag_Desc("If the invading player is more than 7 blocks away from the champion, the champion will teleport the player to the champion's location"),
        Guis_ChampionUpgrades_Mock_Title("&bMock"),
        Guis_ChampionUpgrades_Mock_Desc("Each upgrade increases the radius in which invading players can't build while near the champion"),
        Guis_ChampionUpgrades_DeathDuel_Title("&bDeath Duel"),
        Guis_ChampionUpgrades_DeathDuel_Desc("All players except the invader will deal 50% less damage to the champion. The champion will also deal double damage to all players except the invader"),
        Guis_ChampionUpgrades_Thor_Title("&bThor"),
        Guis_ChampionUpgrades_Thor_Desc("Every 3 seconds, strike lightning down at the invading player and all nearby non-allied players, dealing damage, and knocking the player back"),
        Guis_ChampionUpgrades_DamageCap_Title("&bDamage Cap"),
        Guis_ChampionUpgrades_DamageCap_Desc("Your champion can only receive up to 15 damage at any attack."),
        Guis_ChampionUpgrades_Plow_Title("&bPlow"),
        Guis_ChampionUpgrades_Plow_Desc("Your champion will try to clear lava and webs"),
        Guis_ChampionUpgrades_Strength_Title("&bStrength"),
        Guis_ChampionUpgrades_Strength_Desc("Every attack, there will be a chance to knock the player into the sky. Each upgrade increases this chance by 10%"),
        Guis_ChampionUpgrades_Armor_Title("&bArmor"),
        Guis_ChampionUpgrades_Armor_Desc("Each upgrade adds a level of protection in the champion's chestplate"),
        Guis_ChampionUpgrades_Reinforcements_Title("&bReinforcements"),
        Guis_ChampionUpgrades_Reinforcements_Desc("Each upgrade allows only the &c&lNexus Champion &ato spawn an additonal nexus guard. Maximum level: 2"),
        Guis_ChampionUpgrades_Mimic_Title("&bMimic"),
        Guis_ChampionUpgrades_Mimic_Desc("The champion gains the invader's helmet, leggings and boots"),
        Guis_ChampionUpgrades_Focus_Title("&bFocus"),
        Guis_ChampionUpgrades_Focus_Desc("Players hit by the champion (including Thor) will have 1 second removed from all their active potion effects"),
        Guis_ChampionUpgrades_Aqua_Title("&bAqua"),
        Guis_ChampionUpgrades_Aqua_Desc("The champion gets depth strider boots"),
        Guis_BoostShop_Inventory_Title("&bBoosts Shop"),
        Guis_BoostShop_CombatBoost_Title("&bCombat Boost"),
        Guis_BoostShop_CombatBoost_Desc("For 60 minutes, deal 30% more damage, and prevent durability loss for swords"),
        Guis_BoostShop_Sentinel_Title("&bSentinel"),
        Guis_BoostShop_Sentinel_Desc("For 60 minutes, a sentinel will be unleashed upon anyone who tries to invade your land"),
        Guis_BoostShop_Boost_Activated_Error("&cThis boost is already active! Remaining time: %time% minutes"),
        Guis_BoostShop_CombatBoost_Activation_Message("&a&lCombat Boost has been activated for 60 minutes! Decimate our enemies!"),
        Guis_BoostShop_Sentinel_Activation_Message("&a&lSentinel has been activated for 60 minutes! May our sentinel tear our foes apart!"),
        Guis_Extractor_Collect("&aCollect %amount% RP"),
        Guis_Extractor_TimeToNextCollection("&c%time% more minutes before next collection"),
        Guis_Extractor_Refresh_Title("&bRefresh"),
        Guis_Extractor_Refresh_Desc("&aClick to refresh timings displayed here"),
        Guis_Regulator_WhoCanBuild_Title("&bClick to manage who can build here"),
        Guis_Regulator_CanBuild_Title("&aCan build in this land"),
        Guis_Regulator_CannotBuild_Title("&cCannot build in this land"),
        Guis_Regulator_CanInteract_Title("&aCan interact in this land"),
        Guis_Regulator_CannotInteract_Title("&cCannot interact in this land"),
        Guis_Regulator_WhoCanInteract_Title("&bClick to manage who can interact here"),
        Guis_Regulator_CanMonstersSpawn_Title("&bMonster spawning in this land"),
        Guis_Regulator_CanAnimalsSpawn_Title("&bAnimal spawning in this land"),
        Guis_WarpPad_Click_To_Tp("&aClick to teleport to the location above"),
        Guis_WarpPad_You_Are_Here("&cYou are here"),
        Extractor_Collection_Announcement("&a%amount% resourcepoints have been collected from an Extractor"),
        Guis_Outpost_Buy1XpPotion_Title("&bBuy 1 xp bottle"),
        Guis_Outpost_Buy1XpPotion_Desc("&aBuy 1 xp bottle for %cost% resourcepoints."),
        Guis_Outpost_Buy64XpPotion_Title("&bBuy 64 xp bottles"),
        Guis_Outpost_Buy64XpPotion_Desc("&aBuy 64 xp bottle for %cost% resourcepoints."),
        Guis_Outpost_Rename_Land_Title("&bRename current land name"),
        Guis_Outpost_Rename_Land_Desc("&aCurrent name: %name%"),
        Guis_Outpost_Rename_Land_Message("&bType the land's desired name in chat"),
        Guis_Outpost_Rename_Land_Successful("&aRenamed!"),
        Guis_Outpost_Nexus_Unavailable("&cYour nexus isn't placed, and this menu cannot be accessed!"),
        Guis_Outpost_OpenNexus_Title("&bOpen Nexus Menu"),
        Guis_Misc_AntiCreeper_Title("&bAnti-Creeper"),
        Guis_Misc_AntiCreeper_Desc("If a creeper explodes in your land, it will do no block damage or damage your players"),
        Guis_Misc_AntiTrample_Title("&bAnti-Trample"),
        Guis_Misc_AntiTrample_Desc("Your soil cannot be trampled by players"),
        Guis_Misc_NexusGuard_Title("&bNexus Guard"),
        Guis_Misc_NexusGuard_Desc("When someone mines your nexus, a zombie with light armor and your champion's weapon will spawn."),
        Guis_Misc_Glory_Title("&bGlory"),
        Guis_Misc_Glory_Desc("Killing non-players on your land yields x3 xp"),
        Guis_Misc_BombShards_Title("&bBomb Expertise"),
        Guis_Misc_BombShards_Desc("TNT can no longer damage your land, and tnt explosions in your land would cause 5 damage to nearby non-allies and non-members."),
        Guis_Misc_PsionicCore_Title("&bPsionic Core"),
        Guis_Misc_PsionicCore_Desc("Champions and nexus guards spawned on powercell land will have a power surge, starting with Strength I for 10 seconds"),
        Guis_privateSignGUI_PrivateSign("&dPrivateSign"),
        Guis_privateSignGUI_canOpenChest("&aThis player can access this protected chest."),
        Guis_privateSignGUI_cannotOpenChest("&cThis player cannot access this protected chest."),
        Guis_Permissions_RankAll("&2Who can use this: All Members"),
        Guis_Permissions_RankMod("&9Who can use this: Only Mods and Kings"),
        Guis_Permissions_RankKing("&4Who can use this: Only King"),
        Guis_Permissions_Click_To_Change("&aClick to change"),
        Guis_Permissions_Title_Nexus("&b/k nexus"),
        Guis_Permissions_Desc_Nexus("&aManage who can use /k nexus"),
        Guis_Permissions_Title_Claim("&b/k claim"),
        Guis_Permissions_Desc_Claim("&aManage who can claim land"),
        Guis_Permissions_Title_Unclaim("&b/k unclaim"),
        Guis_Permissions_Desc_Unclaim("&aManage who can unclaim land"),
        Guis_Permissions_Title_Invade("&b/k invade"),
        Guis_Permissions_Desc_Invade("&bManage who can use /k invade"),
        Guis_Permissions_Title_AllyFunc("&bAlliance Functions"),
        Guis_Permissions_Desc_AllyFunc("&aManage who can use /k ally,/k enemy and /k neutral"),
        Guis_Permissions_Title_Turret("&bTurrets"),
        Guis_Permissions_Desc_Turrets("&aManage who can break turrets"),
        Guis_Permissions_Title_Sethome("&b/k sethome"),
        Guis_Permissions_Desc_Sethome("&aManage who can use /k sethome"),
        Guis_Permissions_Title_Nexuschest("&bNexus Chest"),
        Guis_Permissions_Desc_Nexuschest("&aManage who can open Nexus Chest"),
        Guis_Permissions_Title_Protectedchestbypass("&bProtected Chest Bypass"),
        Guis_Permissions_Desc_Protectedchestbypass("&aManage who can bypass [protected] signs"),
        Guis_Permissions_Title_Invite("&b/k invite"),
        Guis_Permissions_Desc_Invite("&aManage who can use /k invite"),
        Guis_Permissions_Title_Broadcast("&b/k broad"),
        Guis_Permissions_Desc_Broadcast("&aManage who can use /k broad"),
        Guis_Permissions_Title_Donate("&bConverting to resourcepoints"),
        Guis_Permissions_Desc_Donate("&aManage who can convert items to RP"),
        Guis_Permissions_Title_Structures("&bStructures"),
        Guis_Permissions_Desc_Structures("&aManage who can break structures"),
        Guis_Permissions_Title_Nexusbuild("&bBuild in Nexus Land"),
        Guis_Permissions_Title_UseKHome("&b/k home"),
        Guis_Permissions_Desc_UseKHome("&aManage who can use /k home"),
        Guis_Permissions_Title_OverrideRegulator("&bOverride Regulator"),
        Guis_Permissions_Desc_OverrideRegulator("&aManage who can use Regulators, and override regulator settings"),
        Guis_Permissions_Desc_Nexusbuild("&aManage who can build in the Nexus Land"),
        Nexus_Mining_EarnedRP("&aYour kingdom earned ${integer} rp for mining nexus!"),
        Nexus_Mining_isAlliance("&aYou cannot steal rp from your alliance!"),
        Nexus_Mining_isOwn("&cYou can't mine your own nexus!"),
        Nexus_GUI_Returned_Resources("&6${integer} &cresources are returned."),
        Nexus_GUI_Require_ResourcePerPoint("&cat least &6${integer} &cresources are needed for one rp!"),
        Nexus_GUI_Donated_RP("&a${integer} rp is added to your kingdom!"),
        Command_Unclaim_Lostmight("&6Your Kingdom lost ${integer} Might"),
        Command_Unclaim_All_DoNotMove("&6Do not move! your unclaim all request will be canceled if you move."),
        Command_Unclaim_All_TypeAgain("&cDo you really want to remove all lands? &6type /k unclaim all to confirm."),
        Command_Unclaim_All_LostLandTotal("&6Your Kingdom unclaimed total ${integer} lands!"),
        Command_Unclaim_Success("&aSuccessfully unclaimed the land!"),
        Command_Unclaim_All_Usage("&d/k unclaim all &7- &finitiate to uncalim all kingdom lands."),
        Command_Unclaim_Usage("&d/k unclaim &7- &funclaim the the land where you are standing."),
        LandManager_MovedWhiledRemoveAll("&c/k remove all cancelled."),
        PChest_AlreadyProtected("&cThis chest is already protected."),
        PChest_NotYourKingdomChest("&cThis chest is property of [${string}]."),
        Kingdom_Command_Denied_Other("&cThis command is cannot be used in others' kingdom."),
        Kingdom_Command_Denied_Enemy("&cThis command is cannot be used in kingdom who against you."),
        EventManager_Masswar_NotOn("&cNot On."),
        Guis_Misc_Enabled("&aEnabled"),
        Guis_Misc_Disabled("&cDisabled"),
        Turrets_ArrowTurret_Desc("&aGeneral-purpose, low-cost turret"),
        Turrets_FlameTurret_Desc("&aFast-firing turret that sets targets on fire"),
        Turrets_PsionicTotem_Desc("&aPowerful turret that slows and ignores the armor of targets. Cannot damage players lower than 4 hearts. Can attack through walls"),
        Turrets_HellfireTurret_Desc("&aArea-control turret that fires very rapidly, and deals higher damage"),
        Turrets_HeatbeamTurret_Desc("&aStrong turret that can negate some armor. Attacks hit all enemies in its path"),
        Turrets_PressureMine_Desc("&aSingle use mine that explodes when a non-ally steps on it. Can damage anything in its blast radius"),
        Turrets_ChemicalMine_Desc("&aSingle use mine that poisons any non-ally that steps on it"),
        Turrets_SoldierTurret_Desc("&aTurret that spawns zombie soldiers on non-ally players. Can attack through walls"),
        Turrets_HealingTurret_Desc("&aHeals nearby allies. Can heal through walls"),
        Turrets_ArrowTurret_Name("&bArrow Turret"),
        Turrets_FlameTurret_Name("&bFlame Turret"),
        Turrets_PsionicTotem_Name("&bPsionic Totem"),
        Turrets_HellfireTurret_Name("&bHellfire Turret"),
        Turrets_HeatbeamTurret_Name("&bHeatbeam Turret"),
        Turrets_PressureMine_Name("&bPressure Mine"),
        Turrets_ChemicalMine_Name("&bChemical Mine"),
        Turrets_SoldierTurret_Name("&bSoldier Spawner"),
        Turrets_HealingTurret_Name("&bHealing Station"),
        Turrets_Range("&9Range: "),
        Turrets_Damage("&9Damage: "),
        Turrets_AttackSpeed("&9Attack Speed: "),
        Turrets_Target_Random_In_Range("&9Targets one random non-ally in range"),
        Turrets_Target_Random_Player_Range("&9Targets one random non-ally player in range"),
        Turrets_Target_All_Player_Range("&9All targets in blast range"),
        Turrets_Target_Single("&9Single Target");

        private String defaultSring;

        private Languages(String defaultString) {
            this.defaultSring = defaultString;
        }

        public String getDefault() {
            return this.defaultSring;
        }
    }
}

