/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.json.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import org.generallib.database.serialize.Serializer;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.PermissionsInfo;

public class PermissionsInfoSerializer
implements Serializer<PermissionsInfo> {
    public JsonElement serialize(PermissionsInfo obj, Type type, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("nexus", (Number)obj.getNexus().getRank());
        json.addProperty("claim", (Number)obj.getClaim().getRank());
        json.addProperty("unclaim", (Number)obj.getUnclaim().getRank());
        json.addProperty("invade", (Number)obj.getInvade().getRank());
        json.addProperty("ally", (Number)obj.getAlly().getRank());
        json.addProperty("turret", (Number)obj.getTurret().getRank());
        json.addProperty("sethome", (Number)obj.getSethome().getRank());
        json.addProperty("chest", (Number)obj.getChest().getRank());
        json.addProperty("openallchest", (Number)obj.getOpenallchest().getRank());
        json.addProperty("invite", (Number)obj.getInvite().getRank());
        json.addProperty("broad", (Number)obj.getBroad().getRank());
        json.addProperty("structures", (Number)obj.getStructures().getRank());
        json.addProperty("nexusbuild", (Number)obj.getBuildInNexus().getRank());
        json.addProperty("overrideregulator", (Number)obj.getOverrideRegulator().getRank());
        return json;
    }

    public PermissionsInfo deserialize(JsonElement obj, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject json = (JsonObject)obj;
        PermissionsInfo info = new PermissionsInfo();
        info.setNexus(Rank.fromValue(json.get("nexus").getAsInt()));
        info.setClaim(Rank.fromValue(json.get("claim").getAsInt()));
        info.setUnclaim(Rank.fromValue(json.get("unclaim").getAsInt()));
        info.setInvade(Rank.fromValue(json.get("invade").getAsInt()));
        info.setAlly(Rank.fromValue(json.get("ally").getAsInt()));
        info.setTurret(Rank.fromValue(json.get("turret").getAsInt()));
        info.setSethome(Rank.fromValue(json.get("sethome").getAsInt()));
        info.setChest(Rank.fromValue(json.get("chest").getAsInt()));
        info.setOpenallchest(Rank.fromValue(json.get("openallchest").getAsInt()));
        info.setInvite(Rank.fromValue(json.get("invite").getAsInt()));
        info.setBroad(Rank.fromValue(json.get("broad").getAsInt()));
        if (json.get("structures") != null) {
            info.setStructures(Rank.fromValue(json.get("structures").getAsInt()));
        } else {
            info.setStructures(Rank.MODS);
            json.addProperty("structures", (Number)info.getStructures().getRank());
        }
        if (json.get("nexusbuild") != null) {
            info.setBuildInNexus(Rank.fromValue(json.get("nexusbuild").getAsInt()));
        } else {
            info.setBuildInNexus(Rank.ALL);
            json.addProperty("nexusbuild", (Number)info.getBuildInNexus().getRank());
        }
        if (json.get("overrideregulator") != null) {
            info.setOverrideRegulator(Rank.fromValue(json.get("overrideregulator").getAsInt()));
        } else {
            info.setOverrideRegulator(Rank.KING);
            json.addProperty("overrideregulator", (Number)info.getOverrideRegulator().getRank());
        }
        return info;
    }
}

