/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.json.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.generallib.database.serialize.Serializer;
import org.kingdoms.constants.land.KChestSign;
import org.kingdoms.constants.land.SimpleLocation;

public class KChestSignSerializer
implements Serializer<KChestSign> {
    private static Type listType = new TypeToken<ArrayList<UUID>>(){}.getType();

    public JsonElement serialize(KChestSign obj, Type type, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.add("loc", context.serialize((Object)obj.getLoc()));
        json.add("owner", context.serialize((Object)obj.getOwner()));
        json.add("owners", context.serialize(obj.getOwners()));
        return json;
    }

    public KChestSign deserialize(JsonElement obj, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject json = (JsonObject)obj;
        SimpleLocation loc = (SimpleLocation)context.deserialize(json.get("loc"), SimpleLocation.class);
        UUID owner = (UUID)context.deserialize(json.get("owner"), UUID.class);
        List owners = (List)context.deserialize(json.get("owners"), listType);
        return new KChestSign(loc, owner, owners);
    }
}

