/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.player;

import java.util.Date;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.manager.game.GameManagement;

public class OfflineKingdomPlayer {
    protected String kingdomName;
    protected Rank rank;
    protected UUID uuid;
    protected String lastKnownName;
    protected int donatedAmt;
    protected Date lastTimeDonated;
    protected int lastDonatedAmt;
    protected boolean markDisplaying;

    protected OfflineKingdomPlayer() {
    }

    public OfflineKingdomPlayer(UUID uuid) {
        this.uuid = uuid;
        if (this.rank == null) {
            this.rank = Rank.ALL;
        }
        if (this.donatedAmt <= 0) {
            this.donatedAmt = 0;
        }
        if (this.lastDonatedAmt <= 0) {
            this.lastDonatedAmt = 0;
        }
    }

    public OfflineKingdomPlayer(OfflinePlayer offp) {
        this.uuid = offp.getUniqueId();
        if (this.rank == null) {
            this.rank = Rank.ALL;
        }
        if (this.donatedAmt <= 0) {
            this.donatedAmt = 0;
        }
        if (this.lastDonatedAmt <= 0) {
            this.lastDonatedAmt = 0;
        }
    }

    public void setMarkDisplaying(boolean bool) {
        this.markDisplaying = bool;
    }

    public boolean isMarkDisplaying() {
        return this.markDisplaying;
    }

    public int getDonatedAmt() {
        return this.donatedAmt;
    }

    public Rank getRank() {
        return this.rank;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setKingdomName(String kingdomName) {
        this.kingdomName = kingdomName;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    public void setDonatedAmt(int donatedAmt) {
        this.donatedAmt = donatedAmt;
    }

    public String getKingdomName() {
        return this.kingdomName;
    }

    public String getName() {
        OfflinePlayer offp = Bukkit.getOfflinePlayer((UUID)this.uuid);
        if (offp == null) {
            return null;
        }
        this.lastKnownName = offp.getName();
        return this.lastKnownName;
    }

    public KingdomPlayer getKingdomPlayer() {
        return GameManagement.getPlayerManager().getSession(this.uuid);
    }

    public Date getLastTimeDonated() {
        return this.lastTimeDonated;
    }

    public void setLastTimeDonated(Date lastTimeDonated) {
        this.lastTimeDonated = lastTimeDonated;
    }

    public int getLastDonatedAmt() {
        return this.lastDonatedAmt;
    }

    public void setLastDonatedAmt(int lastDonatedAmt) {
        this.lastDonatedAmt = lastDonatedAmt;
    }

    public boolean isOnline() {
        return GameManagement.getPlayerManager().isOnline(this.uuid);
    }
}

