/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land;

import java.util.ArrayList;
import java.util.HashMap;
import org.kingdoms.constants.StructureType;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.KingdomManager;
import org.kingdoms.manager.game.LandManager;

public class WarpPadManager {
    private static HashMap<OfflineKingdom, ArrayList<Land>> structurePads = new HashMap();

    public static void load() {
        Kingdoms.getManagers();
        GameManagement.getLandManager();
        for (Land land : LandManager.landList.values()) {
            if (land.getStructure() == null || land.getStructure().getType() != StructureType.OUTPOST && land.getStructure().getType() != StructureType.NEXUS && land.getStructure().getType() != StructureType.WARPPAD || land.getOwner() == null) continue;
            Kingdoms.getManagers();
            WarpPadManager.addLand(GameManagement.getKingdomManager().getOfflineKingdom(land.getOwner()), land);
        }
        Kingdoms.getManagers();
        GameManagement.getKingdomManager();
        for (OfflineKingdom kingdom : KingdomManager.kingdomList.values()) {
            Kingdoms.getManagers();
            Kingdom k = GameManagement.getKingdomManager().getOrLoadKingdom(kingdom.getKingdomName());
            if (k.getNexus_loc() == null) continue;
            Kingdoms.getManagers();
            WarpPadManager.addLand(kingdom, GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(k.getNexus_loc().getChunk())));
        }
    }

    public static void addLand(OfflineKingdom k, Land land) {
        ArrayList<Land> lands = structurePads.get(k);
        if (lands == null) {
            lands = new ArrayList();
        }
        if (!lands.contains(land)) {
            lands.add(land);
        }
        structurePads.put(k, lands);
    }

    public static void removeLand(OfflineKingdom k, Land land) {
        if (structurePads.get(k).contains(land)) {
            structurePads.get(k).remove(land);
        }
    }

    public static ArrayList<Land> getOutposts(OfflineKingdom k) {
        return structurePads.get(k);
    }
}

