/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land;

import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.constants.Tickable;
import org.kingdoms.constants.TurretType;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.manager.external.ExternalManager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.utils.TurretUtil;

public class Turret
implements Tickable {
    private SimpleLocation loc;
    private Entity target;
    private int range;
    private TurretType type = TurretType.ARROW;
    private long tickPast = 0L;
    public LivingEntity soldier = null;
    private int soldierlife = 0;
    private static final TurretUtil.SplashAction action = new TurretUtil.SplashAction(){

        @Override
        public boolean canAttack(Chunk chunk, Entity entity) {
            Land land = GameManagement.getLandManager().getOrLoadLand(new SimpleChunkLocation(chunk));
            if (land == null) {
                return false;
            }
            if (land.getOwner() == null) {
                return false;
            }
            Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
            if (kingdom == null) {
                return false;
            }
            if (entity.hasMetadata("kingdom+" + kingdom.getKingdomName())) {
                return false;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                KingdomPlayer kp = GameManagement.getPlayerManager().getSession(player);
                if (kp == null) {
                    return ExternalManager.isCitizen((Entity)player);
                }
                if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
                    return false;
                }
                if (kp.getKingdom() == null) {
                    return true;
                }
                if (kingdom.equals(kp.getKingdom())) {
                    return false;
                }
                if (kingdom.isAllianceWith(kp.getKingdom())) {
                    return false;
                }
                if (kingdom.isEnemyWith(kp.getKingdom())) {
                    return true;
                }
                return true;
            }
            if (entity instanceof Wolf) {
                Wolf wolf = (Wolf)entity;
                AnimalTamer tamer = wolf.getOwner();
                if (tamer == null) {
                    return true;
                }
                if (tamer instanceof Player) {
                    Player player = (Player)tamer;
                    KingdomPlayer kp = GameManagement.getPlayerManager().getSession(player);
                    if (kp == null) {
                        return ExternalManager.isCitizen((Entity)player);
                    }
                    if (kp.getKingdom() == null) {
                        return true;
                    }
                    if (kingdom.equals(kp.getKingdom())) {
                        return false;
                    }
                    if (kingdom.isAllianceWith(kp.getKingdom())) {
                        return false;
                    }
                    if (kingdom.isEnemyWith(kp.getKingdom())) {
                        return true;
                    }
                    return true;
                }
            } else {
                if (GameManagement.getChampionManager().getChampionOwner(entity.getEntityId()) != null) {
                    return false;
                }
                if (entity instanceof Monster) {
                    return true;
                }
            }
            return true;
        }
    };

    private Turret() {
        this.type = TurretType.ARROW;
    }

    public Turret(SimpleLocation loc, TurretType type) {
        this.loc = loc;
        this.type = type;
    }

    public SimpleLocation getLoc() {
        return this.loc;
    }

    public TurretType getType() {
        return this.type;
    }

    public void setType(TurretType type) {
        this.type = type;
    }

    public static Turret fromString(String str) {
        String[] split = str.split(":");
        if (split.length != 2) {
            Kingdoms.logDebug((String)("Invailed turret data: " + str));
            return null;
        }
        Location bukkitLoc = SimpleLocation.strToLoc(split[0]);
        SimpleLocation loc = new SimpleLocation(bukkitLoc);
        TurretType type = TurretType.valueOf(split[1]);
        Turret turret = new Turret(loc, type);
        return turret;
    }

    public String toString() {
        return String.valueOf(this.loc.toString()) + ":" + this.type.toString();
    }

    public Entity getTarget() {
        return this.target;
    }

    public void setTarget(Entity target) {
        this.target = target;
    }

    @Override
    public void tick() {
        Location turretLoc = this.loc.toLocation();
        if (turretLoc.getBlock().getType() != Material.SKULL && turretLoc.getBlock().getType() != Material.STONE_PLATE && turretLoc.getBlock().getType() != Material.WOOD_PLATE) {
            GameManagement.getTurretManager().breakTurret(this);
            return;
        }
        switch (this.type) {
            case ARROW: {
                this.range = Kingdoms.config.turret_arrow_range;
                this.tickArrow(turretLoc, this.range, 20L);
                break;
            }
            case NEXUS: {
                this.tickNexus();
                break;
            }
            case FLAME: {
                this.range = Kingdoms.config.turret_flameturret_range;
                this.tickFlame(turretLoc, this.range, 10L);
                break;
            }
            case HEALING: {
                this.range = Kingdoms.config.turret_healingtower_range;
                this.tickHeal(turretLoc, this.range, 60L);
                break;
            }
            case PSIONIC: {
                this.range = Kingdoms.config.turret_psionictotem_range;
                this.tickPsionic(turretLoc, this.range, 50L);
                break;
            }
            case HELLFIRE: {
                this.range = Kingdoms.config.turret_hellfire_range;
                this.tickHellFire(turretLoc, this.range, 10L);
                break;
            }
            case SOLDIER: {
                this.range = Kingdoms.config.turret_soldierspawner_range;
                this.tickSoldier(turretLoc, this.range, 100L);
                break;
            }
            case HEATBEAM: {
                this.range = Kingdoms.config.turret_heatbeam_range;
                this.tickHeatBeam(turretLoc, this.range, 5L, Kingdoms.config.turret_heatbeam_damage);
                break;
            }
            case MINE_PRESSURE: {
                break;
            }
        }
        ++this.tickPast;
    }

    private boolean canShootPlayer(Turret t, Entity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        Land land = GameManagement.getLandManager().getOrLoadLand(this.loc.toSimpleChunk());
        if (land.getOwner() == null) {
            return true;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return false;
        }
        Damageable target = (Damageable)e;
        if (target.hasMetadata("kingdom+" + kingdom.getKingdomName())) {
            return false;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            KingdomPlayer kp = GameManagement.getPlayerManager().getSession(player);
            if (kp == null) {
                return ExternalManager.isCitizen((Entity)player);
            }
            if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
                return false;
            }
            if (kp.getKingdom() == null) {
                return true;
            }
            if (kingdom.equals(kp.getKingdom())) {
                return false;
            }
            if (kingdom.isAllianceWith(kp.getKingdom())) {
                return false;
            }
            if (kingdom.isEnemyWith(kp.getKingdom())) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean canShoot(Turret t, Entity e) {
        if (e == null) {
            return false;
        }
        if (t == null) {
            return false;
        }
        if (!(e instanceof Damageable)) {
            return false;
        }
        if (!Kingdoms.config.turret_hit_mobs && !(e instanceof Player)) {
            return false;
        }
        Land land = GameManagement.getLandManager().getOrLoadLand(this.loc.toSimpleChunk());
        if (land.getOwner() == null) {
            return true;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return false;
        }
        Damageable target = (Damageable)e;
        if (target.hasMetadata("kingdom+" + kingdom.getKingdomName())) {
            return false;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            KingdomPlayer kp = GameManagement.getPlayerManager().getSession(player);
            if (kp == null) {
                return false;
            }
            if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
                return false;
            }
            if (kp.getKingdom() == null) {
                return true;
            }
            if (kingdom.equals(kp.getKingdom())) {
                return false;
            }
            if (kingdom.isAllianceWith(kp.getKingdom())) {
                return false;
            }
            if (kingdom.isEnemyWith(kp.getKingdom())) {
                return true;
            }
            return true;
        }
        if (target instanceof Wolf) {
            Wolf wolf = (Wolf)target;
            AnimalTamer tamer = wolf.getOwner();
            if (tamer == null) {
                return true;
            }
            if (tamer instanceof Player) {
                Player player = (Player)tamer;
                KingdomPlayer kp = GameManagement.getPlayerManager().getSession(player);
                if (kp == null) {
                    return ExternalManager.isCitizen((Entity)player);
                }
                if (kp.getKingdom() == null) {
                    return true;
                }
                if (kingdom.equals(kp.getKingdom())) {
                    return false;
                }
                if (kingdom.isAllianceWith(kp.getKingdom())) {
                    return false;
                }
                if (kingdom.isEnemyWith(kp.getKingdom())) {
                    return true;
                }
                return true;
            }
        } else {
            if (GameManagement.getChampionManager().getChampionOwner(e.getEntityId()) != null) {
                return false;
            }
            if (target instanceof Monster) {
                return true;
            }
            if (target instanceof Slime) {
                return true;
            }
            if (target instanceof MagmaCube) {
                return true;
            }
        }
        return false;
    }

    private boolean isTargetValid() {
        if (this.target == null) {
            return false;
        }
        if (this.loc == null) {
            return false;
        }
        if (this.target.isDead() || !this.target.isValid()) {
            return false;
        }
        if (this.loc.toLocation() == null) {
            return false;
        }
        if (this.loc.toLocation().getWorld() != this.target.getLocation()) {
            return false;
        }
        return !(this.target.getLocation().distance(this.loc.toLocation()) > (double)this.range);
    }

    private void tickArrow(Location turretLoc, double range, long delay) {
        if (this.tickPast < delay) {
            return;
        }
        this.tickPast = 0L;
        Land land = GameManagement.getLandManager().getOrLoadLand(this.loc.toSimpleChunk());
        if (land.getOwner() == null) {
            return;
        }
        final Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        final Turret t = this;
        if (this.isTargetValid()) {
            TurretUtil.shootArrow(kingdom, this.getTarget().getLocation(), this.loc.toLocation(), false, false);
            return;
        }
        this.target = null;
        final Collection<Entity> entities = Turret.getNearbyEntities(turretLoc, range);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

            public void run() {
                boolean hasShot = false;
                for (final Entity e : entities) {
                    if (Turret.this.canShoot(t, e) && !hasShot) {
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

                            public void run() {
                                Turret.this.target = e;
                                TurretUtil.shootArrow(kingdom, e.getLocation(), Turret.this.loc.toLocation(), false, false);
                            }
                        });
                        hasShot = true;
                        continue;
                    }
                    if (!hasShot) continue;
                    return;
                }
            }
        });
    }

    private void tickNexus() {
    }

    private void tickFlame(Location turretLoc, double range, long delay) {
        if (this.tickPast < delay) {
            return;
        }
        this.tickPast = 0L;
        Land land = GameManagement.getLandManager().getOrLoadLand(this.loc.toSimpleChunk());
        if (land.getOwner() == null) {
            return;
        }
        final Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        final Turret t = this;
        if (this.isTargetValid()) {
            TurretUtil.shootArrow(kingdom, this.target.getLocation(), this.loc.toLocation(), false, true);
            return;
        }
        this.target = null;
        final Collection<Entity> entities = Turret.getNearbyEntities(turretLoc, range);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

            public void run() {
                boolean hasShot = false;
                for (final Entity e : entities) {
                    if (Turret.this.canShoot(t, e) && !hasShot) {
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

                            public void run() {
                                Turret.this.target = e;
                                TurretUtil.shootArrow(kingdom, e.getLocation(), Turret.this.loc.toLocation(), false, true);
                                if (kingdom.getTurretUpgrades().isFlurry()) {
                                    TurretUtil.volley(kingdom, e.getLocation(), Turret.this.loc.toLocation());
                                }
                            }
                        });
                        hasShot = true;
                        continue;
                    }
                    if (!hasShot) continue;
                    return;
                }
            }
        });
    }

    private void tickHeal(Location turretLoc, double range, long delay) {
        if (this.tickPast < delay) {
            return;
        }
        this.tickPast = 0L;
        Land land = GameManagement.getLandManager().getOrLoadLand(this.loc.toSimpleChunk());
        if (land.getOwner() == null) {
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        if (this.isTargetValid()) {
            TurretUtil.healEffect((Player)this.target, Kingdoms.config.turret_healingtower_damage);
            if (kingdom.getTurretUpgrades().isImprovedHeal()) {
                TurretUtil.regenHealEffect((Player)this.target, 1.0);
            }
            return;
        }
        this.target = null;
        for (Entity e : turretLoc.getWorld().getNearbyEntities(turretLoc, range, range, range)) {
            if (!(e instanceof Player)) continue;
            Player target = (Player)e;
            KingdomPlayer kp = GameManagement.getPlayerManager().getSession(target);
            if (target.getGameMode() == GameMode.CREATIVE || target.getGameMode() == GameMode.SPECTATOR || kp.getKingdom() == null) continue;
            if (kingdom.equals(kp.getKingdom())) {
                this.target = target;
                TurretUtil.healEffect(target, Kingdoms.config.turret_healingtower_damage);
                if (!kingdom.getTurretUpgrades().isImprovedHeal()) break;
                TurretUtil.regenHealEffect(target, 1.0);
                break;
            }
            if (kingdom.isAllianceWith(kp.getKingdom())) {
                this.target = target;
                TurretUtil.healEffect(target, Kingdoms.config.turret_healingtower_damage);
                if (!kingdom.getTurretUpgrades().isImprovedHeal()) break;
                TurretUtil.regenHealEffect(target, 1.0);
                break;
            }
            kingdom.isEnemyWith(kp.getKingdom());
        }
    }

    private void tickPsionic(Location turretLoc, double range, long delay) {
        if (this.tickPast < delay) {
            return;
        }
        this.tickPast = 0L;
        Land land = GameManagement.getLandManager().getOrLoadLand(this.loc.toSimpleChunk());
        if (land.getOwner() == null) {
            return;
        }
        final Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        final Turret t = this;
        if (this.isTargetValid()) {
            TurretUtil.psionicEffect(this.target, Kingdoms.config.turret_psionictotem_damage, kingdom.getTurretUpgrades().isVoodoo());
            return;
        }
        this.target = null;
        final Collection<Entity> entities = Turret.getNearbyEntities(turretLoc, range);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

            public void run() {
                boolean hasShot = false;
                for (final Entity e : entities) {
                    if (Turret.this.canShootPlayer(t, e) && !hasShot) {
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

                            public void run() {
                                Turret.this.target = e;
                                TurretUtil.psionicEffect(e, Kingdoms.config.turret_psionictotem_damage, kingdom.getTurretUpgrades().isVoodoo());
                            }
                        });
                        hasShot = true;
                        continue;
                    }
                    if (!hasShot) continue;
                    return;
                }
            }
        });
    }

    private void tickHellFire(Location turretLoc, double range, long givenDelay) {
        long delay = givenDelay;
        Land land = GameManagement.getLandManager().getOrLoadLand(this.loc.toSimpleChunk());
        if (land.getOwner() == null) {
            return;
        }
        final Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        if (kingdom.getTurretUpgrades().isHellstorm()) {
            delay = (long)((double)givenDelay * 0.6);
        }
        if (this.tickPast < delay) {
            return;
        }
        this.tickPast = 0L;
        final Turret t = this;
        if (this.isTargetValid()) {
            TurretUtil.shootArrow(kingdom, this.target.getLocation(), this.loc.toLocation(), true, false);
            return;
        }
        this.target = null;
        final Collection<Entity> entities = Turret.getNearbyEntities(turretLoc, range);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

            public void run() {
                boolean hasShot = false;
                for (final Entity e : entities) {
                    if (Turret.this.canShoot(t, e) && !hasShot) {
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

                            public void run() {
                                Turret.this.target = e;
                                TurretUtil.shootArrow(kingdom, e.getLocation(), Turret.this.loc.toLocation(), true, false);
                            }
                        });
                        hasShot = true;
                        continue;
                    }
                    if (!hasShot) continue;
                    return;
                }
            }
        });
    }

    private void tickSoldier(Location turretLoc, double range, long delay) {
        if (this.tickPast < delay) {
            return;
        }
        this.tickPast = 0L;
        Land land = GameManagement.getLandManager().getOrLoadLand(this.loc.toSimpleChunk());
        if (land.getOwner() == null) {
            return;
        }
        final Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        if (this.soldier != null) {
            if (this.soldier.isDead() || !this.soldier.isValid()) {
                this.soldier = null;
                return;
            }
            if (this.soldierlife < 200) {
                ++this.soldierlife;
                return;
            }
            if (!this.soldier.isDead() && this.soldier.isValid()) {
                if (!this.soldier.getLocation().getChunk().isLoaded()) {
                    this.soldier.getLocation().getChunk().load();
                }
                this.soldier.remove();
                this.soldier = null;
                this.soldierlife = 0;
            } else {
                this.soldier = null;
            }
        }
        if (this.isTargetValid()) {
            TurretUtil.spawnSoldier(this.target.getLocation(), (Player)this.target, kingdom, this);
            return;
        }
        this.target = null;
        boolean hasShot = false;
        final Turret t = this;
        final Collection<Entity> entities = Turret.getNearbyEntities(turretLoc, range);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

            public void run() {
                boolean hasShot = false;
                for (final Entity e : entities) {
                    if (Turret.this.canShootPlayer(t, e) && !hasShot) {
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

                            public void run() {
                                Turret.this.target = e;
                                TurretUtil.spawnSoldier(e.getLocation(), (Player)e, kingdom, t);
                            }
                        });
                        hasShot = true;
                        continue;
                    }
                    if (!hasShot) continue;
                    return;
                }
            }
        });
    }

    private void tickHeatBeam(final Location turretLoc, double range, long delay, double nonfinaldmg) {
        if (this.tickPast < delay) {
            return;
        }
        this.tickPast = 0L;
        Land land = GameManagement.getLandManager().getOrLoadLand(this.loc.toSimpleChunk());
        if (land.getOwner() == null) {
            return;
        }
        Kingdom kingdom = GameManagement.getKingdomManager().getOrLoadKingdom(land.getOwner());
        if (kingdom == null) {
            return;
        }
        if (kingdom.getTurretUpgrades().isUnrelentingGaze()) {
            nonfinaldmg += 3.0;
        }
        final double damage = nonfinaldmg;
        if (this.isTargetValid()) {
            TurretUtil.fireHeatBeam(this.target, turretLoc, damage, action);
            return;
        }
        this.target = null;
        final Turret t = this;
        final Collection<Entity> entities = Turret.getNearbyEntities(turretLoc, range);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

            public void run() {
                boolean hasShot = false;
                for (final Entity e : entities) {
                    if (Turret.this.canShoot(t, e) && !hasShot) {
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

                            public void run() {
                                Turret.this.target = e;
                                TurretUtil.fireHeatBeam(e, turretLoc, damage, action);
                            }
                        });
                        hasShot = true;
                        continue;
                    }
                    if (!hasShot) continue;
                    return;
                }
            }
        });
    }

    public static Collection<Entity> getNearbyEntities(Location loc, double radius) {
        ArrayList<Entity> surroundings = new ArrayList<Entity>();
        Chunk c = loc.getChunk();
        int x = -1;
        while (x <= 1) {
            int y = -1;
            while (y <= 1) {
                Chunk chunk = c.getWorld().getChunkAt(c.getX() + x, c.getZ() + y);
                Entity[] entityArray = chunk.getEntities();
                int n = entityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Entity e = entityArray[n2];
                    if (e.getLocation().distance(loc) <= radius) {
                        surroundings.add(e);
                    }
                    ++n2;
                }
                ++y;
            }
            ++x;
        }
        return surroundings;
    }
}

