/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kingdoms.constants.land.KChestSign;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.constants.land.SimpleLocation;
import org.kingdoms.constants.land.Structure;
import org.kingdoms.constants.land.Turret;

public class Land {
    private SimpleChunkLocation loc;
    private String owner;
    private Long claimTime;
    private Structure structure = null;
    private List<Turret> turrets = new ArrayList<Turret>();
    private List<KChestSign> signs = new ArrayList<KChestSign>();
    private String name;

    private Land() {
        this.turrets = new ArrayList<Turret>();
        this.signs = new ArrayList<KChestSign>();
    }

    public Land(SimpleChunkLocation loc) {
        this.loc = loc;
        if (this.name == null) {
            this.name = loc.toString();
        }
    }

    public SimpleChunkLocation getLoc() {
        return this.loc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.loc.toString();
        }
        return this.name;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    public Turret getTurret(SimpleLocation loc) {
        if (this.turrets == null) {
            return null;
        }
        for (Turret turret : this.turrets) {
            if (!turret.getLoc().equals(loc)) continue;
            return turret;
        }
        return null;
    }

    public void addTurret(Turret turret) {
        if (this.turrets == null) {
            this.turrets = new ArrayList<Turret>();
        }
        if (this.turrets.contains(turret)) {
            return;
        }
        this.turrets.add(turret);
    }

    public boolean hasTurret(Turret turret) {
        if (this.turrets == null) {
            this.turrets = new ArrayList<Turret>();
        }
        return this.turrets.contains(turret);
    }

    public List<Turret> getTurrets() {
        return this.turrets;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Long getClaimTime() {
        return this.claimTime;
    }

    public void setClaimTime(Long claimTime) {
        this.claimTime = claimTime;
    }

    public void addChestSign(KChestSign sign) {
        if (this.signs == null) {
            this.signs = new ArrayList<KChestSign>();
        }
        if (this.signs.contains(sign)) {
            this.signs.remove(sign);
        }
        this.signs.add(sign);
    }

    public KChestSign getChestSign(SimpleLocation loc) {
        if (loc == null) {
            return null;
        }
        if (this.signs == null) {
            return null;
        }
        for (KChestSign sign : this.signs) {
            if (!sign.getLoc().equals(loc)) continue;
            return sign;
        }
        return null;
    }

    public void removeChestSign(SimpleLocation loc) {
        if (loc == null) {
            return;
        }
        if (this.signs == null) {
            return;
        }
        Iterator<KChestSign> iter = this.signs.iterator();
        while (iter.hasNext()) {
            KChestSign sign = iter.next();
            if (!sign.getLoc().equals(loc)) continue;
            iter.remove();
            return;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Land other = (Land)obj;
        return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
    }
}

