/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.kingdom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.AggressorInfo;
import org.kingdoms.constants.kingdom.ArmyInfo;
import org.kingdoms.constants.kingdom.ChampionInfo;
import org.kingdoms.constants.kingdom.KingdomChest;
import org.kingdoms.constants.kingdom.KingdomEventHandler;
import org.kingdoms.constants.kingdom.MisupgradeInfo;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.constants.kingdom.PermissionsInfo;
import org.kingdoms.constants.kingdom.PowerUp;
import org.kingdoms.constants.kingdom.TurretUpgradeInfo;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.OfflineKingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.LandManager;

public class Kingdom
extends OfflineKingdom
implements KingdomEventHandler {
    transient List<KingdomPlayer> onlineMembers = new ArrayList<KingdomPlayer>();
    transient List<Kingdom> onlineEnemies = new ArrayList<Kingdom>();
    transient List<Kingdom> onlineAllies = new ArrayList<Kingdom>();
    transient int kingdomLand = 0;
    transient int uptime = 2;
    Location nexus_loc;
    Location home_loc;
    int chestsize = 9;
    long timestamp = 0L;
    int maxMember = 10;
    ChampionInfo championInfo = new ChampionInfo();
    PermissionsInfo permissionsInfo = new PermissionsInfo();
    ArmyInfo armyInfo = new ArmyInfo();
    AggressorInfo aggressorInfo = new AggressorInfo();
    MisupgradeInfo misupgradeInfo = new MisupgradeInfo();
    KingdomChest kingdomChest = new KingdomChest();
    PowerUp powerUp = new PowerUp();
    TurretUpgradeInfo turretUpgrades = new TurretUpgradeInfo();

    private Kingdom() {
        this.onlineMembers = new ArrayList<KingdomPlayer>();
        this.onlineEnemies = new ArrayList<Kingdom>();
        this.onlineAllies = new ArrayList<Kingdom>();
    }

    public Kingdom(String kingdomName) {
        super(kingdomName);
    }

    public Location getNexus_loc() {
        return this.nexus_loc;
    }

    public int getTimeToExpire() {
        return this.uptime;
    }

    public void setTimeToExpire(int uptime) {
        this.uptime = uptime;
    }

    public void setNexus_loc(Location nexus_loc) {
        this.nexus_loc = nexus_loc;
    }

    public Location getHome_loc() {
        return this.home_loc;
    }

    public void setHome_loc(Location home_loc) {
        this.home_loc = home_loc;
    }

    public int getChestsize() {
        return this.chestsize;
    }

    public void setChestsize(int chestsize) {
        this.chestsize = chestsize;
    }

    public List<KingdomPlayer> getOnlineMembers() {
        return this.onlineMembers;
    }

    public List<Kingdom> getOnlineEnemies() {
        return this.onlineEnemies;
    }

    public List<Kingdom> getOnlineAllies() {
        return this.onlineAllies;
    }

    public ChampionInfo getChampionInfo() {
        if (this.championInfo == null) {
            this.championInfo = new ChampionInfo();
        }
        return this.championInfo;
    }

    public PermissionsInfo getPermissionsInfo() {
        if (this.permissionsInfo == null) {
            this.permissionsInfo = new PermissionsInfo();
        }
        return this.permissionsInfo;
    }

    public ArmyInfo getArmyInfo() {
        if (this.armyInfo == null) {
            this.armyInfo = new ArmyInfo();
        }
        return this.armyInfo;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public AggressorInfo getAggressorInfo() {
        if (this.aggressorInfo == null) {
            this.aggressorInfo = new AggressorInfo();
        }
        return this.aggressorInfo;
    }

    public TurretUpgradeInfo getTurretUpgrades() {
        return this.turretUpgrades;
    }

    public int getMaxMember() {
        return this.maxMember;
    }

    public void setMaxMember(int maxMember) {
        this.maxMember = maxMember;
    }

    public MisupgradeInfo getMisupgradeInfo() {
        if (this.misupgradeInfo == null) {
            this.misupgradeInfo = new MisupgradeInfo();
        }
        return this.misupgradeInfo;
    }

    public KingdomChest getKingdomChest() {
        if (this.kingdomChest == null) {
            this.kingdomChest = new KingdomChest();
        }
        return this.kingdomChest;
    }

    public void setKingdomChest(KingdomChest kingdomChest) {
        this.kingdomChest = kingdomChest;
    }

    public PowerUp getPowerUp() {
        if (this.powerUp == null) {
            this.powerUp = new PowerUp();
        }
        return this.powerUp;
    }

    public void setPowerUp(PowerUp powerUp) {
        this.powerUp = powerUp;
    }

    public void setResourcepoints(int resourcepoints) {
        this.resourcepoints = resourcepoints;
        if (this.resourcepoints < 0) {
            this.resourcepoints = 0;
        }
    }

    public void setMight(int might) {
        this.might = might;
    }

    public void setLand(int land) {
    }

    public int getLand() {
        int land = 0;
        for (Land l : LandManager.landList.values()) {
            if (l.getOwner() == null || !l.getOwner().equals(this.getKingdomName())) continue;
            ++land;
        }
        return land;
    }

    public void setDynmapColor(int dynmapColor) {
        this.dynmapColor = dynmapColor;
    }

    public void setKingdomName(String kingdomName) {
        this.kingdomName = kingdomName;
    }

    public void setKingdomLore(String kingdomLore) {
        this.kingdomLore = kingdomLore;
    }

    public void addMember(UUID uuid) {
        if (this.membersList.contains(uuid)) {
            return;
        }
        this.membersList.add(uuid);
    }

    public void removeMember(UUID uuid) {
        this.membersList.remove(uuid);
    }

    public void enemyKingdom(Kingdom target) {
        if (this.getAlliesList().contains(target.getKingdomName())) {
            this.getAlliesList().remove(target.getKingdomName());
            if (GameManagement.getKingdomManager().isOnline(target.getKingdomName())) {
                this.getOnlineAllies().remove(target);
            }
        }
        this.getEnemiesList().add(target.getKingdomName());
        this.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Enemy_Success).replaceAll("%kingdom%", target.getKingdomName()), false);
        if (GameManagement.getKingdomManager().isOnline(target.getKingdomName())) {
            this.getOnlineEnemies().add(target);
        }
    }

    public void addAlly(String kingdomName) {
        if (this.alliesList.contains(kingdomName)) {
            return;
        }
        this.alliesList.add(kingdomName);
    }

    public void removeAlly(String kingdomName) {
        this.alliesList.remove(kingdomName);
    }

    public void sendAnnouncement(KingdomPlayer sender, String announce, boolean nameless) {
        for (KingdomPlayer kp : this.onlineMembers) {
            if (sender == null) {
                kp.getPlayer().sendMessage(ChatColor.AQUA + "[" + this.kingdomName + "] " + ChatColor.GRAY + announce);
                continue;
            }
            if (sender != null && !nameless) {
                kp.getPlayer().sendMessage(ChatColor.AQUA + "[" + this.kingdomName + ChatColor.DARK_GRAY + " (" + Rank.getFancyMarkByRank(sender.getRank()) + (Object)((Object)sender.getRank()) + ChatColor.DARK_GRAY + ")" + ChatColor.AQUA + "] " + ChatColor.GRAY + announce);
            }
            if (!nameless) continue;
            kp.getPlayer().sendMessage(ChatColor.AQUA + "[" + this.kingdomName + "] " + ChatColor.GRAY + announce);
        }
    }

    public boolean isMember(KingdomPlayer kp) {
        if (kp == null) {
            return false;
        }
        return this.equals(kp.getKingdom());
    }

    public boolean isAllyMember(KingdomPlayer kp) {
        if (kp == null) {
            return false;
        }
        return this.isAllianceWith(kp.getKingdom());
    }

    public boolean isEnemyMember(KingdomPlayer kp) {
        if (kp == null) {
            return false;
        }
        return this.isEnemyWith(kp.getKingdom());
    }

    public Map<String, String> getInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("kingdom", String.valueOf(this.kingdomName));
        info.put("kingdomLore", String.valueOf(this.kingdomLore));
        info.put("king", Bukkit.getOfflinePlayer((UUID)this.king) != null ? Bukkit.getOfflinePlayer((UUID)this.king).getName() : null);
        info.put("might", String.valueOf(this.might));
        info.put("nexusAt", this.nexus_loc != null ? this.nexus_loc.toString() : null);
        info.put("homeAt", this.home_loc != null ? this.home_loc.toString() : null);
        info.put("rp", String.valueOf(this.resourcepoints));
        String members = "";
        for (KingdomPlayer member : this.onlineMembers) {
            members = String.valueOf(members) + " " + member.getPlayer().getName();
        }
        info.put("online", members);
        info.put("land", String.valueOf(this.kingdomLand));
        return info;
    }

    @Override
    public void onOtherKingdomLoad(Kingdom k) {
        if (this.alliesList.contains(k.getKingdomName())) {
            this.onlineAllies.add(k);
        }
        if (this.enemiesList.contains(k.getKingdomName())) {
            this.onlineEnemies.add(k);
        }
    }

    @Override
    public void onOtherKingdomUnLoad(Kingdom k) {
        if (this.onlineAllies.contains(k)) {
            this.onlineAllies.remove(k);
        }
        if (this.onlineEnemies.contains(k)) {
            this.onlineEnemies.remove(k);
        }
    }

    @Override
    public synchronized void onKingdomPlayerLogin(KingdomPlayer kp) {
        Kingdoms.logDebug((String)("event login? " + this.onlineMembers.contains(kp)));
        if (!this.onlineMembers.contains(kp) && this.king.equals(kp.getUuid())) {
            this.onlineMembers.add(kp);
            kp.setRank(Rank.KING);
            this.sendAnnouncement(null, "King [" + kp.getPlayer().getName() + "] is now " + ChatColor.GREEN + "Online", true);
        } else if (!this.onlineMembers.contains(kp) && this.membersList.contains(kp.getUuid())) {
            if (kp.getRank() == Rank.KING) {
                kp.setRank(Rank.ALL);
            }
            this.onlineMembers.add(kp);
            this.sendAnnouncement(null, "[" + kp.getPlayer().getName() + "] is now " + ChatColor.GREEN + "Online", true);
        }
    }

    @Override
    public synchronized void onKingdomPlayerLogout(KingdomPlayer kp) {
        Kingdoms.logDebug((String)("event logout? " + this.onlineMembers.contains(kp)));
        if (this.onlineMembers.contains(kp) && this.membersList.contains(kp.getUuid())) {
            this.onlineMembers.remove(kp);
            this.sendAnnouncement(null, "[" + kp.getPlayer().getName() + "] is now " + ChatColor.RED + "Offline", true);
        }
    }

    @Override
    public void onMemberJoinKingdom(OfflineKingdomPlayer kp) {
        if (kp.getKingdomName() != null && !kp.getKingdomName().equalsIgnoreCase(this.kingdomName)) {
            return;
        }
        kp.setRank(Rank.ALL);
        this.membersList.add(kp.getUuid());
        if (kp.isOnline()) {
            this.onlineMembers.add((KingdomPlayer)kp);
        }
        this.sendAnnouncement(null, "[" + kp.getName() + "] has joined your kingdom!", true);
    }

    @Override
    public void onMemberQuitKingdom(OfflineKingdomPlayer kp) {
        if (!this.membersList.contains(kp.getUuid())) {
            return;
        }
        if (kp instanceof KingdomPlayer) {
            ((KingdomPlayer)kp).setRank(Rank.ALL);
            ((KingdomPlayer)kp).setKingdom(null);
            kp.setDonatedAmt(0);
            kp.setLastDonatedAmt(0);
            kp.setLastTimeDonated(null);
            this.membersList.remove(kp.getUuid());
            if (this.onlineMembers.contains((KingdomPlayer)kp)) {
                this.onlineMembers.remove((KingdomPlayer)kp);
            }
        } else {
            kp.setRank(Rank.ALL);
            kp.setKingdomName(null);
            kp.setDonatedAmt(0);
            kp.setLastDonatedAmt(0);
            kp.setLastTimeDonated(null);
            this.membersList.remove(kp.getUuid());
        }
        this.sendAnnouncement(null, "[" + kp.getName() + "] has left your kingdom!", true);
    }

    @Override
    public void onKingdomDelete(Kingdom k) {
        String kname = k.getKingdomName();
        if (this.alliesList.contains(kname)) {
            this.alliesList.remove(kname);
        }
        if (this.enemiesList.contains(kname)) {
            this.enemiesList.remove(kname);
        }
        if (this.onlineAllies.contains(k)) {
            this.onlineAllies.remove(k);
        }
        if (this.onlineEnemies.contains(k)) {
            this.onlineEnemies.remove(k);
        }
    }
}

