/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.conquest;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.kingdoms.constants.conquest.ActiveConquestBattle;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.TurretUtil;

public class ConquestTurret {
    int level;
    private int tickPast = 0;
    final Location location;
    ActiveConquestBattle battle;

    public ConquestTurret(ActiveConquestBattle battle, Location loc, int level) {
        this.battle = battle;
        this.location = loc;
        this.level = level;
        if (battle.land.getSupplylevel() < Kingdoms.config.maxSupplyLand / 2) {
            this.level = level / 2;
        }
    }

    public void tick() {
        boolean fire;
        if (this.level == 0) {
            return;
        }
        if (this.battle.land.getSupplylevel() == 0) {
            return;
        }
        int delay = 20 - this.level;
        if (delay < 5) {
            delay = 5;
        }
        final boolean crit = this.level > 10;
        boolean bl = fire = this.level > 5;
        if (this.tickPast < delay) {
            ++this.tickPast;
            return;
        }
        final ArrayList<Player> entities = this.battle.getInvaders();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

            public void run() {
                boolean hasShot = false;
                for (final Player p : entities) {
                    if (!(p.getLocation().distance(ConquestTurret.this.location) <= 20.0)) continue;
                    Bukkit.getScheduler().runTask((Plugin)Kingdoms.getInstance(), new BukkitRunnable(){

                        public void run() {
                            ConquestTurret.shootArrow(p.getLocation().add(0.0, 1.0, 0.0), (this).ConquestTurret.this.location.clone().add(0.5, 0.5, 0.5), crit, fire);
                            ConquestTurret.this.tickPast = 0;
                        }
                    });
                }
            }
        });
    }

    public static void shootArrow(Location target, Location origin, boolean crit, boolean fire) {
        Vector to = target.clone().add(0.0, 0.75, 0.0).toVector();
        Location fromLoc = origin.clone().add(0.0, 1.0, 0.0);
        Vector from = fromLoc.toVector();
        Vector direction = to.subtract(from);
        direction.normalize();
        Arrow arrow = origin.getWorld().spawnArrow(fromLoc, direction, 1.5f, 10.0f);
        arrow.setMetadata("CONQUESTARROW", (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.getInstance(), (Object)"yes!"));
        if (crit) {
            arrow.setCritical(crit);
        }
        if (fire) {
            arrow.setFireTicks(Integer.MAX_VALUE);
        }
        TurretUtil.shotArrows.add(new TurretUtil.ShotArrow(arrow));
    }
}

