/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.conquest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.kingdoms.constants.conquest.ConquestLand;
import org.kingdoms.constants.conquest.ConquestMap;
import org.kingdoms.constants.conquest.ConquestTurret;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.ConquestManager;
import org.kingdoms.manager.game.GameManagement;
import org.kingdoms.manager.game.GuardsManager;

public class ActiveConquestBattle {
    public Chunk middle;
    public ArrayList<Chunk> subchunks = new ArrayList();
    public ArrayList<Chunk> usedChunks = new ArrayList();
    public Kingdom invadingKingdom;
    public ArrayList<Player> players = new ArrayList();
    public HashMap<Integer, ConquestTurret> turrets = new HashMap();
    public ConquestLand land;
    public static HashMap<UUID, Integer> gametasks = new HashMap();
    private UUID uuid;
    public ArrayList<KingdomPlayer> invaders = new ArrayList();
    public Runnable gametask;
    public ArrayList<Entity> moblist = new ArrayList();
    public ArrayList<Location> modifiedBlocks = new ArrayList();
    private boolean isTerminated = false;

    public ActiveConquestBattle(Chunk middle, ConquestLand land) {
        this.uuid = UUID.randomUUID();
        this.middle = middle;
        this.land = land;
        int radius = 5;
        int x = -1 * radius;
        while (x <= radius) {
            int z = -1 * radius;
            while (z <= radius) {
                this.subchunks.add(ConquestManager.world.getChunkAt(x, z));
                ++z;
            }
            ++x;
        }
        int midx = middle.getX();
        int midz = middle.getZ();
        this.gametask = new GameTask(this);
        int id = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Kingdoms.getInstance(), this.gametask, 0L, 1L);
        Kingdoms.logDebug((String)("Put in, " + id + " under " + this.uuid.toString()));
        gametasks.put(this.uuid, id);
    }

    public void concludeVictory() {
        if (this.isTerminated) {
            return;
        }
        this.isTerminated = true;
        this.land.setOwner(this.invadingKingdom.getKingdomName());
        this.invadingKingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Conquests_Kingdom_Conquered_Land).replaceAll("%land%", this.capitalize(this.land.getDataID())), true);
        for (KingdomPlayer kp : this.invaders) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Conquests_Kingdom_Conquered_Land).replaceAll("%land%", this.capitalize(this.land.getDataID())));
        }
        this.stopInvasion();
        ConquestLand land = ConquestMap.getLandAt(ConquestManager.maps.get(this.land.map), this.land.x, this.land.y);
    }

    public void concludeDefeat() {
        if (this.isTerminated) {
            return;
        }
        this.isTerminated = true;
        this.invadingKingdom.sendAnnouncement(null, Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Conquests_Kingdom_Defeat).replaceAll("%land%", this.capitalize(this.land.getDataID())), true);
        for (KingdomPlayer kp : this.invaders) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Conquests_Kingdom_Defeat).replaceAll("%land%", this.capitalize(this.land.getDataID())));
        }
        this.stopInvasion();
        ConquestLand land = ConquestMap.getLandAt(ConquestManager.maps.get(this.land.map), this.land.x, this.land.y);
    }

    public ArrayList<Player> getInvaders() {
        ArrayList<Player> list = new ArrayList<Player>();
        for (KingdomPlayer p : this.invaders) {
            list.add(p.getPlayer());
        }
        return list;
    }

    public void stopInvasion() {
        ArrayList<KingdomPlayer> invaders = new ArrayList<KingdomPlayer>();
        for (KingdomPlayer kp : this.invaders) {
            invaders.add(kp);
        }
        for (KingdomPlayer p : invaders) {
            ConquestManager.leaveOffensive(p);
        }
        ConquestManager.kingdomsMissions.remove(this.invadingKingdom);
        invaders.clear();
        for (Entity e : this.moblist) {
            e.remove();
        }
        for (Chunk c : this.usedChunks) {
            int x = 0;
            while (x < 15) {
                int z = 0;
                while (z < 15) {
                    int y = 100;
                    while (y < 130) {
                        c.getBlock(x, y, z).setType(Material.AIR);
                        ++y;
                    }
                    ++z;
                }
                ++x;
            }
        }
        Kingdoms.logDebug((String)("Took out, " + gametasks.get(this.uuid) + " from " + this.uuid.toString()));
        Bukkit.getScheduler().cancelTask(gametasks.remove(this.uuid).intValue());
        ConquestLand land = ConquestMap.getLandAt(ConquestManager.maps.get(this.land.map), this.land.x, this.land.y);
        land.isUnderSiege = false;
    }

    public void stopInvasionServerStop() {
        ArrayList<KingdomPlayer> invaders = new ArrayList<KingdomPlayer>();
        for (KingdomPlayer kp : this.invaders) {
            invaders.add(kp);
        }
        for (KingdomPlayer p : invaders) {
            ConquestManager.leaveOffensive(p);
        }
        invaders.clear();
        for (Entity e : this.moblist) {
            e.remove();
        }
        for (Chunk c : this.usedChunks) {
            int x = 0;
            while (x < 15) {
                int z = 0;
                while (z < 15) {
                    int y = 100;
                    while (y < 115) {
                        c.getBlock(x, y, z).setType(Material.AIR);
                        ++y;
                    }
                    ++z;
                }
                ++x;
            }
        }
        Bukkit.getScheduler().cancelTask(gametasks.remove(this.uuid).intValue());
        ConquestLand land = ConquestMap.getLandAt(ConquestManager.maps.get(this.land.map), this.land.x, this.land.y);
        land.isUnderSiege = false;
    }

    public Chunk getMiddle() {
        return this.middle;
    }

    public ArrayList<Chunk> getSubchunks() {
        return this.subchunks;
    }

    public ArrayList<Chunk> getUsedChunks() {
        return this.usedChunks;
    }

    private String capitalize(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public class GameTask
    implements Runnable {
        ActiveConquestBattle battle;
        int spawnerDelay = 10;
        int sectick = 0;
        int siegeBreakerSpawn = 0;
        Location creeperSpawn;

        public GameTask(ActiveConquestBattle battle) {
            this.battle = battle;
            Chunk tchunk = battle.getMiddle().getWorld().getChunkAt(battle.getMiddle().getX(), battle.getMiddle().getZ() + 1);
            this.creeperSpawn = tchunk.getBlock(8, 102, 2).getLocation();
        }

        @Override
        public void run() {
            int maxmobs = 50;
            if (ActiveConquestBattle.this.turrets.size() > 0) {
                for (int i : ActiveConquestBattle.this.turrets.keySet()) {
                    ConquestTurret turret = ActiveConquestBattle.this.turrets.get(i);
                    if (turret.location.getBlock().getType() != Material.SKULL) continue;
                    turret.tick();
                }
            }
            if (this.sectick < 20) {
                ++this.sectick;
            }
            if (this.sectick >= 20) {
                this.sectick = 0;
                Iterator<Entity> iter = ActiveConquestBattle.this.moblist.iterator();
                while (iter.hasNext()) {
                    Entity e = iter.next();
                    if (e.isValid() && !e.isDead()) continue;
                    iter.remove();
                }
                if (ActiveConquestBattle.this.land.getSpawnerlevel() > 0 && ActiveConquestBattle.this.moblist.size() < maxmobs) {
                    this.spawnerDelay -= ActiveConquestBattle.this.land.getSpawnerlevel();
                    if (this.spawnerDelay <= 0) {
                        Kingdoms.getManagers();
                        GuardsManager guardsManager = GameManagement.getGuardsManager();
                        Location location = ActiveConquestBattle.this.middle.getBlock(8, 103, 8).getLocation();
                        Kingdoms.getManagers();
                        Entity z = guardsManager.spawnNexusGuard(location, GameManagement.getKingdomManager().getOrLoadKingdom(ActiveConquestBattle.this.land.getOwner()), null);
                        if (ActiveConquestBattle.this.land.getSupplylevel() == 0) {
                            ((Zombie)z).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 999999, 2));
                            ((Zombie)z).addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 999999, 1));
                        }
                        if (this.siegeBreakerSpawn < 5) {
                            ++this.siegeBreakerSpawn;
                        } else {
                            this.siegeBreakerSpawn = 0;
                            Kingdoms.getManagers();
                            GuardsManager guardsManager2 = GameManagement.getGuardsManager();
                            Kingdoms.getManagers();
                            Entity c = guardsManager2.spawnSiegeBreaker(this.creeperSpawn, GameManagement.getKingdomManager().getOrLoadKingdom(ActiveConquestBattle.this.land.getOwner()), null);
                            if (ActiveConquestBattle.this.land.getSupplylevel() == 0) {
                                ((Creeper)c).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 999999, 2));
                                ((Creeper)c).addPotionEffect(new PotionEffect(PotionEffectType.POISON, 999999, 3));
                            }
                            ActiveConquestBattle.this.moblist.add(c);
                        }
                        ActiveConquestBattle.this.moblist.add(z);
                    }
                }
            }
        }
    }
}

