/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants;

import org.bukkit.ChatColor;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;

public enum Rank {
    KING(0),
    MODS(1),
    ALL(9999);

    private int rank;

    private Rank(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    public static Rank fromValue(int rank) {
        Rank[] rankArray = Rank.values();
        int n = rankArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rank r = rankArray[n2];
            if (r.rank == rank) {
                return r;
            }
            ++n2;
        }
        return ALL;
    }

    public boolean isHigherOrEqualTo(Rank target) {
        return this.rank <= target.rank;
    }

    public boolean isHigherThan(Rank target) {
        return this.rank < target.rank;
    }

    public static ChatColor colorByRank(Rank rank) {
        switch (rank) {
            case ALL: {
                return ChatColor.GREEN;
            }
            case MODS: {
                return ChatColor.BLUE;
            }
            case KING: {
                return ChatColor.RED;
            }
        }
        return ChatColor.WHITE;
    }

    public static String getFancyMarkByRank(Rank rank) {
        switch (rank) {
            case ALL: {
                return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_All);
            }
            case MODS: {
                return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_Mods);
            }
            case KING: {
                return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_King);
            }
        }
        return "?";
    }

    public String getFancyMark() {
        switch (this) {
            case ALL: {
                return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_All);
            }
            case MODS: {
                return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_Mods);
            }
            case KING: {
                return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_King);
            }
        }
        return "?";
    }

    public ChatColor getColor() {
        switch (this) {
            case ALL: {
                return ChatColor.GREEN;
            }
            case MODS: {
                return ChatColor.BLUE;
            }
            case KING: {
                return ChatColor.GOLD;
            }
        }
        return ChatColor.WHITE;
    }

    public String toString() {
        switch (this) {
            case ALL: {
                return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_All_Name);
            }
            case MODS: {
                return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_Mods_Name);
            }
            case KING: {
                return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_King_Name);
            }
        }
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_All_Name);
    }

    public static Rank getFromString(String key) {
        if (key.equalsIgnoreCase(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_All_Name))) {
            return ALL;
        }
        if (key.equalsIgnoreCase(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_Mods_Name))) {
            return MODS;
        }
        if (key.equalsIgnoreCase(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Rank_King_Name))) {
            return KING;
        }
        return ALL;
    }
}

