/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandDonate
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 2;
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.donate");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        String kingdomtodonate = args.poll();
        String stramt = args.poll();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        if (!kp.getRank().isHigherOrEqualTo(kingdom.getPermissionsInfo().getNexus())) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Rank_Too_Low).replaceAll("%rank%", kingdom.getPermissionsInfo().getNexus().toString()));
            return;
        }
        try {
            int amount = Integer.parseInt(stramt);
            if (kingdom.getResourcepoints() >= amount && amount > 0) {
                Kingdom receiver = GameManagement.getKingdomManager().getOrLoadKingdom(kingdomtodonate);
                if (receiver != null) {
                    receiver.setResourcepoints(receiver.getResourcepoints() + amount);
                    kingdom.setResourcepoints(kingdom.getResourcepoints() - amount);
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Donate_Success).replaceAll("%amount%", stramt).replaceAll("%kingdom%", kingdomtodonate));
                } else {
                    kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Donate_Kingdom_Non_Existant));
                }
            } else {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_Enough_Points).replaceAll("%cost%", stramt));
            }
        }
        catch (NumberFormatException e) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Donate_Must_Be_Number));
        }
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Donate);
    }
}

