/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.ChatChannel;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandChat
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.chat");
    }

    @Override
    public String[] getUsage() {
        return new String[]{Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Chat_Help_Kingdom), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Chat_Help_Ally), Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Chat_Help_Public)};
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Not_In_Kingdom));
            return;
        }
        String poll = args.poll();
        if (poll.equalsIgnoreCase("k")) {
            kp.setChannel(ChatChannel.KINGDOM);
        } else if (poll.equalsIgnoreCase("a")) {
            kp.setChannel(ChatChannel.ALLY);
        } else if (poll.equalsIgnoreCase("p")) {
            kp.setChannel(ChatChannel.PUBLIC);
        } else {
            kp.setChannel(ChatChannel.PUBLIC);
        }
        kp.sendMessage(ChatColor.GREEN + "Current Channel: " + (Object)((Object)kp.getChannel()));
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Chat);
    }
}

