/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.user;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.Rank;
import org.kingdoms.constants.kingdom.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomMemberJoinEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandAccept
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 0;
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.player")) {
            return true;
        }
        return sender.hasPermission("kingdoms.accept");
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> args) {
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        if (kp.getInvited() == null) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Accept_No_Invite_Error));
            return;
        }
        Kingdom kingdom = kp.getInvited();
        if (kingdom.getMembersList().size() + 1 > kingdom.getMaxMember()) {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Accept_Kingdom_Full_Error));
            return;
        }
        kp.setInvited(null);
        kp.setRank(Rank.ALL);
        kp.setKingdom(kingdom);
        kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Accept_Success).replaceAll("%kingdom%", kingdom.getKingdomName()));
        if (kingdom.getKingdomLore() != null) {
            kp.sendMessage(kingdom.getKingdomLore());
        }
        Bukkit.getPluginManager().callEvent((Event)new KingdomMemberJoinEvent(kp, kingdom));
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Accept);
    }
}

