/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandAdminPacifistToggle
extends KCommandBase {
    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.admin")) {
            return true;
        }
        return sender.hasPermission("kingdoms.admin.pacifisttoggle");
    }

    @Override
    public void executeCommandConsole(Queue<String> arguments) {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        String kingdomName = arguments.poll();
        Kingdoms.logDebug((String)kingdomName);
        OfflineKingdom kingdom = GameManagement.getKingdomManager().getOfflineKingdom(kingdomName);
        if (kingdom != null) {
            if (kingdom.isNeutral()) {
                kingdom.setNeutral(false);
                sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_PacifistToggle_False).replaceAll("%kingdom%", kingdomName));
            } else {
                kingdom.setNeutral(true);
                sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_PacifistToggle_True).replaceAll("%kingdom%", kingdomName));
            }
        }
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> arguments) {
        String kingdomName = arguments.poll();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        OfflineKingdom kingdom = GameManagement.getKingdomManager().getOfflineKingdom(kingdomName);
        if (kingdom != null) {
            if (!Kingdoms.config.pacifistEnabled) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_PacifistToggle_Warning));
            }
            if (kingdom.isNeutral()) {
                kingdom.setNeutral(false);
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_PacifistToggle_False).replaceAll("%kingdom%", kingdomName));
            } else {
                kingdom.setNeutral(true);
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_PacifistToggle_True).replaceAll("%kingdom%", kingdomName));
            }
        } else {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Disband_KingdomNoutFound));
        }
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Admin_PacifistToggle);
    }
}

