/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.constants.kingdom.OfflineKingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.GameManagement;

public class KCommandAdminDisband
extends KCommandBase {
    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.admin")) {
            return true;
        }
        return sender.hasPermission("kingdoms.admin.disband");
    }

    @Override
    public void executeCommandConsole(Queue<String> arguments) {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        String kingdomName = arguments.poll();
        Kingdoms.logDebug((String)kingdomName);
        OfflineKingdom kingdom = GameManagement.getKingdomManager().getOfflineKingdom(kingdomName);
        if (kingdom != null) {
            if (GameManagement.getKingdomManager().deleteKingdom(kingdom.getKingdomName())) {
                sender.sendMessage("[Kingdoms] " + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Disband_Success).replaceAll("%kingdom%", kingdom.getKingdomName()));
            } else {
                sender.sendMessage("[Kingdoms] " + Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Previous_Request_Processing));
            }
        }
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player user, Queue<String> arguments) {
        String kingdomName = arguments.poll();
        KingdomPlayer kp = GameManagement.getPlayerManager().getSession(user);
        OfflineKingdom kingdom = GameManagement.getKingdomManager().getOfflineKingdom(kingdomName);
        if (kingdom != null) {
            if (GameManagement.getKingdomManager().deleteKingdom(kingdom.getKingdomName())) {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Disband_Success).replaceAll("%kingdom%", kingdom.getKingdomName()));
            } else {
                kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Misc_Previous_Request_Processing));
            }
        } else {
            kp.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_Disband_KingdomNoutFound));
        }
    }

    @Override
    public String[] getUsage() {
        return null;
    }

    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Admin_Disband);
    }
}

