/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Queue;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KCommandBase;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.LanguageSupport;
import org.kingdoms.manager.game.ConquestManager;
import org.kingdoms.manager.game.GameManagement;

public class KCommandAdminCreateConquestMap
extends KCommandBase {
    @Override
    public int getArgsAmount() {
        return 1;
    }

    @Override
    public String[] getUsage() {
        return new String[]{ChatColor.GOLD + "/k admin createconquestmap [name]" + ChatColor.GRAY + " - " + ChatColor.WHITE + "[name] for map name"};
    }

    @Override
    public String getDescription() {
        return Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Help_Admin_CreateConquestMap);
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (sender.isOp()) {
            return true;
        }
        if (sender.hasPermission("kingdoms.admin")) {
            return true;
        }
        return sender.hasPermission("kingdoms.admin.createconquestmap");
    }

    @Override
    public void executeCommandConsole(Queue<String> args) {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        String mapName = args.poll();
        Kingdoms.getManagers();
        if (GameManagement.getConquestManager() == null) {
            sender.sendMessage("Either Conquests is not enabled in config, or you don't have worldedit.");
            return;
        }
        Kingdoms.getManagers();
        if (GameManagement.getConquestManager().createNewConquestMap(mapName)) {
            sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_CreateConquestMap_Success));
        } else {
            sender.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_CreateConquestMap_Failure));
            Kingdoms.getManagers();
            GameManagement.getConquestManager();
            for (String name : ConquestManager.maps.keySet()) {
                sender.sendMessage(ChatColor.AQUA + " - " + this.capitalize(name));
            }
        }
    }

    @Override
    public void executeCommandOP(Player op, Queue<String> args) {
        this.executeCommandUser(op, args);
    }

    @Override
    public void executeCommandUser(Player p, Queue<String> args) {
        String mapName = args.poll();
        Kingdoms.getManagers();
        if (GameManagement.getConquestManager() == null) {
            p.sendMessage("Either Conquests is not enabled in config, or you don't have worldedit.");
            return;
        }
        Kingdoms.getManagers();
        if (GameManagement.getConquestManager().createNewConquestMap(mapName)) {
            p.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_CreateConquestMap_Success));
        } else {
            p.sendMessage(Kingdoms.getLang().parseFirstString(LanguageSupport.Languages.Command_Admin_CreateConquestMap_Failure));
            Kingdoms.getManagers();
            GameManagement.getConquestManager();
            for (String name : ConquestManager.maps.keySet()) {
                p.sendMessage(ChatColor.AQUA + " - " + this.capitalize(name));
            }
        }
    }

    private String capitalize(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }
}

