/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.utils.VaultHandler;
import java.util.HashMap;
import java.util.Iterator;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MVEconomist {
    private final VaultHandler vaultHandler;

    public MVEconomist(Plugin plugin) {
        this.vaultHandler = new VaultHandler(plugin);
    }

    private boolean isUsingVault(int currency) {
        return !MVEconomist.isItemCurrency(currency) && this.getVaultHandler().hasEconomy();
    }

    public boolean isUsingEconomyPlugin() {
        return this.getVaultHandler().hasEconomy();
    }

    public String formatPrice(double amount, int currency) {
        if (this.isUsingVault(currency)) {
            return this.getVaultHandler().getEconomy().format(amount);
        }
        return ItemEconomy.getFormattedPrice(amount, currency);
    }

    public String getEconomyName() {
        if (this.getVaultHandler().hasEconomy()) {
            return this.getVaultHandler().getEconomy().getName();
        }
        return ItemEconomy.getName();
    }

    public boolean isPlayerWealthyEnough(Player player, double amount, int currency) {
        if (amount <= 0.0) {
            return true;
        }
        if (this.isUsingVault(currency)) {
            return this.getVaultHandler().getEconomy().has((OfflinePlayer)player, amount);
        }
        return ItemEconomy.hasEnough(player, amount, currency);
    }

    public String getNSFMessage(int currency, String message) {
        return "Sorry, you don't have enough " + (MVEconomist.isItemCurrency(currency) ? "items" : "funds") + ". " + message;
    }

    public void deposit(Player player, double amount, int currency) {
        if (this.isUsingVault(currency)) {
            this.getVaultHandler().getEconomy().depositPlayer((OfflinePlayer)player, amount);
        } else {
            ItemEconomy.deposit(player, amount, currency);
        }
    }

    public void withdraw(Player player, double amount, int currency) {
        if (this.isUsingVault(currency)) {
            this.getVaultHandler().getEconomy().withdrawPlayer((OfflinePlayer)player, amount);
        } else {
            ItemEconomy.withdraw(player, amount, currency);
        }
    }

    public double getBalance(Player player) throws IllegalStateException {
        return this.getBalance(player, null);
    }

    public double getBalance(Player player, World world) throws IllegalStateException {
        if (!this.isUsingEconomyPlugin()) {
            throw new IllegalStateException("getBalance is only available when using an economy plugin with Vault");
        }
        if (world != null) {
            return this.getVaultHandler().getEconomy().getBalance((OfflinePlayer)player, world.getName());
        }
        return this.getVaultHandler().getEconomy().getBalance((OfflinePlayer)player);
    }

    public void setBalance(Player player, double amount) throws IllegalStateException {
        this.setBalance(player, null, amount);
    }

    public void setBalance(Player player, World world, double amount) throws IllegalStateException {
        if (!this.isUsingEconomyPlugin()) {
            throw new IllegalStateException("getBalance is only available when using an economy plugin with Vault");
        }
        if (world != null) {
            this.getVaultHandler().getEconomy().withdrawPlayer((OfflinePlayer)player, world.getName(), this.getBalance(player, world));
            this.getVaultHandler().getEconomy().depositPlayer((OfflinePlayer)player, world.getName(), amount);
        } else {
            this.getVaultHandler().getEconomy().withdrawPlayer((OfflinePlayer)player, this.getBalance(player));
            this.getVaultHandler().getEconomy().depositPlayer((OfflinePlayer)player, amount);
        }
    }

    @Deprecated
    public VaultHandler getVaultHandler() {
        return this.vaultHandler;
    }

    public static boolean isItemCurrency(int currency) {
        return currency >= 0;
    }

    private static class ItemEconomy {
        private static final String ECONOMY_NAME = "Simple Item Economy";

        private ItemEconomy() {
        }

        private static String getFormattedPrice(double amount, int currency) {
            if (MVEconomist.isItemCurrency(currency)) {
                Material m = Material.getMaterial((int)currency);
                return m != null ? amount + " " + m.toString() : "NO ITEM FOUND";
            }
            return "";
        }

        private static String getName() {
            return ECONOMY_NAME;
        }

        private static boolean hasEnough(Player player, double amount, int currency) {
            if (MVEconomist.isItemCurrency(currency)) {
                return player.getInventory().contains(currency, (int)amount);
            }
            return true;
        }

        private static void deposit(Player player, double amount, int currency) {
            if (MVEconomist.isItemCurrency(currency)) {
                ItemEconomy.giveItem(player, amount, currency);
            }
        }

        private static void withdraw(Player player, double amount, int currency) {
            if (MVEconomist.isItemCurrency(currency)) {
                ItemEconomy.takeItem(player, amount, currency);
            }
        }

        private static void giveItem(Player player, double amount, int type) {
            ItemStack item = new ItemStack(type, (int)amount);
            player.getInventory().addItem(new ItemStack[]{item});
            ItemEconomy.showReceipt(player, amount * -1.0, type);
        }

        private static void takeItem(Player player, double amount, int type) {
            int removed = 0;
            HashMap items = player.getInventory().all(type);
            Iterator i$ = items.keySet().iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if ((double)removed >= amount) break;
                int diff = (int)(amount - (double)removed);
                int amt = player.getInventory().getItem(i).getAmount();
                if (amt - diff > 0) {
                    player.getInventory().getItem(i).setAmount(amt - diff);
                    break;
                }
                removed += amt;
                player.getInventory().clear(i);
            }
            ItemEconomy.showReceipt(player, amount, type);
        }

        private static void showReceipt(Player player, double price, int item) {
            if (price > 0.0) {
                player.sendMessage(String.format("%s%s%s %s", ChatColor.WHITE, "You have been charged", ChatColor.GREEN, ItemEconomy.getFormattedPrice(price, item)));
            } else if (price < 0.0) {
                player.sendMessage(String.format("%s%s%s %s", ChatColor.DARK_GREEN, ItemEconomy.getFormattedPrice(price * -1.0, item), ChatColor.WHITE, "has been added to your inventory."));
            }
        }
    }
}

