/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.TargetSelectors;

import java.util.HashSet;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractWorld;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.SkillCaster;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.TargetSelectors.ILocationSelector;

public class MTRing
extends ILocationSelector {
    double radius;
    double yOffset;
    int points;

    public MTRing(MythicLineConfig mlc) {
        this.radius = mlc.getDouble("radius", 5.0);
        this.radius = mlc.getDouble("r", this.radius);
        this.points = mlc.getInteger("points", 10);
        this.points = mlc.getInteger("p", this.points);
        this.yOffset = mlc.getDouble("yoffset", 0.0);
        this.yOffset = mlc.getDouble("y", this.yOffset);
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        AbstractLocation l = am.getEntity().getLocation();
        double bx = l.getX();
        double y = l.getY();
        double bz = l.getZ();
        AbstractWorld w = l.getWorld();
        if (this.points <= 0) {
            this.points = 1;
        }
        float inc = 360 / this.points;
        for (double i = 0.0; i < 360.0; i += (double)inc) {
            double angle = i * Math.PI / 180.0;
            double x = (int)(bx + this.radius * Math.cos(angle));
            double z = (int)(bz + this.radius * Math.sin(angle));
            AbstractLocation l2 = MythicMobs.plugin.getMinecraftServer().newLocation(w, x, y + this.yOffset, z);
            targets.add(l2);
        }
        return targets;
    }
}

