/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.TargetSelectors;

import java.util.HashSet;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractVector;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.TargetSelectors.ILocationSelector;

public class LineTargeter
extends ILocationSelector {
    protected float radius = 1.0f;
    protected float radiusSq;
    protected boolean fromOrigin = false;

    public LineTargeter(MythicLineConfig mlc) {
        this.radius = mlc.getFloat(new String[]{"radius", "r"}, this.radius);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.radiusSq = this.radius * this.radius;
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        AbstractLocation sl = this.fromOrigin ? data.getOrigin().clone() : data.getCaster().getLocation();
        double range = 1.0;
        if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0) {
            for (AbstractLocation l2 : data.getLocationTargets()) {
                double d = l2.distanceSquared(sl);
                if (!(d > range)) continue;
                range = d;
            }
        } else if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0) {
            for (AbstractEntity l3 : data.getEntityTargets()) {
                double d = l3.getLocation().distanceSquared(sl);
                if (!(d > range)) continue;
                range = d;
            }
        } else {
            return targets;
        }
        if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0) {
            data.getLocationTargets().forEach(l -> {
                MythicMobs.log("A");
                int c = (int)Math.ceil(sl.distance((AbstractLocation)l) / (double)this.radius) - 1;
                if (c <= 0) {
                    return;
                }
                AbstractVector v = l.toVector().subtract(sl.toVector()).normalize().multiply(this.radius);
                AbstractLocation l2 = sl.clone();
                for (int i = 0; i < c; ++i) {
                    l2.add(v);
                    targets.add(l2.clone());
                }
            });
        } else if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0) {
            data.getEntityTargets().forEach(ee -> {
                AbstractLocation l = ee.getLocation();
                int c = (int)Math.ceil(sl.distance(l) / (double)this.radius) - 1;
                if (c <= 0) {
                    return;
                }
                AbstractVector v = l.toVector().subtract(sl.toVector()).normalize().multiply(this.radius);
                AbstractLocation l2 = sl.clone();
                for (int i = 0; i < c; ++i) {
                    l2.add(v);
                    targets.add(l2.clone());
                }
            });
        }
        return targets;
    }
}

